/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.plugins.tracker.dht.DHTTrackerPlugin;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.Locale;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AbstractTrackerCell;

public class SeedsItem
extends CoreTableColumnSWT
implements TableCellAddedListener,
ParameterListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    private static final String CFG_FC_SEEDSTART = "StartStopManager_iFakeFullCopySeedStart";
    private static final String CFG_FC_NUMPEERS = "StartStopManager_iNumPeersAsFullCopy";
    private static final String CFG_SHOW_ICON = "SeedsColumn.showNetworkIcon";
    public static final String COLUMN_ID = "seeds";
    private static String textStarted;
    private static String textStartedOver;
    private static String textNotStarted;
    private static String textStartedNoScrape;
    private static String textNotStartedNoScrape;
    private boolean showIcon;
    private static Image i2p_img;
    private static Image none_img;
    private int iFC_MinSeeds;
    private int iFC_NumPeers;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm"});
    }

    public SeedsItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 60, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
        this.iFC_MinSeeds = COConfigurationManager.getIntParameter(CFG_FC_SEEDSTART);
        this.iFC_NumPeers = COConfigurationManager.getIntParameter(CFG_FC_NUMPEERS);
        this.showIcon = COConfigurationManager.getBooleanParameter(CFG_SHOW_ICON);
        COConfigurationManager.addParameterListener(CFG_FC_SEEDSTART, (ParameterListener)this);
        COConfigurationManager.addParameterListener(CFG_FC_NUMPEERS, (ParameterListener)this);
        COConfigurationManager.addParameterListener(CFG_SHOW_ICON, (ParameterListener)this);
        TableContextMenuItem menuShowIcon = this.addContextMenuItem("ConfigView.section.style.showNetworksIcon", 1);
        menuShowIcon.setStyle(2);
        menuShowIcon.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(SeedsItem.this.showIcon);
            }
        });
        menuShowIcon.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter(SeedsItem.CFG_SHOW_ICON, (Boolean)menu.getData());
            }
        });
    }

    @Override
    public void reset() {
        super.reset();
        COConfigurationManager.removeParameter(CFG_SHOW_ICON);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        COConfigurationManager.removeParameterListener(CFG_FC_SEEDSTART, this);
        COConfigurationManager.removeParameterListener(CFG_FC_NUMPEERS, this);
        COConfigurationManager.removeParameterListener(CFG_SHOW_ICON, this);
    }

    @Override
    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.iFC_MinSeeds = COConfigurationManager.getIntParameter(CFG_FC_SEEDSTART);
        this.iFC_NumPeers = COConfigurationManager.getIntParameter(CFG_FC_NUMPEERS);
        this.setShowIcon(COConfigurationManager.getBooleanParameter(CFG_SHOW_ICON));
    }

    public void setShowIcon(boolean b) {
        this.showIcon = b;
        this.invalidateCells();
    }

    static {
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            @Override
            public void localeChanged(Locale old_locale, Locale new_locale) {
                textStarted = MessageText.getString("Column.seedspeers.started");
                textStartedOver = MessageText.getString("Column.seedspeers.started.over");
                textNotStarted = MessageText.getString("Column.seedspeers.notstarted");
                textStartedNoScrape = MessageText.getString("Column.seedspeers.started.noscrape");
                textNotStartedNoScrape = MessageText.getString("Column.seedspeers.notstarted.noscrape");
            }
        });
        ImageLoader imageLoader = ImageLoader.getInstance();
        i2p_img = imageLoader.getImage("net_I2P_x");
        none_img = imageLoader.getImage("net_None_x");
    }

    private class Cell
    extends AbstractTrackerCell
    implements TableCellMouseListener {
        private long lTotalPeers;
        private long lTotalSeeds;

        public Cell(TableCell cell) {
            super(cell);
            this.lTotalPeers = 0L;
            this.lTotalSeeds = -1L;
        }

        @Override
        public void scrapeResult(TRTrackerScraperResponse response) {
            if (this.checkScrapeResult(response)) {
                this.lTotalSeeds = response.getSeeds();
                this.lTotalPeers = response.getPeers();
            }
        }

        @Override
        public void refresh(TableCell cell) {
            String text;
            super.refresh(cell);
            long lConnectedSeeds = 0L;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm != null) {
                TRTrackerScraperResponse response;
                lConnectedSeeds = dm.getNbSeeds();
                if (this.lTotalSeeds == -1L && (response = dm.getTrackerScrapeResponse()) != null && response.isValid()) {
                    this.lTotalSeeds = response.getSeeds();
                    this.lTotalPeers = response.getPeers();
                }
                if (cell instanceof TableCellSWT) {
                    int totalI2PSeeds;
                    int[] i2p_info = (int[])dm.getUserData(DHTTrackerPlugin.DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY);
                    Image icon = none_img;
                    if (i2p_info != null && SeedsItem.this.showIcon && (totalI2PSeeds = i2p_info[0]) > 0) {
                        icon = i2p_img;
                    }
                    ((TableCellSWT)cell).setIcon(icon);
                }
            }
            long value = lConnectedSeeds << 42;
            if (this.lTotalSeeds > 0L) {
                value += this.lTotalSeeds << 21;
            }
            if (this.lTotalPeers > 0L) {
                value += this.lTotalPeers;
            }
            if (dm != null) {
                boolean hasScrape;
                boolean bCompleteTorrent = dm.getAssumedComplete();
                int state = dm.getState();
                boolean started = state == 60 || state == 50;
                boolean bl = hasScrape = this.lTotalSeeds >= 0L;
                if (started) {
                    text = hasScrape ? (lConnectedSeeds > this.lTotalSeeds ? textStartedOver : textStarted) : textStartedNoScrape;
                } else {
                    String string = text = hasScrape ? textNotStarted : textNotStartedNoScrape;
                }
                if (text.length() == 0) {
                    value = Integer.MIN_VALUE;
                    long cache = dm.getDownloadState().getLongAttribute("scrapecache");
                    if (cache != -1L) {
                        int seeds = (int)(cache >> 32 & 0xFFFFFFL);
                        value += (long)(seeds + 1);
                    }
                }
                if (!cell.setSortValue(value) && cell.isValid()) {
                    return;
                }
                text = text.replaceAll("%1", String.valueOf(lConnectedSeeds));
                String param2 = "?";
                if (this.lTotalSeeds != -1L) {
                    long lSeedsToAdd;
                    param2 = String.valueOf(this.lTotalSeeds);
                    if (bCompleteTorrent && SeedsItem.this.iFC_NumPeers > 0 && this.lTotalSeeds >= (long)SeedsItem.this.iFC_MinSeeds && this.lTotalPeers > 0L && (lSeedsToAdd = this.lTotalPeers / (long)SeedsItem.this.iFC_NumPeers) > 0L) {
                        param2 = param2 + "+" + lSeedsToAdd;
                    }
                }
                text = text.replaceAll("%2", param2);
            } else {
                text = "";
                value = Integer.MIN_VALUE;
                if (!cell.setSortValue(value) && cell.isValid()) {
                    return;
                }
            }
            cell.setText(text);
        }

        @Override
        public void cellHover(TableCell cell) {
            super.cellHover(cell);
            long lConnectedSeeds = 0L;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm != null) {
                int totalI2PSeeds;
                int[] i2p_info;
                int seeds;
                long cache;
                lConnectedSeeds = dm.getNbSeeds();
                String sToolTip = lConnectedSeeds + " " + MessageText.getString("GeneralView.label.connected") + "\n";
                if (this.lTotalSeeds != -1L) {
                    sToolTip = sToolTip + this.lTotalSeeds + " " + MessageText.getString("GeneralView.label.in_swarm");
                } else {
                    TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
                    sToolTip = sToolTip + "?? " + MessageText.getString("GeneralView.label.in_swarm");
                    if (response != null) {
                        sToolTip = sToolTip + "(" + response.getStatusString() + ")";
                    }
                }
                boolean bCompleteTorrent = dm.getAssumedComplete();
                if (bCompleteTorrent && SeedsItem.this.iFC_NumPeers > 0 && this.lTotalSeeds >= (long)SeedsItem.this.iFC_MinSeeds && this.lTotalPeers > 0L) {
                    long lSeedsToAdd = this.lTotalPeers / (long)SeedsItem.this.iFC_NumPeers;
                    sToolTip = sToolTip + "\n" + MessageText.getString("TableColumn.header.seeds.fullcopycalc", new String[]{"" + this.lTotalPeers, "" + lSeedsToAdd});
                }
                if ((cache = dm.getDownloadState().getLongAttribute("scrapecache")) != -1L && (long)(seeds = (int)(cache >> 32 & 0xFFFFFFL)) != this.lTotalSeeds) {
                    sToolTip = sToolTip + "\n" + seeds + " " + MessageText.getString("Scrape.status.cached").toLowerCase(Locale.US);
                }
                if ((i2p_info = (int[])dm.getUserData(DHTTrackerPlugin.DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY)) != null && (totalI2PSeeds = i2p_info[0]) > 0) {
                    sToolTip = sToolTip + "\n" + MessageText.getString("TableColumn.header.peers.i2p", new String[]{String.valueOf(totalI2PSeeds)});
                }
                cell.setToolTip(sToolTip);
            } else {
                cell.setToolTip("");
            }
        }

        @Override
        public void cellMouseTrigger(TableCellMouseEvent event2) {
            DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
            if (dm == null) {
                return;
            }
            if (event2.eventType != 2) {
                return;
            }
            event2.skipCoreFunctionality = true;
            int[] i2p_info = (int[])dm.getUserData(DHTTrackerPlugin.DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY);
            if (i2p_info != null && i2p_info[0] > 0) {
                Utils.launch(MessageText.getString("privacy.view.wiki.url"));
            }
        }
    }
}

