/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class RemainingItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    public static final String COLUMN_ID = "remaining";
    private boolean bLastValueEstimate = false;

    public RemainingItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content", "progress"});
    }

    @Override
    public void refresh(TableCell cell) {
        long lRemaining = this.getRemaining(cell);
        if (!cell.setSortValue(lRemaining) && cell.isValid()) {
            return;
        }
        if (this.bLastValueEstimate) {
            cell.setText("~ " + DisplayFormatters.formatByteCountToKiBEtc(lRemaining));
        } else {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(lRemaining));
        }
    }

    private long getRemaining(TableCell cell) {
        Object ds = cell.getDataSource();
        if (ds instanceof DownloadManager) {
            DownloadManager manager = (DownloadManager)cell.getDataSource();
            if (manager != null) {
                return manager.getStats().getRemainingExcludingDND();
            }
        } else if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            return fileInfo2.getLength() - fileInfo2.getDownloaded();
        }
        return 0L;
    }
}

