/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class RankItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "#";
    private String showIconKey;
    private boolean showIcon;
    private Image imgUp;
    private Image imgDown;
    private boolean bInvalidByTrigger = false;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public RankItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 50, sTableID);
        this.setRefreshInterval(-3);
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().addListener(new GMListener());
            }
        });
        this.setMaxWidthAuto(true);
        this.setMinWidthAuto(true);
        this.showIconKey = "RankColumn.showUpDownIcon." + (sTableID.endsWith(".big") ? "big" : "small");
        TableContextMenuItem menuShowIcon = this.addContextMenuItem("ConfigView.section.style.showRankIcon", 1);
        menuShowIcon.setStyle(2);
        menuShowIcon.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(RankItem.this.showIcon);
            }
        });
        menuShowIcon.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter(RankItem.this.showIconKey, (Boolean)menu.getData());
            }
        });
        COConfigurationManager.addAndFireParameterListener(this.showIconKey, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                RankItem.this.invalidateCells();
                RankItem.this.showIcon = COConfigurationManager.getBooleanParameter(RankItem.this.showIconKey);
            }
        });
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.imgUp = imageLoader.getImage("image.torrentspeed.up");
        this.imgDown = imageLoader.getImage("image.torrentspeed.down");
    }

    @Override
    public void remove() {
        super.remove();
        COConfigurationManager.removeParameter(this.showIconKey);
    }

    @Override
    public void refresh(TableCell cell) {
        boolean complete;
        this.bInvalidByTrigger = false;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long value = dm == null ? 0L : (long)dm.getPosition();
        String text = "" + value;
        boolean bl = complete = dm == null ? false : dm.getAssumedComplete();
        if (complete) {
            value += 65536L;
        }
        cell.setSortValue(value);
        cell.setText(text);
        if (cell instanceof TableCellSWT) {
            if (this.showIcon && dm != null) {
                Image img = dm.getAssumedComplete() ? this.imgUp : this.imgDown;
                ((TableCellSWT)cell).setIcon(img);
            } else {
                ((TableCellSWT)cell).setIcon(null);
            }
        }
    }

    private class GMListener
    implements GlobalManagerListener {
        DownloadManagerListener listener;

        public GMListener() {
            this.listener = new DownloadManagerListener(){

                @Override
                public void completionChanged(DownloadManager manager, boolean bCompleted) {
                }

                @Override
                public void downloadComplete(DownloadManager manager) {
                }

                @Override
                public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
                    if (RankItem.this.bInvalidByTrigger) {
                        return;
                    }
                    RankItem.this.invalidateCells();
                    RankItem.this.bInvalidByTrigger = true;
                }

                @Override
                public void stateChanged(DownloadManager manager, int state) {
                }

                @Override
                public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
                }
            };
        }

        @Override
        public void destroyed() {
        }

        @Override
        public void destroyInitiated() {
            try {
                GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                gm.removeListener(this);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }

        @Override
        public void downloadManagerAdded(DownloadManager dm) {
            dm.addListener(this.listener);
        }

        @Override
        public void downloadManagerRemoved(DownloadManager dm) {
            dm.removeListener(this.listener);
        }

        @Override
        public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
        }
    }
}

