/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class PiecesItem
extends CoreTableColumnSWT
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellDisposeListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    private static final int INDEX_COLOR_NONEAVAIL = 10;
    private static final int borderHorizontalSize = 1;
    private static final int borderVerticalSize = 1;
    private static final int borderSplit = 1;
    private static final int completionHeight = 2;
    public static final String COLUMN_ID = "pieces";
    private int marginHeight = -1;

    public PiecesItem(String sTableID) {
        this(sTableID, -1);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content", "progress"});
        info.setProficiency((byte)1);
    }

    public PiecesItem(String sTableID, int marginHeight) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 100, sTableID);
        this.marginHeight = marginHeight;
        this.initializeAsGraphic(-1, 100);
        this.setMinWidth(100);
    }

    @Override
    public void cellAdded(TableCell cell) {
        if (this.marginHeight != -1) {
            cell.setMarginHeight(this.marginHeight);
        }
        cell.setFillCell(true);
    }

    @Override
    public void dispose(TableCell cell) {
        DownloadManager infoObj = (DownloadManager)cell.getDataSource();
        if (infoObj == null) {
            return;
        }
        Image img = (Image)infoObj.getUserData("PiecesImage");
        if (img != null && !img.isDisposed()) {
            img.dispose();
        }
        infoObj.setUserData("PiecesImageBuffer", null);
        infoObj.setUserData("PiecesImage", null);
    }

    @Override
    public void refresh(TableCell cell) {
        GC gcImage;
        Rectangle imageBounds;
        boolean bImageChanged;
        Image image;
        boolean bForce;
        DownloadManager infoObj = (DownloadManager)cell.getDataSource();
        long lCompleted = infoObj == null ? 0L : (long)infoObj.getStats().getCompleted();
        boolean bl = bForce = infoObj != null && infoObj.getUserData("PiecesImage") == null;
        if (!cell.setSortValue(lCompleted) && cell.isValid() && !bForce) {
            return;
        }
        if (infoObj == null) {
            return;
        }
        int newWidth = cell.getWidth();
        if (newWidth <= 0) {
            return;
        }
        int newHeight = cell.getHeight();
        int x0 = 1;
        int x1 = newWidth - 1 - 1;
        int y0 = 4;
        int y1 = newHeight - 1 - 1;
        int drawWidth = x1 - x0 + 1;
        if (drawWidth < 10 || y1 < 3) {
            return;
        }
        boolean bImageBufferValid = true;
        int[] imageBuffer = (int[])infoObj.getUserData("PiecesImageBuffer");
        if (imageBuffer == null || imageBuffer.length != drawWidth) {
            imageBuffer = new int[drawWidth];
            bImageBufferValid = false;
        }
        if ((image = (Image)infoObj.getUserData("PiecesImage")) == null || image.isDisposed()) {
            bImageChanged = true;
        } else {
            imageBounds = image.getBounds();
            boolean bl2 = bImageChanged = imageBounds.width != newWidth || imageBounds.height != newHeight;
        }
        if (bImageChanged) {
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
            image = new Image((Device)SWTThread.getInstance().getDisplay(), newWidth, newHeight);
            imageBounds = image.getBounds();
            bImageBufferValid = false;
            gcImage = new GC(image);
            gcImage.setForeground(Colors.grey);
            gcImage.drawRectangle(0, 0, newWidth - 1, newHeight - 1);
            gcImage.setForeground(Colors.white);
            gcImage.drawLine(x0, 3, x1, 3);
        } else {
            gcImage = new GC(image);
        }
        DiskManager disk_manager = infoObj.getDiskManager();
        DiskManagerPiece[] pieces = disk_manager == null ? null : disk_manager.getPieces();
        int nbPieces = infoObj.getNbPieces();
        try {
            int limit;
            int nbComplete = 0;
            int a1 = 0;
            for (int i = 0; i < drawWidth; ++i) {
                int index;
                int a0;
                if (i == 0) {
                    a0 = 0;
                    a1 = nbPieces / drawWidth;
                    if (a1 == 0) {
                        a1 = 1;
                    }
                } else {
                    a0 = a1;
                    a1 = (i + 1) * nbPieces / drawWidth;
                }
                if (a1 <= a0) {
                    index = imageBuffer[i - 1];
                } else {
                    int nbAvailable = 0;
                    for (int j = a0; j < a1; ++j) {
                        if (pieces == null || !pieces[j].isDone()) continue;
                        ++nbAvailable;
                    }
                    nbComplete += nbAvailable;
                    index = nbAvailable * 9 / (a1 - a0);
                }
                if (bImageBufferValid && imageBuffer[i] == index) continue;
                imageBuffer[i] = index;
                bImageChanged = true;
                gcImage.setForeground(index == 10 ? Colors.red : Colors.blues[index]);
                gcImage.drawLine(i + x0, y0, i + x0, y1);
            }
            int n = limit = nbPieces == 0 ? 0 : drawWidth * nbComplete / nbPieces;
            if (limit < drawWidth) {
                gcImage.setBackground(Colors.blues[0]);
                gcImage.fillRectangle(limit + x0, 1, x1 - limit, 2);
            }
            gcImage.setBackground(Colors.colorProgressBar);
            gcImage.fillRectangle(x0, 1, limit, 2);
        }
        catch (Exception e) {
            System.out.println("Error Drawing PiecesItem");
            Debug.printStackTrace(e);
        }
        gcImage.dispose();
        Image oldImage = null;
        Graphic graphic = cell.getGraphic();
        if (graphic instanceof UISWTGraphic) {
            oldImage = ((UISWTGraphic)graphic).getImage();
        }
        if (bImageChanged || image != oldImage || !cell.isValid()) {
            if (cell instanceof TableCellSWT) {
                ((TableCellSWT)cell).setGraphic(image);
            } else {
                cell.setGraphic(new UISWTGraphicImpl(image));
            }
            if (bImageChanged) {
                cell.invalidate();
            }
            infoObj.setUserData("PiecesImage", image);
            infoObj.setUserData("PiecesImageBuffer", imageBuffer);
        }
    }
}

