/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class FileExtensionItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "fileext";

    public FileExtensionItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 50, sTableID);
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.setMinWidthAuto(true);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        int pos;
        String incomp_suffix;
        DownloadManager dm;
        Object ds = cell.getDataSource();
        String text = "";
        if (ds instanceof DownloadManager) {
            dm = (DownloadManager)ds;
            DiskManagerFileInfo prim = dm.getDownloadState().getPrimaryFile();
            text = prim == null ? "" : prim.getFile(true).getName();
        } else if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            dm = fileInfo2.getDownloadManager();
            text = fileInfo2.getFile(true).getName();
        } else {
            return;
        }
        String string = incomp_suffix = dm == null ? null : dm.getDownloadState().getAttribute("incompfilesuffix");
        if (incomp_suffix != null && text.endsWith(incomp_suffix)) {
            text = text.substring(0, text.length() - incomp_suffix.length());
        }
        text = (pos = text.lastIndexOf(".")) >= 0 ? text.substring(pos + 1) : "";
        cell.setText(text);
    }
}

