/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class DownSpeedLimitItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    public static final String COLUMN_ID = "maxdownspeed";

    public DownSpeedLimitItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 35, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
        info.setProficiency((byte)2);
    }

    @Override
    public void refresh(TableCell cell) {
        long value;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long l = value = dm == null ? 0L : (long)dm.getStats().getDownloadRateLimitBytesPerSecond();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        if (value == -1L) {
            cell.setText(MessageText.getString("MyTorrents.items.DownSpeedLimit.disabled"));
        } else if (value == 0L) {
            cell.setText("\u221e");
        } else {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(value));
        }
    }
}

