/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.plugins.startstoprules.defaultplugin.DefaultRankCalculator;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesDefaultPlugin;
import org.eclipse.swt.graphics.Color;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class DownSpeedItem
extends CoreTableColumnSWT
implements TableCellAddedListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    public static final String COLUMN_ID = "downspeed";

    public DownSpeedItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 60, sTableID);
        this.setType(1);
        this.addDataSourceType(org.gudy.azureus2.core3.disk.DiskManagerFileInfo.class);
        this.setRefreshInterval(-2);
        this.setUseCoreDataSource(false);
        this.setMinWidthAuto(true);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "bytes"});
        info.setProficiency((byte)0);
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.addRefreshListener(new RefreshListener());
    }

    private static class RefreshListener
    implements TableCellRefreshListener {
        private int iLastState;
        private int loop = 0;

        private RefreshListener() {
        }

        @Override
        public void refresh(TableCell cell) {
            Object ds = cell.getDataSource();
            if (ds instanceof DiskManagerFileInfo) {
                try {
                    org.gudy.azureus2.core3.disk.DiskManagerFileInfo fileInfo2 = PluginCoreUtils.unwrap((DiskManagerFileInfo)ds);
                    int speed = fileInfo2.getWriteBytesPerSecond();
                    if (!cell.setSortValue(speed) && cell.isValid()) {
                        return;
                    }
                    cell.setText(speed == 0 ? "" : DisplayFormatters.formatByteCountToKiBEtcPerSec(speed));
                }
                catch (Throwable e) {}
            } else {
                boolean bChangeColor;
                long value;
                int iState;
                Download dm = (Download)ds;
                if (dm == null) {
                    iState = -1;
                    value = 0L;
                } else {
                    iState = dm.getState();
                    value = dm.getStats().getDownloadAverage();
                }
                boolean bl = bChangeColor = ++this.loop % 10 == 0;
                if (cell.setSortValue(value) || !cell.isValid() || iState != this.iLastState) {
                    cell.setText(value == 0L ? "" : DisplayFormatters.formatByteCountToKiBEtcPerSec(value));
                    bChangeColor = true;
                }
                if (bChangeColor && dm != null) {
                    this.changeColor(cell, dm, iState);
                    this.loop = 0;
                }
            }
        }

        private void changeColor(TableCell cell, Download dl, int iState) {
            try {
                DefaultRankCalculator calc = StartStopRulesDefaultPlugin.getRankCalculator(dl);
                Color newFG = null;
                if (calc != null && dl.getState() == 4 && !calc.getActivelyDownloading()) {
                    newFG = Colors.colorWarning;
                }
                cell.setForeground(Utils.colorToIntArray(newFG));
                this.iLastState = iState;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

