/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.tableitems.ColumnDateSizer;

public class DateLastActiveItem
extends ColumnDateSizer {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "DateTorrentLastActive";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time", "content"});
        info.setProficiency((byte)1);
    }

    public DateLastActiveItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setMultiline(false);
    }

    @Override
    public void refresh(TableCell cell, long timestamp) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            timestamp = 0L;
        } else {
            timestamp = dm.getDownloadState().getLongParameter("stats.download.last.active.time");
            if (timestamp == 0L) {
                timestamp = dm.getDownloadState().getLongParameter("stats.download.completed.time");
            }
            if (timestamp == 0L) {
                timestamp = dm.getDownloadState().getLongParameter("stats.download.added.time");
            }
        }
        super.refresh(cell, timestamp);
    }
}

