/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.tableitems.ColumnDateSizer;

public class DateFileCompletedItem
extends ColumnDateSizer {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "DateFileCompleted";

    public DateFileCompletedItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setRefreshInterval(-2);
        this.setMultiline(false);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time", "content"});
        info.setProficiency((byte)1);
    }

    public DateFileCompletedItem(String tableID, boolean v) {
        this(tableID);
        this.setVisible(v);
    }

    @Override
    public void refresh(TableCell cell, long timestamp) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long value = 0L;
        if (dm == null) {
            return;
        }
        value = dm.getDownloadState().getLongParameter("stats.download.file.completed.time");
        if (value <= 0L) {
            value = dm.getDownloadState().getLongParameter("stats.download.completed.time");
        }
        super.refresh(cell, value);
    }
}

