/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.tableitems.ColumnDateSizer;

public class DateCompletedItem
extends ColumnDateSizer {
    public static final Class DATASOURCE_TYPE = DownloadTypeComplete.class;
    public static final String COLUMN_ID = "DateCompleted";
    private static final long SHOW_ETA_AFTER_MS = 30000L;

    public DateCompletedItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setMultiline(false);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time", "content"});
        info.setProficiency((byte)0);
    }

    public DateCompletedItem(String tableID, boolean v) {
        this(tableID);
        this.setVisible(v);
    }

    @Override
    public void refresh(TableCell cell, long timestamp) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long value = 0L;
        if (dm == null) {
            return;
        }
        if (dm.isDownloadComplete(false)) {
            long completedTime = dm.getDownloadState().getLongParameter("stats.download.completed.time");
            value = completedTime <= 0L ? dm.getDownloadState().getLongParameter("stats.download.added.time") : completedTime;
        } else {
            long diff = SystemTime.getCurrentTime() - dm.getStats().getTimeStarted();
            if (diff > 30000L) {
                long eta = dm.getStats().getSmoothedETA();
                if (eta > 0L) {
                    String sETA = TimeFormatter.format(eta);
                    value = eta << 42;
                    if (value < 0L) {
                        value = Long.MAX_VALUE;
                    }
                    cell.setText(MessageText.getString("MyTorrents.column.ColumnProgressETA.2ndLine", new String[]{sETA}));
                } else {
                    cell.setText("");
                    value = SystemTime.getCurrentTime() / 1000L * 1001L;
                }
            } else {
                cell.setText("");
                value = SystemTime.getCurrentTime() / 1000L * 1002L;
            }
            cell.invalidate();
            cell.setSortValue(value);
            return;
        }
        super.refresh(cell, value);
    }

    @Override
    public void cellHover(TableCell cell) {
        long dateAdded;
        super.cellHover(cell);
        Object oTooltip = cell.getToolTip();
        String s = oTooltip instanceof String ? (String)oTooltip + "\n" : "";
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long l = dateAdded = dm == null ? 0L : dm.getDownloadState().getLongParameter("stats.download.added.time");
        if (dateAdded != 0L) {
            s = s + MessageText.getString("TableColumn.header.date_added") + ": " + DisplayFormatters.formatDate(dateAdded) + " (" + DisplayFormatters.formatETA((SystemTime.getCurrentTime() - dateAdded) / 1000L, false) + ")";
            cell.setToolTip(s);
        }
    }
}

