/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class CommentItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellMouseListener,
ObfusticateCellText {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "comment";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public CommentItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 300, sTableID);
        this.setRefreshInterval(-2);
        this.setType(1);
        this.setObfustication(true);
        this.setMinWidth(50);
    }

    @Override
    public void refresh(TableCell cell) {
        String comment = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        comment = dm.getDownloadState().getUserComment();
        if (comment != null) {
            comment = comment.replace('\r', ' ').replace('\n', ' ');
        }
        cell.setText(comment == null ? "" : comment);
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
        if (dm == null) {
            return;
        }
        event2.skipCoreFunctionality = true;
        if (event2.eventType != 2) {
            return;
        }
        TorrentUtil.promptUserForComment(new DownloadManager[]{dm});
    }

    @Override
    public String getObfusticatedText(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        return Integer.toHexString(dm.hashCode());
    }
}

