/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import java.util.Locale;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.tableitems.ColumnDateSizer;

public class BadAvailTimeItem
extends ColumnDateSizer {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "bad_avail_time";
    private static String now_string;

    public BadAvailTimeItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm", "time"});
        info.setProficiency((byte)2);
    }

    @Override
    public void refresh(TableCell cell, long timestamp) {
        long value;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long l = value = dm == null ? -1L : dm.getStats().getAvailWentBadTime();
        if (value == 0L) {
            long stopped;
            PEPeerManager pm = dm.getPeerManager();
            value = pm == null || (double)pm.getMinAvailability() < 1.0 ? ((stopped = dm.getDownloadState().getLongAttribute("timestopped")) > 0L ? stopped : -1L) : -2L;
        }
        if (value > 0L) {
            super.refresh(cell, value);
        } else {
            String text = value == -2L ? now_string : "";
            if (!cell.setSortValue(value) && cell.isValid()) {
                return;
            }
            cell.setText(text);
        }
    }

    static {
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            @Override
            public void localeChanged(Locale old_locale, Locale new_locale) {
                now_string = MessageText.getString("SpeedView.stats.now");
            }
        });
    }
}

