/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class AvgAvailItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    private static final String zeros = "0000";
    private static final int numZeros = "0000".length();
    public static final String COLUMN_ID = "AvgAvail";
    private int iTimesBy;

    public AvgAvailItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 50, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
        this.iTimesBy = 1;
        for (int i = 1; i < numZeros; ++i) {
            this.iTimesBy *= 10;
        }
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm"});
    }

    @Override
    public void refresh(TableCell cell) {
        String sText = "";
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            return;
        }
        PEPeerManager pm = dm.getPeerManager();
        if (pm != null) {
            float f = pm.getAvgAvail();
            if (!cell.setSortValue((long)(f * 1000.0f)) && cell.isValid()) {
                return;
            }
            sText = String.valueOf((int)(f * (float)this.iTimesBy));
            if (numZeros - sText.length() > 0) {
                sText = zeros.substring(0, numZeros - sText.length()) + sText;
            }
            sText = sText.substring(0, sText.length() - numZeros + 1) + "." + sText.substring(sText.length() - numZeros + 1);
        } else {
            cell.setSortValue(0L);
        }
        cell.setText(sText);
    }
}

