/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class AlertsItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    private static final UISWTGraphic black_tick_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("blacktick"));
    private static final UISWTGraphic gray_tick_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("graytick"));
    public static final String COLUMN_ID = "alerts";

    public AlertsItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 60, sTableID);
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.setRefreshInterval(-2);
        this.initializeAsGraphic(-1, 60);
        this.setMinWidth(20);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"connection"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        DiskManagerFileInfo fi;
        DownloadManager dm;
        Map map;
        UISWTGraphic icon = null;
        int sort = 0;
        Object ds = cell.getDataSource();
        if (ds instanceof DownloadManager) {
            DownloadManager dm2 = (DownloadManager)ds;
            Map map2 = dm2.getDownloadState().getMapAttribute("df_alerts");
            if (map2 != null && map2.size() > 0) {
                for (String k : map2.keySet()) {
                    if (k.length() <= 0) continue;
                    if (Character.isDigit(k.charAt(0))) {
                        icon = gray_tick_icon;
                        sort = 1;
                        continue;
                    }
                    icon = black_tick_icon;
                    sort = 2;
                    break;
                }
            }
        } else if (ds instanceof DiskManagerFileInfo && (map = (dm = (fi = (DiskManagerFileInfo)ds).getDownloadManager()).getDownloadState().getMapAttribute("df_alerts")) != null && map.size() > 0) {
            String prefix = fi.getIndex() + ".";
            for (String k : map.keySet()) {
                if (!k.startsWith(prefix)) continue;
                icon = black_tick_icon;
                sort = 2;
                break;
            }
        }
        cell.setSortValue(sort);
        if (cell.getGraphic() != icon) {
            cell.setGraphic(icon);
        }
    }
}

