/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellLightRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class ProgressGraphItem
extends CoreTableColumnSWT
implements TableCellAddedListener,
TableCellDisposeListener,
TableCellVisibilityListener {
    private static final int borderWidth = 1;

    public ProgressGraphItem() {
        super("pieces", "Files");
        this.initializeAsGraphic(-2, 200);
        this.setMinWidth(100);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
        info.setProficiency((byte)0);
    }

    @Override
    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    @Override
    public void cellVisibilityChanged(TableCell cell, int visibility) {
        if (visibility == 1) {
            this.dispose(cell);
        }
    }

    @Override
    public void dispose(TableCell cell) {
        Image img;
        Graphic graphic = cell.getGraphic();
        if (graphic instanceof UISWTGraphic && (img = ((UISWTGraphic)graphic).getImage()) != null && !img.isDisposed()) {
            img.dispose();
            ((UISWTGraphic)graphic).setImage(null);
        }
    }

    private class Cell
    implements TableCellLightRefreshListener {
        int lastPercentDone = 0;
        private long last_draw_time = SystemTime.getCurrentTime();
        private boolean bNoRed = false;
        private boolean was_running = false;

        public Cell(TableCell cell) {
            cell.setFillCell(true);
            cell.addListeners(this);
        }

        @Override
        public void refresh(TableCell cell) {
            this.refresh(cell, false);
        }

        @Override
        public void refresh(TableCell cell, boolean sortOnly) {
            boolean bImageBufferValid;
            int sortOrder;
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
            DiskManager manager = fileInfo2 == null ? null : fileInfo2.getDiskManager();
            int percentDone = 0;
            if (manager == null) {
                sortOrder = -1;
            } else {
                if (fileInfo2 != null && fileInfo2.getLength() != 0L) {
                    percentDone = (int)(1000L * fileInfo2.getDownloaded() / fileInfo2.getLength());
                }
                sortOrder = percentDone;
            }
            cell.setSortValue(sortOrder);
            if (sortOnly) {
                ProgressGraphItem.this.dispose(cell);
                return;
            }
            int newWidth = cell.getWidth();
            if (newWidth <= 0) {
                return;
            }
            int newHeight = cell.getHeight();
            int x1 = newWidth - 1 - 1;
            int y1 = newHeight - 1 - 1;
            if (x1 < 10 || y1 < 3) {
                return;
            }
            boolean running = manager != null;
            boolean hasGraphic = false;
            Graphic graphic = cell.getGraphic();
            if (graphic instanceof UISWTGraphic) {
                Image img = ((UISWTGraphic)graphic).getImage();
                hasGraphic = img != null && !img.isDisposed();
            }
            boolean bl = bImageBufferValid = this.lastPercentDone == percentDone && cell.isValid() && this.bNoRed && running == this.was_running && hasGraphic;
            if (bImageBufferValid) {
                return;
            }
            this.was_running = running;
            this.lastPercentDone = percentDone;
            Image piecesImage = null;
            if (graphic instanceof UISWTGraphic) {
                piecesImage = ((UISWTGraphic)graphic).getImage();
            }
            if (piecesImage != null && !piecesImage.isDisposed()) {
                piecesImage.dispose();
            }
            if (!running) {
                cell.setGraphic(null);
                return;
            }
            piecesImage = new Image((Device)SWTThread.getInstance().getDisplay(), newWidth, newHeight);
            GC gcImage = new GC(piecesImage);
            DownloadManager download_manager = fileInfo2 == null ? null : fileInfo2.getDownloadManager();
            PEPeerManager peer_manager = download_manager == null ? null : download_manager.getPeerManager();
            PEPiece[] pe_pieces = peer_manager == null ? null : peer_manager.getPieces();
            long now = SystemTime.getCurrentTime();
            if (fileInfo2 != null && manager != null) {
                if (percentDone == 1000) {
                    gcImage.setForeground(Colors.blues[9]);
                    gcImage.setBackground(Colors.blues[9]);
                    gcImage.fillRectangle(1, 1, newWidth - 2, newHeight - 2);
                } else {
                    int firstPiece = fileInfo2.getFirstPieceNumber();
                    int nbPieces = fileInfo2.getNbPieces();
                    DiskManagerPiece[] dm_pieces = manager.getPieces();
                    this.bNoRed = true;
                    for (int i = 0; i < newWidth; ++i) {
                        int a1 = (i + 1) * nbPieces / newWidth;
                        int a0 = i * nbPieces / newWidth;
                        if (a1 == a0) {
                            ++a1;
                        }
                        if (a1 > nbPieces && nbPieces != 0) {
                            a1 = nbPieces;
                        }
                        int nbAvailable = 0;
                        boolean written = false;
                        boolean partially_written = false;
                        if (firstPiece >= 0) {
                            block1: for (int j = a0; j < a1; ++j) {
                                boolean[] blocks;
                                PEPiece pe_piece;
                                int this_index = j + firstPiece;
                                DiskManagerPiece dm_piece = dm_pieces[this_index];
                                if (dm_piece.isDone()) {
                                    ++nbAvailable;
                                }
                                if (written) continue;
                                if (pe_pieces != null && (pe_piece = pe_pieces[this_index]) != null) {
                                    boolean bl2 = written = written || pe_piece.getLastDownloadTime(now) + 500L > this.last_draw_time;
                                }
                                if (written || partially_written || (blocks = dm_piece.getWritten()) == null) continue;
                                for (int k = 0; k < blocks.length; ++k) {
                                    if (!blocks[k]) continue;
                                    partially_written = true;
                                    continue block1;
                                }
                            }
                        } else {
                            nbAvailable = 1;
                        }
                        gcImage.setBackground(written ? Colors.red : (partially_written ? Colors.grey : Colors.blues[nbAvailable * 9 / (a1 - a0)]));
                        gcImage.fillRectangle(i, 1, 1, newHeight - 2);
                        if (!written) continue;
                        this.bNoRed = false;
                    }
                    gcImage.setForeground(Colors.grey);
                }
            } else {
                gcImage.setForeground(Colors.grey);
            }
            if (manager != null) {
                gcImage.drawRectangle(0, 0, newWidth - 1, newHeight - 1);
            }
            gcImage.dispose();
            this.last_draw_time = now;
            if (cell instanceof TableCellSWT) {
                ((TableCellSWT)cell).setGraphic(piecesImage);
            } else {
                cell.setGraphic(new UISWTGraphicImpl(piecesImage));
            }
        }
    }
}

