/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class PriorityItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public PriorityItem() {
        super("priority", 1, -2, 70, "Files");
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        String tmp;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        int sortval = 0;
        if (fileInfo2 == null) {
            tmp = "";
        } else {
            int st = fileInfo2.getStorageType();
            if ((st == 2 || st == 4) && fileInfo2.isSkipped()) {
                tmp = MessageText.getString("FileItem.delete");
                sortval = Integer.MIN_VALUE;
            } else if (fileInfo2.isSkipped()) {
                tmp = MessageText.getString("FileItem.donotdownload");
                sortval = -2147483647;
            } else {
                int pri;
                sortval = pri = fileInfo2.getPriority();
                if (pri > 0) {
                    tmp = MessageText.getString("FileItem.high");
                    if (pri > 1) {
                        tmp = tmp + " (" + pri + ")";
                    }
                } else if (pri < 0) {
                    tmp = MessageText.getString("FileItem.low");
                    if (pri < -1) {
                        tmp = tmp + " (" + pri + ")";
                    }
                } else {
                    tmp = MessageText.getString("FileItem.normal");
                }
            }
        }
        cell.setText(tmp);
        cell.setSortValue(sortval);
    }
}

