/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import java.io.File;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellLightRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PathItem;

public class PathNameItem
extends CoreTableColumnSWT
implements TableCellLightRefreshListener,
ObfusticateCellText,
TableCellDisposeListener {
    private static boolean bShowIcon;

    public PathNameItem() {
        super("pathname", 1, -1, 500, "Files");
        this.setObfustication(true);
        this.setType(1);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell, boolean sortOnlyRefresh) {
        String file_path;
        String file_name;
        final DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        String string = file_name = fileInfo2 == null ? "" : fileInfo2.getFile(true).getName();
        if (file_name == null) {
            file_name = "";
        }
        if (!(file_path = PathItem.determinePath(fileInfo2)).isEmpty()) {
            if (!file_path.endsWith(File.separator)) {
                file_path = file_path + File.separator;
            }
            file_name = file_path + file_name;
        }
        if ((cell.setText(file_name) || !cell.isValid()) && bShowIcon && !sortOnlyRefresh) {
            Image icon = null;
            final TableCellSWT _cell = (TableCellSWT)cell;
            if (fileInfo2 == null) {
                icon = null;
            } else if (Utils.isSWTThread()) {
                icon = ImageRepository.getPathIcon(fileInfo2.getFile(true).getPath(), cell.getHeight() > 32, false);
            } else {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        Image icon = ImageRepository.getPathIcon(fileInfo2.getFile(true).getPath(), _cell.getHeight() > 32, false);
                        _cell.setIcon(icon);
                        _cell.redraw();
                    }
                });
            }
            if (icon != null) {
                _cell.setIcon(icon);
            }
        }
    }

    @Override
    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }

    @Override
    public String getObfusticatedText(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        String name = fileInfo2 == null ? "" : fileInfo2.getIndex() + ": " + Debug.secretFileName(fileInfo2.getFile(true).getName());
        return name;
    }

    @Override
    public void dispose(TableCell cell) {
    }

    static {
        COConfigurationManager.addAndFireParameterListener("NameColumn.showProgramIcon", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                bShowIcon = COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon");
            }
        });
    }
}

