/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellInplaceEditorListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellLightRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class NameItem
extends CoreTableColumnSWT
implements TableCellLightRefreshListener,
ObfusticateCellText,
TableCellDisposeListener,
TableCellInplaceEditorListener {
    private static boolean bShowIcon;
    final TableContextMenuItem menuItem;

    public NameItem() {
        super("name", 1, -2, 300, "Files");
        this.setObfustication(true);
        this.setInplaceEditorListener(this);
        this.setType(1);
        this.menuItem = this.addContextMenuItem("FilesView.name.fastRename", 1);
        this.menuItem.setStyle(2);
        this.menuItem.setData(this.hasInplaceEditorListener());
        this.menuItem.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                menu.setData(!NameItem.this.hasInplaceEditorListener());
                NameItem.this.setInplaceEditorListener(NameItem.this.hasInplaceEditorListener() ? null : NameItem.this);
            }
        });
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    @Override
    public void postConfigLoad() {
        this.setInplaceEditorListener(this.getUserData("noInplaceEdit") == null ? null : this);
        this.menuItem.setData(this.hasInplaceEditorListener());
    }

    @Override
    public void preConfigSave() {
        if (this.hasInplaceEditorListener()) {
            this.removeUserData("noInplaceEdit");
        } else {
            this.setUserData("noInplaceEdit", new Integer(1));
        }
    }

    @Override
    public void refresh(TableCell cell, boolean sortOnlyRefresh) {
        String name;
        final DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        String string = name = fileInfo2 == null ? "" : fileInfo2.getFile(true).getName();
        if (name == null) {
            name = "";
        }
        if ((cell.setText(name) || !cell.isValid()) && bShowIcon && !sortOnlyRefresh) {
            Image icon = null;
            final TableCellSWT _cell = (TableCellSWT)cell;
            if (fileInfo2 == null) {
                icon = null;
            } else if (Utils.isSWTThread()) {
                icon = ImageRepository.getPathIcon(fileInfo2.getFile(true).getPath(), cell.getHeight() > 32, false);
            } else {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        Image icon = ImageRepository.getPathIcon(fileInfo2.getFile(true).getPath(), _cell.getHeight() > 32, false);
                        _cell.setIcon(icon);
                        _cell.redraw();
                    }
                });
            }
            if (icon != null) {
                _cell.setIcon(icon);
            }
        }
    }

    @Override
    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }

    @Override
    public String getObfusticatedText(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        String name = fileInfo2 == null ? "" : fileInfo2.getIndex() + ": " + Debug.secretFileName(fileInfo2.getFile(true).getName());
        return name;
    }

    @Override
    public void dispose(TableCell cell) {
    }

    private void disposeCellIcon(TableCell cell) {
        Image img = ((TableCellSWT)cell).getIcon();
        if (img != null) {
            ((TableCellSWT)cell).setIcon(null);
            if (!img.isDisposed()) {
                img.dispose();
            }
        }
    }

    @Override
    public boolean inplaceValueSet(TableCell cell, String value, boolean finalEdit) {
        File target;
        if (value.equalsIgnoreCase(cell.getText()) || "".equals(value) || "".equals(cell.getText())) {
            return true;
        }
        final DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        try {
            target = new File(fileInfo2.getFile(true).getParentFile(), value).getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!finalEdit) {
            return !target.exists();
        }
        if (target.exists()) {
            return false;
        }
        final boolean[] result = new boolean[]{false};
        boolean paused = fileInfo2.getDownloadManager().pause();
        FileUtil.runAsTask(new AzureusCoreOperationTask(){

            @Override
            public void run(AzureusCoreOperation operation) {
                result[0] = fileInfo2.setLink(target);
            }
        });
        if (paused) {
            fileInfo2.getDownloadManager().resume();
        }
        if (!result[0]) {
            new MessageBoxShell(33, MessageText.getString("FilesView.rename.failed.title"), MessageText.getString("FilesView.rename.failed.text")).open(null);
        }
        return true;
    }

    static {
        COConfigurationManager.addAndFireParameterListener("NameColumn.showProgramIcon", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                bShowIcon = COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon");
            }
        });
    }
}

