/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class FileWriteSpeedItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public FileWriteSpeedItem() {
        super("writerate", 2, -1, 60, "Files");
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        int speed = 0;
        if (fileInfo2 != null) {
            speed = fileInfo2.getWriteBytesPerSecond();
        }
        if (!cell.setSortValue(speed) && cell.isValid()) {
            return;
        }
        cell.setText(speed == 0 ? "" : DisplayFormatters.formatByteCountToKiBEtcPerSec(speed));
    }
}

