/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class FileExtensionItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public FileExtensionItem() {
        super("fileext", 1, -1, 50, "Files");
        this.setMinWidthAuto(true);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        cell.setText(FileExtensionItem.determineFileExt(fileInfo2));
    }

    private static String determineFileExt(DiskManagerFileInfo fileInfo2) {
        int dot_position;
        String incomp_suffix;
        String name = fileInfo2 == null ? "" : fileInfo2.getFile(true).getName();
        DownloadManager dm = fileInfo2 == null ? null : fileInfo2.getDownloadManager();
        String string = incomp_suffix = dm == null ? null : dm.getDownloadState().getAttribute("incompfilesuffix");
        if (incomp_suffix != null && name.endsWith(incomp_suffix)) {
            name = name.substring(0, name.length() - incomp_suffix.length());
        }
        if ((dot_position = name.lastIndexOf(".")) == -1) {
            return "";
        }
        return name.substring(dot_position + 1);
    }
}

