/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class FileAvailabilityItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    private static final String zeros = "0000";
    private static final int numZeros = "0000".length();
    private int iTimesBy;

    public FileAvailabilityItem() {
        super("availability", 1, -1, 60, "Files");
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
        this.iTimesBy = 1;
        for (int i = 1; i < numZeros; ++i) {
            this.iTimesBy *= 10;
        }
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        String sText = "";
        DiskManagerFileInfo file = (DiskManagerFileInfo)cell.getDataSource();
        if (file == null) {
            return;
        }
        if (file.getLength() == 0L) {
            sText = "-";
            cell.setSortValue(Long.MAX_VALUE);
        } else {
            PEPeerManager pm = file.getDownloadManager().getPeerManager();
            if (pm != null) {
                float f = pm.getMinAvailability(file.getIndex());
                if (!cell.setSortValue((long)(f * 1000.0f)) && cell.isValid()) {
                    return;
                }
                sText = String.valueOf((int)(f * (float)this.iTimesBy));
                if (numZeros - sText.length() > 0) {
                    sText = zeros.substring(0, numZeros - sText.length()) + sText;
                }
                sText = sText.substring(0, sText.length() - numZeros + 1) + "." + sText.substring(sText.length() - numZeros + 1);
            } else {
                cell.setSortValue(0L);
            }
        }
        cell.setText(sText);
    }
}

