/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.painted;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellSWTBase;
import org.gudy.azureus2.ui.swt.views.table.painted.TableViewPainted;

public class TableCellPainted
extends TableCellSWTBase {
    private static final boolean DEBUG_CELLPAINT = false;
    private Rectangle bounds;
    private String text = "";
    private int marginWidth;
    private int marginHeight;
    private boolean redrawScheduled;
    private Color colorFG;

    public TableCellPainted(TableRowSWT row, TableColumnCore column, int pos) {
        super(row, column);
        this.constructionCompleter();
    }

    @Override
    protected void constructionCompleter() {
        this.constructionComplete();
        this.tableColumn.invokeCellAddedListeners(this);
    }

    @Override
    public Object getDataSource() {
        TableRowCore row = this.tableRow;
        TableColumnCore col = this.tableColumn;
        if (row == null || col == null) {
            return null;
        }
        return row.getDataSource(col.getUseCoreDataSource());
    }

    @Override
    public TableColumn getTableColumn() {
        return this.tableColumn;
    }

    @Override
    public TableRow getTableRow() {
        return this.tableRow;
    }

    @Override
    public String getTableID() {
        return this.tableRow == null ? null : this.tableRow.getTableID();
    }

    public static boolean stringEquals(String s0, String s1) {
        boolean s1Null;
        boolean s0Null = s0 == null;
        boolean bl = s1Null = s1 == null;
        if (s0Null || s1Null) {
            return s0Null == s1Null;
        }
        return s0.equals(s1);
    }

    @Override
    public String getText() {
        if (this.hasFlag(2) && this.sortValue instanceof String) {
            return (String)((Object)this.sortValue);
        }
        return this.text;
    }

    @Override
    public Comparable<?> getSortValue() {
        Comparable value = super.getSortValue();
        return value == null ? "" : value;
    }

    @Override
    public boolean isShown() {
        return !this.isDisposed() && this.tableRow != null && this.tableRow.getView().isColumnVisible(this.tableColumn);
    }

    @Override
    public int getMaxLines() {
        return 1;
    }

    @Override
    public int getWidth() {
        if (this.isDisposed()) {
            return -1;
        }
        return this.tableColumn.getWidth() - 2 - this.getMarginWidth() * 2;
    }

    @Override
    public int getWidthRaw() {
        if (this.isDisposed()) {
            return -1;
        }
        return this.tableColumn.getWidth() - 2;
    }

    @Override
    public int getHeight() {
        if (this.bounds == null) {
            if (this.tableRow == null) {
                return 20;
            }
            return this.tableRow.getView().getRowDefaultHeight();
        }
        return this.bounds.height - this.getMarginHeight() * 2;
    }

    @Override
    public int getMarginHeight() {
        return this.marginHeight;
    }

    @Override
    public void setMarginHeight(int height) {
        this.marginHeight = height;
    }

    @Override
    public int getMarginWidth() {
        return this.marginWidth;
    }

    @Override
    public void setMarginWidth(int width) {
        this.marginWidth = width;
    }

    @Override
    public Graphic getBackgroundGraphic() {
        return new UISWTGraphicImpl(this.getBackgroundImage());
    }

    @Override
    public void locationChanged() {
    }

    @Override
    public boolean setCursorID(int cursorID) {
        if (!super.setCursorID(cursorID)) {
            return false;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                Composite composite;
                TableViewSWT view;
                if (TableCellPainted.this.isDisposed() || TableCellPainted.this.tableRow == null) {
                    return;
                }
                if (TableCellPainted.this.isMouseOver() && (view = (TableViewSWT)TableCellPainted.this.tableRow.getView()) != null && (composite = view.getComposite()) != null && !composite.isDisposed()) {
                    composite.setCursor(composite.getDisplay().getSystemCursor(TableCellPainted.this.getCursorID()));
                }
            }
        });
        return true;
    }

    @Override
    public void redraw() {
        if (this.tableRow == null || !this.tableRow.isVisible() || this.redrawScheduled) {
            return;
        }
        this.redrawScheduled = true;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                TableViewPainted view;
                if (TableCellPainted.this.isDisposed()) {
                    return;
                }
                TableCellPainted.this.redrawScheduled = false;
                if (TableCellPainted.this.bounds != null && TableCellPainted.this.tableRow != null && (view = (TableViewPainted)TableCellPainted.this.tableRow.getView()) != null) {
                    view.swt_updateCanvasImage(TableCellPainted.this.bounds, false);
                }
            }
        });
    }

    @Override
    public boolean setForeground(Color color) {
        if (this.isInvisibleAndCanRefresh()) {
            return false;
        }
        if (color == this.colorFG || color != null && color.equals(this.colorFG) || this.colorFG != null && this.colorFG.equals(color)) {
            return false;
        }
        this.colorFG = color;
        this.setFlag(64);
        return true;
    }

    @Override
    public Point getSize() {
        if (this.bounds == null) {
            return new Point(0, 0);
        }
        return new Point(this.bounds.width - this.marginWidth * 2, this.bounds.height - this.marginHeight * 2);
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(this.bounds.x + this.marginWidth, this.bounds.y + this.marginHeight, this.bounds.width - this.marginWidth * 2, this.bounds.height - this.marginHeight * 2);
    }

    public Rectangle getBoundsRaw() {
        if (this.bounds == null) {
            return null;
        }
        return new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    @Override
    public Rectangle getBoundsOnDisplay() {
        if (this.isDisposed() || this.tableRow == null) {
            return null;
        }
        Rectangle bounds = this.getBoundsRaw();
        if (bounds == null) {
            return null;
        }
        TableViewPainted tv = (TableViewPainted)this.tableRow.getView();
        if (tv == null) {
            return null;
        }
        Composite c = tv.getTableComposite();
        if (c == null || c.isDisposed()) {
            return null;
        }
        Point pt = c.toDisplay(bounds.x, bounds.y);
        bounds.x = pt.x;
        bounds.y = pt.y;
        bounds.height = this.getHeight();
        bounds.width = this.getWidthRaw();
        return bounds;
    }

    @Override
    public Image getBackgroundImage() {
        if (this.bounds == null || this.bounds.isEmpty()) {
            return null;
        }
        Image image = new Image((Device)Display.getDefault(), this.bounds.width - this.marginWidth * 2, this.bounds.height - this.marginHeight * 2);
        GC gc = new GC(image);
        gc.setForeground(this.getBackgroundSWT());
        gc.setBackground(this.getBackgroundSWT());
        gc.fillRectangle(0, 0, this.bounds.width, this.bounds.height);
        gc.dispose();
        return image;
    }

    @Override
    public Color getForegroundSWT() {
        return this.colorFG;
    }

    @Override
    public Color getBackgroundSWT() {
        return null;
    }

    public void setBoundsRaw(Rectangle bounds) {
        this.bounds = bounds;
    }

    @Override
    public boolean uiSetText(String text) {
        boolean bChanged;
        boolean bl = bChanged = !TableCellPainted.stringEquals(this.text, text);
        if (bChanged) {
            this.text = text;
        }
        return bChanged;
    }
}

