/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableColumnSortObject;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCellClipboardListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellLightRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;

public abstract class TableCellSWTBase
implements TableCellSWT {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static AEMonitor this_mon = new AEMonitor("TableCell");
    protected static final int FLAG_VALID = 1;
    protected static final int FLAG_SORTVALUEISTEXT = 2;
    protected static final int FLAG_TOOLTIPISAUTO = 4;
    protected static final int FLAG_UPTODATE = 8;
    protected static final int FLAG_DISPOSED = 16;
    protected static final int FLAG_MUSTREFRESH = 32;
    public static final int FLAG_VISUALLY_CHANGED_SINCE_REFRESH = 64;
    private static final boolean DEBUGONLYZERO = false;
    private static final boolean DEBUG_FLAGS = false;
    private int flags = 2;
    protected TableRowCore tableRow;
    protected TableColumnCore tableColumn;
    private byte tooltipErrLoopCount;
    public boolean bDebug = false;
    protected ArrayList<TableCellRefreshListener> refreshListeners;
    private ArrayList<TableCellDisposeListener> disposeListeners;
    private ArrayList<TableCellToolTipListener> tooltipListeners;
    private ArrayList<TableCellMouseListener> cellMouseListeners;
    private ArrayList<TableCellMouseMoveListener> cellMouseMoveListeners;
    private ArrayList<TableCellVisibilityListener> cellVisibilityListeners;
    protected ArrayList<TableCellSWTPaintListener> cellSWTPaintListeners;
    private ArrayList<TableCellClipboardListener> cellClipboardListeners;
    protected Comparable sortValue;
    private byte restartRefresh = 0;
    private boolean bInRefreshAsync = false;
    private byte refreshErrLoopCount;
    private byte loopFactor;
    protected static int MAX_REFRESHES = 10;
    private static int MAX_REFRESHES_WITHIN_MS = 100;
    private boolean bInRefresh = false;
    private long lastRefresh;
    protected int numFastRefreshes;
    private Object oToolTip;
    private Object defaultToolTip;
    private int textAlpha = 255;
    private boolean doFillCell = false;
    private int iCursorID = 0;
    private boolean mouseOver;
    private Image icon;
    private Graphic graphic = null;

    public TableCellSWTBase(TableRowCore row, TableColumnCore column) {
        this.tableRow = row;
        this.tableColumn = column;
        this.tooltipErrLoopCount = 0;
        this.refreshErrLoopCount = 0;
        this.loopFactor = 0;
    }

    protected void constructionComplete() {
        if (this.tableColumn != null && this.tableColumn.getType() == 2) {
            this.setMarginHeight(1);
            this.setMarginWidth(1);
        }
    }

    protected abstract void constructionCompleter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRefreshListener(TableCellRefreshListener listener) {
        try {
            this_mon.enter();
            if (this.refreshListeners == null) {
                this.refreshListeners = new ArrayList(1);
            }
            if (this.bDebug) {
                this.debug("addRefreshListener; count=" + this.refreshListeners.size());
            }
            this.refreshListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRefreshListener(TableCellRefreshListener listener) {
        try {
            this_mon.enter();
            if (this.refreshListeners == null) {
                return;
            }
            this.refreshListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDisposeListener(TableCellDisposeListener listener) {
        try {
            this_mon.enter();
            if (this.disposeListeners == null) {
                this.disposeListeners = new ArrayList(1);
            }
            this.disposeListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDisposeListener(TableCellDisposeListener listener) {
        try {
            this_mon.enter();
            if (this.disposeListeners == null) {
                return;
            }
            this.disposeListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToolTipListener(TableCellToolTipListener listener) {
        try {
            this_mon.enter();
            if (this.tooltipListeners == null) {
                this.tooltipListeners = new ArrayList(1);
            }
            this.tooltipListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeToolTipListener(TableCellToolTipListener listener) {
        try {
            this_mon.enter();
            if (this.tooltipListeners == null) {
                return;
            }
            this.tooltipListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMouseListener(TableCellMouseListener listener) {
        try {
            this_mon.enter();
            if (this.cellMouseListeners == null) {
                this.cellMouseListeners = new ArrayList(1);
            }
            this.cellMouseListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMouseListener(TableCellMouseListener listener) {
        try {
            this_mon.enter();
            if (this.cellMouseListeners == null) {
                return;
            }
            this.cellMouseListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMouseMoveListener(TableCellMouseMoveListener listener) {
        try {
            this_mon.enter();
            if (this.cellMouseMoveListeners == null) {
                this.cellMouseMoveListeners = new ArrayList(1);
            }
            this.cellMouseMoveListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMouseMoveListener(TableCellMouseMoveListener listener) {
        try {
            this_mon.enter();
            if (this.cellMouseMoveListeners == null) {
                return;
            }
            this.cellMouseMoveListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                this.cellVisibilityListeners = new ArrayList(1);
            }
            this.cellVisibilityListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                return;
            }
            this.cellVisibilityListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSWTPaintListener(TableCellSWTPaintListener listener) {
        try {
            this_mon.enter();
            if (this.cellSWTPaintListeners == null) {
                this.cellSWTPaintListeners = new ArrayList(1);
            }
            this.cellSWTPaintListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    public void invokeSWTPaintListeners(GC gc) {
        Object[] swtPaintListeners;
        if (this.tableColumn != null && (swtPaintListeners = this.tableColumn.getCellOtherListeners("SWTPaint")) != null) {
            for (int i = 0; i < swtPaintListeners.length; ++i) {
                try {
                    TableCellSWTPaintListener l = (TableCellSWTPaintListener)swtPaintListeners[i];
                    l.cellPaint(gc, this);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (this.cellSWTPaintListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellSWTPaintListeners.size(); ++i) {
            try {
                TableCellSWTPaintListener l = this.cellSWTPaintListeners.get(i);
                l.cellPaint(gc, this);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCellClipboardListener(TableCellClipboardListener listener) {
        try {
            this_mon.enter();
            if (this.cellClipboardListeners == null) {
                this.cellClipboardListeners = new ArrayList(1);
            }
            this.cellClipboardListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClipboardText() {
        String text;
        block9: {
            if (this.isDisposed()) {
                return "";
            }
            text = this.tableColumn.getClipboardText(this);
            if (text != null) {
                return text;
            }
            try {
                this_mon.enter();
                if (this.cellClipboardListeners == null) break block9;
                for (TableCellClipboardListener l : this.cellClipboardListeners) {
                    try {
                        text = l.getClipboardText(this);
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                    if (text == null) continue;
                    break;
                }
            }
            finally {
                this_mon.exit();
            }
        }
        if (text == null) {
            text = this.getText();
        }
        return text;
    }

    @Override
    public void addListeners(Object listenerObject) {
        if (listenerObject instanceof TableCellDisposeListener) {
            this.addDisposeListener((TableCellDisposeListener)listenerObject);
        }
        if (listenerObject instanceof TableCellRefreshListener) {
            this.addRefreshListener((TableCellRefreshListener)listenerObject);
        }
        if (listenerObject instanceof TableCellToolTipListener) {
            this.addToolTipListener((TableCellToolTipListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseMoveListener) {
            this.addMouseMoveListener((TableCellMouseMoveListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseListener) {
            this.addMouseListener((TableCellMouseListener)listenerObject);
        }
        if (listenerObject instanceof TableCellVisibilityListener) {
            this.addVisibilityListener((TableCellVisibilityListener)listenerObject);
        }
        if (listenerObject instanceof TableCellSWTPaintListener) {
            this.addSWTPaintListener((TableCellSWTPaintListener)listenerObject);
        }
        if (listenerObject instanceof TableCellClipboardListener) {
            this.addCellClipboardListener((TableCellClipboardListener)listenerObject);
        }
    }

    @Override
    public void invokeToolTipListeners(int type) {
        block9: {
            if (this.tableColumn == null) {
                return;
            }
            this.tableColumn.invokeCellToolTipListeners(this, type);
            if (this.tooltipListeners == null || this.tooltipErrLoopCount > 2) {
                return;
            }
            int iErrCount = this.tableColumn.getConsecutiveErrCount();
            if (iErrCount > 10) {
                return;
            }
            try {
                if (type == 0) {
                    for (int i = 0; i < this.tooltipListeners.size(); ++i) {
                        this.tooltipListeners.get(i).cellHover(this);
                    }
                } else {
                    for (int i = 0; i < this.tooltipListeners.size(); ++i) {
                        this.tooltipListeners.get(i).cellHoverComplete(this);
                    }
                }
                this.tooltipErrLoopCount = 0;
            }
            catch (Throwable e) {
                this.tooltipErrLoopCount = (byte)(this.tooltipErrLoopCount + 1);
                this.tableColumn.setConsecutiveErrCount(++iErrCount);
                this.pluginError(e);
                if (this.tooltipErrLoopCount <= 2) break block9;
                Logger.log(new LogEvent(LOGID, 3, "TableCell's tooltip will not be refreshed anymore this session."));
            }
        }
    }

    @Override
    public void invokeMouseListeners(TableCellMouseEvent event2) {
        ArrayList<TableCellMouseListener> listeners;
        ArrayList<TableCellMouseListener> arrayList = listeners = event2.eventType == 3 ? this.cellMouseMoveListeners : this.cellMouseListeners;
        if (listeners == null) {
            return;
        }
        if (event2.cell != null && event2.row == null) {
            event2.row = event2.cell.getTableRow();
        }
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                TableCellMouseListener l = listeners.get(i);
                l.cellMouseTrigger(event2);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void invokeVisibilityListeners(int visibility, boolean invokeColumnListeners) {
        TableColumnCore tc = this.tableColumn;
        if (invokeColumnListeners && tc != null) {
            tc.invokeCellVisibilityListeners(this, visibility);
        }
        if (this.cellVisibilityListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellVisibilityListeners.size(); ++i) {
            try {
                TableCellVisibilityListener l = this.cellVisibilityListeners.get(i);
                l.cellVisibilityChanged(this, visibility);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            Debug.out("Double disposal!");
            return;
        }
        this.setFlag(16);
        TableColumnCore tc = this.tableColumn;
        if (tc != null) {
            tc.invokeCellDisposeListeners(this);
        }
        if (this.disposeListeners != null) {
            try {
                for (TableCellDisposeListener listener : this.disposeListeners) {
                    listener.dispose(this);
                }
                this.disposeListeners = null;
            }
            catch (Throwable e) {
                this.pluginError(e);
            }
        }
        this.refreshListeners = null;
        this.tableColumn = null;
        this.tableRow = null;
        this.sortValue = null;
    }

    public void debug(final String s) {
        Utils.execSWTThread((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                if (TableCellSWTBase.this.tableRow == null) {
                    System.out.println(SystemTime.getCurrentTime() + ": c" + (TableCellSWTBase.this.tableColumn == null ? null : Integer.valueOf(TableCellSWTBase.this.tableColumn.getPosition())) + ";F=" + TableCellSWTBase.this.flagToText(TableCellSWTBase.this.flags, false) + ";" + s);
                } else {
                    System.out.println(SystemTime.getCurrentTime() + ": r" + TableCellSWTBase.this.tableRow.getIndex() + "c" + (TableCellSWTBase.this.tableColumn == null ? null : Integer.valueOf(TableCellSWTBase.this.tableColumn.getPosition())) + ";r.v?" + (TableCellSWTBase.this.tableRow.isVisible() ? "Y" : "N") + "F=" + TableCellSWTBase.this.flagToText(TableCellSWTBase.this.flags, false) + ";" + s);
                }
            }
        }, true);
    }

    protected void pluginError(Throwable e) {
        if (this.tableColumn != null) {
            String sTitleLanguageKey = this.tableColumn.getTitleLanguageKey();
            String sPosition = this.tableColumn.getPosition() + " (" + MessageText.getString(sTitleLanguageKey) + ")";
            Logger.log(new LogEvent(LOGID, "Table Cell Plugin for Column #" + sPosition + " generated an exception ", e));
        } else {
            Logger.log(new LogEvent(LOGID, "Table Cell Plugin generated an exception ", e));
        }
    }

    protected void pluginError(String s) {
        String sPosition = "r" + this.tableRow.getIndex() + "c" + this.tableColumn.getPosition();
        Logger.log(new LogEvent(LOGID, 3, "Table Cell Plugin for Column #" + sPosition + ":" + s + "\n  " + Debug.getStackTrace(true, true)));
    }

    @Override
    public boolean refresh() {
        return this.refresh(true);
    }

    @Override
    public boolean refresh(boolean bDoGraphics) {
        boolean isRowShown;
        if (this.tableRow != null) {
            TableView view = this.tableRow.getView();
            isRowShown = view.isRowVisible(this.tableRow);
        } else {
            isRowShown = true;
        }
        boolean isCellShown = isRowShown && this.isShown();
        return this.refresh(bDoGraphics, isRowShown, isCellShown);
    }

    @Override
    public boolean refresh(boolean bDoGraphics, boolean bRowVisible) {
        boolean isCellShown = bRowVisible && this.isShown();
        return this.refresh(bDoGraphics, bRowVisible, isCellShown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refresh(boolean bDoGraphics, boolean bRowVisible, boolean bCellVisible) {
        TableColumnCore tc = this.tableColumn;
        if (tc == null) {
            return false;
        }
        boolean ret = this.getVisuallyChangedSinceRefresh();
        int iErrCount = 0;
        if (this.refreshErrLoopCount > 2) {
            return ret;
        }
        iErrCount = tc.getConsecutiveErrCount();
        if (iErrCount > 10) {
            this.refreshErrLoopCount = (byte)3;
            return ret;
        }
        if (this.bInRefresh) {
            if (this.bDebug) {
                this.debug("Calling Refresh from Refresh :) Skipping.");
            }
            return ret;
        }
        try {
            int iInterval;
            this.bInRefresh = true;
            if (ret) {
                long now = SystemTime.getCurrentTime();
                if (now - this.lastRefresh < (long)MAX_REFRESHES_WITHIN_MS) {
                    ++this.numFastRefreshes;
                    if (this.numFastRefreshes >= MAX_REFRESHES) {
                        if (this.numFastRefreshes % MAX_REFRESHES == 0) {
                            this.pluginError("this plugin is crazy. tried to refresh " + this.numFastRefreshes + " times in " + (now - this.lastRefresh) + "ms");
                        }
                        boolean bl = ret;
                        return bl;
                    }
                } else {
                    this.numFastRefreshes = 0;
                    this.lastRefresh = now;
                }
            }
            if (bCellVisible && !this.isUpToDate()) {
                if (this.bDebug) {
                    this.debug("Setting Invalid because visible & not up to date");
                }
                this.clearFlag(1);
                this.setFlag(8);
            } else if (!bCellVisible && this.isUpToDate()) {
                if (this.bDebug) {
                    this.debug("Setting not up to date because cell not visible " + Debug.getCompressedStackTrace());
                }
                this.clearFlag(8);
            }
            if (this.bDebug) {
                this.debug("Cell Valid?" + this.hasFlag(1) + "; Visible?" + this.tableRow.isVisible() + "/" + this.isShown());
            }
            if ((iInterval = tc.getRefreshInterval()) == -3 && !this.hasFlag(33) && this.hasFlag(2) && this.sortValue != null && tc.getType() == 3) {
                if (bCellVisible) {
                    if (this.bDebug) {
                        this.debug("fast refresh: setText");
                    }
                    ret = this.setText((String)((Object)this.sortValue));
                    this.setFlag(1);
                }
            } else if (iInterval == -2 || iInterval == -1 && bDoGraphics || iInterval > 0 && this.loopFactor % iInterval == 0 || !this.hasFlag(1) || this.hasFlag(32)) {
                boolean bWasValid = this.isValid();
                ret = this.hasFlag(32);
                if (ret) {
                    this.clearFlag(32);
                }
                if (this.bDebug) {
                    this.debug("invoke refresh; wasValid? " + bWasValid);
                }
                long lTimeStart = Constants.isCVSVersion() ? SystemTime.getMonotonousTime() : 0L;
                tc.invokeCellRefreshListeners(this, !bCellVisible);
                if (this.refreshListeners != null) {
                    for (TableCellRefreshListener l : this.refreshListeners) {
                        if (l instanceof TableCellLightRefreshListener) {
                            ((TableCellLightRefreshListener)l).refresh(this, !bCellVisible);
                            continue;
                        }
                        l.refresh(this);
                    }
                }
                if (Constants.isCVSVersion()) {
                    long lTimeEnd = SystemTime.getMonotonousTime();
                    tc.addRefreshTime(lTimeEnd - lTimeStart);
                }
                if (!bWasValid && !this.hasFlag(32)) {
                    this.setFlag(1);
                }
            } else if (bCellVisible && this.bDebug) {
                this.debug("Skipped refresh; Interval=" + iInterval);
            }
            this.loopFactor = (byte)(this.loopFactor + 1);
            this.refreshErrLoopCount = 0;
            if (iErrCount > 0) {
                tc.setConsecutiveErrCount(0);
            }
            ret |= this.getVisuallyChangedSinceRefresh();
            if (this.bDebug) {
                this.debug("refresh done; visual change? " + ret + ";" + Debug.getCompressedStackTrace());
            }
        }
        catch (Throwable e) {
            this.refreshErrLoopCount = (byte)(this.refreshErrLoopCount + 1);
            if (tc != null) {
                tc.setConsecutiveErrCount(++iErrCount);
            }
            this.pluginError(e);
            if (this.refreshErrLoopCount > 2) {
                Logger.log(new LogEvent(LOGID, 3, "TableCell will not be refreshed anymore this session."));
            }
        }
        finally {
            this.bInRefresh = false;
        }
        return ret;
    }

    @Override
    public boolean setSortValue(Comparable valueToSort) {
        if (this.tableColumn == null) {
            return false;
        }
        if (!(this.tableColumn.isSortValueLive() || valueToSort instanceof Number || valueToSort instanceof String || valueToSort instanceof TableColumnSortObject)) {
            this.tableColumn.setSortValueLive(true);
        }
        return this._setSortValue(valueToSort);
    }

    private boolean _setSortValue(Comparable valueToSort) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.sortValue == valueToSort) {
            return false;
        }
        if (this.hasFlag(2)) {
            this.clearFlag(2);
            if (this.sortValue instanceof String) {
                this.setText((String)((Object)this.sortValue));
            }
        }
        if (valueToSort instanceof String && this.sortValue instanceof String && this.sortValue.equals(valueToSort)) {
            return false;
        }
        if (valueToSort instanceof Number && this.sortValue instanceof Number && this.sortValue.equals(valueToSort)) {
            return false;
        }
        if (this.bDebug) {
            this.debug("Setting SortValue to " + (valueToSort == null ? "null" : valueToSort.getClass().getName()));
        }
        this.tableColumn.setLastSortValueChange(SystemTime.getCurrentTime());
        this.sortValue = valueToSort;
        if (this.cellSWTPaintListeners != null || this.tableColumn.hasCellOtherListeners("SWTPaint")) {
            this.setFlag(64);
        }
        return true;
    }

    @Override
    public boolean setSortValue(long valueToSort) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.sortValue instanceof Long && (Long)this.sortValue == valueToSort) {
            return false;
        }
        return this._setSortValue(Long.valueOf(valueToSort));
    }

    @Override
    public boolean setSortValue(float valueToSort) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.sortValue instanceof Float && ((Float)this.sortValue).floatValue() == valueToSort) {
            return false;
        }
        return this._setSortValue(new Float(valueToSort));
    }

    @Override
    public Comparable getSortValue() {
        return this.sortValue;
    }

    @Override
    public boolean isValid() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isDisposed() {
        return (this.flags & 0x10) != 0;
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public void setFlag(int flag) {
        this.flags |= flag;
    }

    public void clearFlag(int flag) {
        this.flags &= ~flag;
    }

    @Override
    public void invalidate() {
        if (this.isDisposed()) {
            return;
        }
        this.invalidate(true);
    }

    @Override
    public void invalidate(boolean bMustRefresh) {
        if ((this.flags & 0x41) == 64) {
            if (bMustRefresh) {
                if ((this.flags & 0x20) != 0) {
                    return;
                }
            } else {
                return;
            }
        }
        this.clearFlag(1);
        if (this.bDebug) {
            this.debug("Invalidate Cell;" + bMustRefresh);
        }
        if (bMustRefresh) {
            this.setFlag(96);
        } else {
            this.setFlag(64);
        }
    }

    @Override
    public void refreshAsync() {
        if (this.bInRefreshAsync) {
            if (this.restartRefresh < 127) {
                this.restartRefresh = (byte)(this.restartRefresh + 1);
            }
            return;
        }
        this.bInRefreshAsync = true;
        AERunnable runnable = new AERunnable(){

            @Override
            public void runSupport() {
                TableCellSWTBase.this.restartRefresh = (byte)0;
                TableCellSWTBase.this.refresh(true);
                TableCellSWTBase.this.bInRefreshAsync = false;
                if (TableCellSWTBase.this.restartRefresh > 0) {
                    TableCellSWTBase.this.refreshAsync();
                }
            }
        };
        Utils.execSWTThreadLater(25, runnable);
    }

    @Override
    public void setUpToDate(boolean upToDate) {
        if (this.bDebug) {
            this.debug("set up to date to " + upToDate);
        }
        if (upToDate) {
            this.setFlag(8);
        } else {
            this.clearFlag(8);
        }
    }

    @Override
    public boolean isUpToDate() {
        return this.hasFlag(8);
    }

    @Override
    public boolean getVisuallyChangedSinceRefresh() {
        return this.hasFlag(64);
    }

    public void clearVisuallyChangedSinceRefresh() {
        this.clearFlag(64);
    }

    public int compareTo(Object o) {
        try {
            Comparable ourSortValue = this.getSortValue();
            Comparable otherSortValue = ((TableCellSWTBase)o).getSortValue();
            if (ourSortValue instanceof String && otherSortValue instanceof String) {
                Collator collator = Collator.getInstance(Locale.getDefault());
                return collator.compare(ourSortValue, otherSortValue);
            }
            try {
                return ourSortValue.compareTo(otherSortValue);
            }
            catch (ClassCastException e) {
            }
        }
        catch (Exception e) {
            System.out.println("Could not compare cells");
            Debug.printStackTrace(e);
        }
        return 0;
    }

    @Override
    public boolean needsPainting() {
        if (this.isDisposed()) {
            return false;
        }
        if (this.cellSWTPaintListeners != null || this.tableColumn.hasCellOtherListeners("SWTPaint")) {
            return true;
        }
        return this.getGraphic() != null;
    }

    @Override
    public boolean setText(String text) {
        boolean do_auto;
        if (this.isDisposed()) {
            return false;
        }
        if (text == null) {
            text = "";
        }
        boolean bChanged = false;
        if (this.hasFlag(2) && !text.equals(this.sortValue)) {
            bChanged = true;
            this.sortValue = text;
            this.tableColumn.setLastSortValueChange(SystemTime.getCurrentTime());
            if (this.bDebug) {
                this.debug("Setting SortValue to text;");
            }
        }
        if (this.uiSetText(text) && !this.hasFlag(2)) {
            bChanged = true;
        }
        if (this.bDebug) {
            this.debug("setText (" + bChanged + ") : " + text);
        }
        if (bChanged) {
            this.setFlag(64);
        }
        boolean bl = do_auto = this.tableColumn == null ? false : this.tableColumn.doesAutoTooltip();
        if (!do_auto) {
            if (this.hasFlag(4)) {
                this.oToolTip = null;
                this.clearFlag(4);
            }
        } else {
            this.oToolTip = text;
            this.setFlag(4);
        }
        return bChanged;
    }

    @Override
    public void setToolTip(Object tooltip) {
        this.oToolTip = tooltip;
        if (tooltip == null) {
            this.setFlag(4);
        } else {
            this.clearFlag(4);
        }
    }

    @Override
    public Object getToolTip() {
        return this.oToolTip;
    }

    @Override
    public Object getDefaultToolTip() {
        return this.defaultToolTip;
    }

    @Override
    public void setDefaultToolTip(Object tt) {
        this.defaultToolTip = tt;
    }

    public abstract boolean uiSetText(String var1);

    @Override
    public void doPaint(GC gc) {
        if (this.bDebug) {
            this.debug("doPaint up2date:" + this.hasFlag(8) + ";v:" + this.hasFlag(1) + ";rl=" + this.refreshListeners);
        }
        this.invokeSWTPaintListeners(gc);
    }

    @Override
    public int getTextAlpha() {
        return this.textAlpha;
    }

    @Override
    public void setTextAlpha(int textOpacity) {
        this.textAlpha = textOpacity;
    }

    @Override
    public TableRowSWT getTableRowSWT() {
        if (this.tableRow instanceof TableRowSWT) {
            return (TableRowSWT)this.tableRow;
        }
        return null;
    }

    @Override
    public TableRowCore getTableRowCore() {
        return this.tableRow;
    }

    private String flagToText(int flag, boolean onlySet) {
        StringBuilder sb = new StringBuilder();
        sb.append((char)((flag & 0x10) > 0 ? 68 : (onlySet ? 32 : 100)));
        sb.append((char)((flag & 0x20) > 0 ? 77 : (onlySet ? 32 : 109)));
        sb.append((char)((flag & 2) > 0 ? 83 : (onlySet ? 32 : 115)));
        sb.append((char)((flag & 4) > 0 ? 84 : (onlySet ? 32 : 116)));
        sb.append((char)((flag & 8) > 0 ? 85 : (onlySet ? 32 : 117)));
        sb.append((char)((flag & 1) > 0 ? 86 : (onlySet ? 32 : 118)));
        sb.append((flag & 0x40) > 0 ? "VC" : (onlySet ? Character.valueOf(' ') : "vc"));
        return sb.toString();
    }

    public abstract int getWidthRaw();

    @Override
    public void setFillCell(boolean doFillCell) {
        this.doFillCell = doFillCell;
    }

    public boolean getFillCell() {
        return this.doFillCell;
    }

    @Override
    public TableColumnCore getTableColumnCore() {
        return this.tableColumn;
    }

    @Override
    public boolean setCursorID(int cursorID) {
        if (this.iCursorID == cursorID) {
            return false;
        }
        this.iCursorID = cursorID;
        return true;
    }

    @Override
    public int getCursorID() {
        return this.iCursorID;
    }

    @Override
    public void setMouseOver(boolean b) {
        this.mouseOver = b;
    }

    @Override
    public boolean isMouseOver() {
        if (this.tableRow != null && !this.tableRow.isVisible()) {
            return false;
        }
        return this.mouseOver;
    }

    @Override
    public boolean setIcon(Image img) {
        if (this.isInvisibleAndCanRefresh()) {
            return false;
        }
        this.icon = img;
        this.graphic = null;
        this.setFlag(64);
        return true;
    }

    @Override
    public Image getIcon() {
        return this.icon;
    }

    @Override
    public boolean setGraphic(Image img) {
        return this.setGraphic(new UISWTGraphicImpl(img));
    }

    @Override
    public boolean setGraphic(Graphic img) {
        if (img != null && this.isDisposed()) {
            return false;
        }
        if (this.tableColumn == null || this.tableColumn.getType() != 2) {
            return false;
        }
        if (img == this.graphic && this.numFastRefreshes >= MAX_REFRESHES) {
            this.pluginError("TableCellImpl::setGraphic to same Graphic object. Forcing refresh.");
        }
        boolean changed = img == this.graphic || img != null && !img.equals(this.graphic) || this.graphic != null && !this.graphic.equals(img);
        this.graphic = img;
        if (changed) {
            this.setFlag(64);
            this.redraw();
        }
        return changed;
    }

    @Override
    public Graphic getGraphic() {
        return this.graphic;
    }

    @Override
    public Image getGraphicSWT() {
        return this.graphic instanceof UISWTGraphic ? ((UISWTGraphic)this.graphic).getImage() : null;
    }

    public boolean isInvisibleAndCanRefresh() {
        return !this.isDisposed() && !this.isShown() && (this.refreshListeners != null || this.tableColumn.hasCellRefreshListener());
    }

    @Override
    public int[] getBackground() {
        Color color = this.getBackgroundSWT();
        if (color == null) {
            return null;
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    @Override
    public int[] getForeground() {
        Color color = this.getForegroundSWT();
        if (color == null) {
            return new int[3];
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    @Override
    public boolean setForeground(int red, int green, int blue) {
        if (this.isInvisibleAndCanRefresh()) {
            return false;
        }
        if (red < 0 || green < 0 || blue < 0) {
            return this.setForeground((Color)null);
        }
        return this.setForeground(new RGB(red, green, blue));
    }

    private boolean setForeground(final RGB rgb) {
        boolean changed;
        Color colorFG = this.getForegroundSWT();
        boolean bl = changed = colorFG == null || colorFG.isDisposed() || !colorFG.getRGB().equals(rgb);
        if (changed) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    TableCellSWTBase.this.setForeground(ColorCache.getColor((Device)Display.getCurrent(), rgb));
                }
            });
        }
        return changed;
    }

    @Override
    public boolean setForeground(int[] rgb) {
        if (rgb == null || rgb.length < 3) {
            return this.setForeground((Color)null);
        }
        return this.setForeground(rgb[0], rgb[1], rgb[2]);
    }

    @Override
    public boolean setForegroundToErrorColor() {
        return this.setForeground(Colors.colorError);
    }

    @Override
    public int[] getMouseOffset() {
        int[] nArray;
        Point ofs = ((TableViewSWT)this.tableRow.getView()).getTableCellMouseOffset(this);
        if (ofs == null) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = ofs.x;
            nArray = nArray2;
            nArray2[1] = ofs.y;
        }
        return nArray;
    }

    @Override
    public String getObfusticatedText() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.tableColumn.isObfusticated()) {
            if (this.tableColumn instanceof ObfusticateCellText) {
                return ((ObfusticateCellText)((Object)this.tableColumn)).getObfusticatedText(this);
            }
            return "";
        }
        return null;
    }
}

