/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.control.DHTControlContact;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.views.stats.VivaldiPanel;

public class VivaldiView
implements UISWTViewEventListener {
    public static final int DHT_TYPE_MAIN = 0;
    public static final int DHT_TYPE_CVS = 1;
    public static final int DHT_TYPE_MAIN_V6 = 3;
    public static final String MSGID_PREFIX = "VivaldiView";
    DHT dht;
    Composite panel;
    VivaldiPanel drawPanel;
    private final boolean autoAlpha;
    private int dht_type;
    private AzureusCore core;
    private UISWTView swtView;

    public VivaldiView(boolean autoAlpha) {
        this.autoAlpha = autoAlpha;
    }

    public VivaldiView() {
        this(false);
    }

    private void init(AzureusCore core) {
        try {
            PluginInterface dht_pi = core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi == null) {
                return;
            }
            DHT[] dhts = ((DHTPlugin)dht_pi.getPlugin()).getDHTs();
            for (int i = 0; i < dhts.length; ++i) {
                if (dhts[i].getTransport().getNetwork() != this.dht_type) continue;
                this.dht = dhts[i];
                break;
            }
            if (this.dht == null) {
                return;
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    private void initialize(Composite composite) {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                VivaldiView.this.core = core;
                VivaldiView.this.init(core);
            }
        });
        this.panel = new Composite(composite, 0);
        this.panel.setLayout(new FillLayout());
        this.drawPanel = new VivaldiPanel(this.panel);
        this.drawPanel.setAutoAlpha(this.autoAlpha);
    }

    private Composite getComposite() {
        return this.panel;
    }

    private void refresh() {
        if (this.dht == null) {
            if (this.core != null) {
                this.init(this.core);
            } else {
                return;
            }
        }
        if (this.dht != null) {
            List<DHTControlContact> l = this.dht.getControl().getContacts();
            this.drawPanel.refreshContacts(l, this.dht.getControl().getTransport().getLocalContact());
        }
    }

    private String getTitleID() {
        if (this.dht_type == 0) {
            return "VivaldiView.title.full";
        }
        if (this.dht_type == 1) {
            return "VivaldiView.title.fullcvs";
        }
        return "VivaldiView.title.full_v6";
    }

    private void delete() {
        if (this.drawPanel != null) {
            this.drawPanel.delete();
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl(this.getComposite());
                if (this.swtView == null) break;
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 1: {
                if (!(event2.getData() instanceof Number)) break;
                this.dht_type = ((Number)event2.getData()).intValue();
                if (this.swtView == null) break;
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

