/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.TabbedMdiInterface;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListenerEx;
import org.gudy.azureus2.ui.swt.views.IViewAlwaysInitialize;
import org.gudy.azureus2.ui.swt.views.stats.ActivityView;
import org.gudy.azureus2.ui.swt.views.stats.CacheView;
import org.gudy.azureus2.ui.swt.views.stats.DHTOpsView;
import org.gudy.azureus2.ui.swt.views.stats.DHTView;
import org.gudy.azureus2.ui.swt.views.stats.TagStatsView;
import org.gudy.azureus2.ui.swt.views.stats.TransferStatsView;
import org.gudy.azureus2.ui.swt.views.stats.VivaldiView;

public class StatsView
implements IViewAlwaysInitialize,
UISWTViewCoreEventListenerEx {
    public static String VIEW_ID = "StatsView";
    public static final int EVENT_PERIODIC_UPDATE = 256;
    private TabbedMdiInterface tabbedMDI;
    private UpdateThread updateThread;
    private Object dataSource;
    private UISWTView swtView;
    private Composite parent;
    private static boolean registeredCoreSubViews;

    @Override
    public boolean isCloneable() {
        return true;
    }

    @Override
    public UISWTViewCoreEventListener getClone() {
        return new StatsView();
    }

    private void initialize(Composite composite) {
        this.parent = composite;
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            this.tabbedMDI = uiFunctions.createTabbedMDI(composite, VIEW_ID);
            CTabFolder folder = this.tabbedMDI.getTabFolder();
            Label lblClose = new Label(folder, 64);
            lblClose.setText("x");
            lblClose.addListener(4, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    StatsView.this.delete();
                }
            });
            folder.setTopRight(lblClose);
            UISWTInstance pluginUI = uiFunctions.getUISWTInstance();
            if (pluginUI != null && !registeredCoreSubViews) {
                pluginUI.addView("StatsView", "SpeedView", ActivityView.class, null);
                pluginUI.addView("StatsView", "TransferStatsView", TransferStatsView.class, null);
                pluginUI.addView("StatsView", "CacheView", CacheView.class, null);
                pluginUI.addView("StatsView", "DHTView", DHTView.class, 0);
                pluginUI.addView("StatsView", "DHTOpsView", DHTOpsView.class, 0);
                pluginUI.addView("StatsView", "VivaldiView", VivaldiView.class, 0);
                if (NetworkAdmin.getSingleton().hasDHTIPV6()) {
                    pluginUI.addView("StatsView", "DHTView.6", DHTView.class, 3);
                    pluginUI.addView("StatsView", "VivaldiView.6", VivaldiView.class, 3);
                }
                if (Constants.isCVSVersion()) {
                    pluginUI.addView("StatsView", "DHTView.cvs", DHTView.class, 1);
                    pluginUI.addView("StatsView", "VivaldiView.cvs", VivaldiView.class, 1);
                }
                pluginUI.addView("StatsView", "TagStatsView", TagStatsView.class, null);
                registeredCoreSubViews = true;
            }
            if (pluginUI != null) {
                UISWTInstance.UISWTViewEventListenerWrapper[] pluginViews = pluginUI.getViewListeners("StatsView");
                for (int i = 0; i < pluginViews.length; ++i) {
                    UISWTInstance.UISWTViewEventListenerWrapper l = pluginViews[i];
                    String name = l.getViewID();
                    try {
                        MdiEntrySWT entry = (MdiEntrySWT)this.tabbedMDI.createEntryFromEventListener("StatsView", l, name, false, null, null);
                        entry.setDestroyOnDeactivate(false);
                        if ((this.dataSource != null || i != 0) && !name.equals(this.dataSource)) continue;
                        this.tabbedMDI.showEntry(entry);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        this.updateThread = new UpdateThread();
        this.updateThread.setDaemon(true);
        this.updateThread.start();
        this.dataSourceChanged(this.dataSource);
    }

    private void refresh() {
        if (this.tabbedMDI == null || this.tabbedMDI.isDisposed()) {
            return;
        }
        MdiEntrySWT entry = this.tabbedMDI.getCurrentEntrySWT();
        if (entry != null) {
            entry.updateUI();
        }
    }

    private String getFullTitle() {
        return MessageText.getString("Stats.title.full");
    }

    private void delete() {
        if (this.updateThread != null) {
            this.updateThread.stopIt();
        }
        Utils.disposeSWTObjects(new Object[]{this.parent});
    }

    private void dataSourceChanged(Object newDataSource) {
        this.dataSource = newDataSource;
        if (this.tabbedMDI == null) {
            return;
        }
        if (newDataSource instanceof String) {
            this.tabbedMDI.showEntryByID((String)newDataSource);
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                this.swtView.setDestroyOnDeactivate(false);
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private class UpdateThread
    extends Thread {
        boolean bContinue;

        public UpdateThread() {
            super("StatsView Update Thread");
        }

        @Override
        public void run() {
            this.bContinue = true;
            while (this.bContinue) {
                MdiEntry[] entries;
                for (MdiEntry entry : entries = StatsView.this.tabbedMDI.getEntries()) {
                    try {
                        ((MdiEntrySWT)entry).triggerEvent(256, null);
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    break;
                }
            }
        }

        public void stopIt() {
            this.bContinue = false;
        }
    }
}

