/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.control.DHTControlActivity;
import com.aelitis.azureus.core.dht.control.DHTControlListener;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.ui.swt.Utils;

public class DHTOpsPanel
implements DHTControlListener {
    private static final int ALPHA_FOCUS = 255;
    private static final int ALPHA_NOFOCUS = 150;
    private static final int FADE_OUT = 10000;
    Display display;
    Composite parent;
    Canvas canvas;
    Scale scale;
    private int min_slots = 8;
    private boolean unavailable;
    private boolean mouseLeftDown = false;
    private boolean mouseRightDown = false;
    private int xDown;
    private int yDown;
    private Image img;
    private int alpha = 255;
    private boolean autoAlpha = false;
    private DHT current_dht;
    private ActivityFilter filter;
    private Map<DHTControlActivity, ActivityDetail> activity_map = new HashMap<DHTControlActivity, ActivityDetail>();
    private TimerEventPeriodic timeout_timer;

    public DHTOpsPanel(Composite parent) {
        this.parent = parent;
        this.display = parent.getDisplay();
        this.canvas = new Canvas(parent, 262144);
        this.scale = new Scale();
        this.canvas.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                if (DHTOpsPanel.this.img != null && !DHTOpsPanel.this.img.isDisposed()) {
                    Rectangle bounds = DHTOpsPanel.this.img.getBounds();
                    if (bounds.width >= e.width && bounds.height >= e.height) {
                        if (DHTOpsPanel.this.alpha != 255) {
                            try {
                                e.gc.setAlpha(DHTOpsPanel.this.alpha);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        e.gc.drawImage(DHTOpsPanel.this.img, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                    }
                } else {
                    e.gc.setBackground(DHTOpsPanel.this.display.getSystemColor(22));
                    e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                    e.gc.drawText(MessageText.getString(DHTOpsPanel.this.unavailable ? "DHTOpsView.notAvailable" : "v3.MainWindow.view.wait"), 10, 10, true);
                }
            }
        });
        this.canvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent event2) {
                if (event2.button == 1) {
                    DHTOpsPanel.this.mouseLeftDown = true;
                }
                if (event2.button == 3) {
                    DHTOpsPanel.this.mouseRightDown = true;
                }
                DHTOpsPanel.this.xDown = event2.x;
                DHTOpsPanel.this.yDown = event2.y;
                DHTOpsPanel.this.scale.saveMinX = DHTOpsPanel.this.scale.minX;
                DHTOpsPanel.this.scale.saveMaxX = DHTOpsPanel.this.scale.maxX;
                DHTOpsPanel.this.scale.saveMinY = DHTOpsPanel.this.scale.minY;
                DHTOpsPanel.this.scale.saveMaxY = DHTOpsPanel.this.scale.maxY;
                DHTOpsPanel.this.scale.saveRotation = DHTOpsPanel.this.scale.rotation;
            }

            @Override
            public void mouseUp(MouseEvent event2) {
                if (event2.button == 1) {
                    DHTOpsPanel.this.mouseLeftDown = false;
                }
                if (event2.button == 3) {
                    DHTOpsPanel.this.mouseRightDown = false;
                }
                DHTOpsPanel.this.refresh();
            }
        });
        this.canvas.addListener(1, new Listener(){

            @Override
            public void handleEvent(Event event2) {
            }
        });
        this.canvas.addListener(37, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                DHTOpsPanel.this.scale.saveMinX = DHTOpsPanel.this.scale.minX;
                DHTOpsPanel.this.scale.saveMaxX = DHTOpsPanel.this.scale.maxX;
                DHTOpsPanel.this.scale.saveMinY = DHTOpsPanel.this.scale.minY;
                DHTOpsPanel.this.scale.saveMaxY = DHTOpsPanel.this.scale.maxY;
                int deltaY = event2.count * 5;
                float scaleFactor = 1.0f - (float)deltaY / 300.0f;
                if (scaleFactor <= 0.0f) {
                    scaleFactor = 0.01f;
                }
                float moveFactor = 1.0f - 1.0f / scaleFactor;
                float centerX = (DHTOpsPanel.this.scale.saveMinX + DHTOpsPanel.this.scale.saveMaxX) / 2.0f;
                DHTOpsPanel.this.scale.minX = DHTOpsPanel.this.scale.saveMinX + moveFactor * (centerX - DHTOpsPanel.this.scale.saveMinX);
                DHTOpsPanel.this.scale.maxX = DHTOpsPanel.this.scale.saveMaxX - moveFactor * (DHTOpsPanel.this.scale.saveMaxX - centerX);
                float centerY = (DHTOpsPanel.this.scale.saveMinY + DHTOpsPanel.this.scale.saveMaxY) / 2.0f;
                DHTOpsPanel.this.scale.minY = DHTOpsPanel.this.scale.saveMinY + moveFactor * (centerY - DHTOpsPanel.this.scale.saveMinY);
                DHTOpsPanel.this.scale.maxY = DHTOpsPanel.this.scale.saveMaxY - moveFactor * (DHTOpsPanel.this.scale.saveMaxY - centerY);
                DHTOpsPanel.this.refresh();
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){
            private long last_refresh;

            @Override
            public void mouseMove(MouseEvent event2) {
                long now;
                int deltaY;
                int deltaX;
                boolean do_refresh = false;
                if (DHTOpsPanel.this.mouseLeftDown && (event2.stateMask & SWT.MOD4) == 0) {
                    deltaX = event2.x - DHTOpsPanel.this.xDown;
                    deltaY = event2.y - DHTOpsPanel.this.yDown;
                    float width = DHTOpsPanel.this.scale.width;
                    float height = DHTOpsPanel.this.scale.height;
                    float ratioX = (DHTOpsPanel.this.scale.saveMaxX - DHTOpsPanel.this.scale.saveMinX) / width;
                    float ratioY = (DHTOpsPanel.this.scale.saveMaxY - DHTOpsPanel.this.scale.saveMinY) / height;
                    float realDeltaX = (float)deltaX * ratioX;
                    float realDeltaY = (float)deltaY * ratioY;
                    DHTOpsPanel.this.scale.minX = DHTOpsPanel.this.scale.saveMinX - realDeltaX;
                    DHTOpsPanel.this.scale.maxX = DHTOpsPanel.this.scale.saveMaxX - realDeltaX;
                    DHTOpsPanel.this.scale.minY = DHTOpsPanel.this.scale.saveMinY - realDeltaY;
                    DHTOpsPanel.this.scale.maxY = DHTOpsPanel.this.scale.saveMaxY - realDeltaY;
                    do_refresh = true;
                }
                if (DHTOpsPanel.this.mouseRightDown || DHTOpsPanel.this.mouseLeftDown && (event2.stateMask & SWT.MOD4) > 0) {
                    deltaX = event2.x - DHTOpsPanel.this.xDown;
                    DHTOpsPanel.this.scale.rotation = DHTOpsPanel.this.scale.saveRotation - (double)((float)deltaX / 100.0f);
                    deltaY = event2.y - DHTOpsPanel.this.yDown;
                    float scaleFactor = 1.0f - (float)deltaY / 300.0f;
                    if (scaleFactor <= 0.0f) {
                        scaleFactor = 0.01f;
                    }
                    float moveFactor = 1.0f - 1.0f / scaleFactor;
                    float centerX = (DHTOpsPanel.this.scale.saveMinX + DHTOpsPanel.this.scale.saveMaxX) / 2.0f;
                    DHTOpsPanel.this.scale.minX = DHTOpsPanel.this.scale.saveMinX + moveFactor * (centerX - DHTOpsPanel.this.scale.saveMinX);
                    DHTOpsPanel.this.scale.maxX = DHTOpsPanel.this.scale.saveMaxX - moveFactor * (DHTOpsPanel.this.scale.saveMaxX - centerX);
                    float centerY = (DHTOpsPanel.this.scale.saveMinY + DHTOpsPanel.this.scale.saveMaxY) / 2.0f;
                    DHTOpsPanel.this.scale.minY = DHTOpsPanel.this.scale.saveMinY + moveFactor * (centerY - DHTOpsPanel.this.scale.saveMinY);
                    DHTOpsPanel.this.scale.maxY = DHTOpsPanel.this.scale.saveMaxY - moveFactor * (DHTOpsPanel.this.scale.saveMaxY - centerY);
                    do_refresh = true;
                }
                if (do_refresh && (now = SystemTime.getMonotonousTime()) - this.last_refresh >= 250L) {
                    this.last_refresh = now;
                    DHTOpsPanel.this.refresh();
                }
            }
        });
        this.canvas.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent e) {
            }

            @Override
            public void mouseExit(MouseEvent e) {
                if (DHTOpsPanel.this.autoAlpha) {
                    DHTOpsPanel.this.setAlpha(150);
                }
            }

            @Override
            public void mouseEnter(MouseEvent e) {
                if (DHTOpsPanel.this.autoAlpha) {
                    DHTOpsPanel.this.setAlpha(255);
                }
            }
        });
        this.timeout_timer = SimpleTimer.addPeriodicEvent("DHTOps:timer", 30000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                if (DHTOpsPanel.this.canvas.isDisposed()) {
                    DHTOpsPanel.this.timeout_timer.cancel();
                    return;
                }
                Map map = DHTOpsPanel.this.activity_map;
                synchronized (map) {
                    Iterator it = DHTOpsPanel.this.activity_map.values().iterator();
                    while (it.hasNext()) {
                        ActivityDetail act = (ActivityDetail)it.next();
                        if (!act.isComplete()) continue;
                        it.remove();
                    }
                }
            }
        });
    }

    public void setLayoutData(Object data) {
        this.canvas.setLayoutData(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activityChanged(DHTControlActivity activity, int type) {
        if (this.filter != null && !this.filter.accept(activity)) {
            return;
        }
        if (activity.isQueued()) {
            return;
        }
        Map<DHTControlActivity, ActivityDetail> map = this.activity_map;
        synchronized (map) {
            ActivityDetail details = this.activity_map.get(activity);
            if (details == null) {
                details = new ActivityDetail(activity);
                this.activity_map.put(activity, details);
            }
            if (type == 3) {
                details.setComplete();
            }
        }
    }

    protected void setUnavailable() {
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                DHTOpsPanel.this.unavailable = true;
                if (!DHTOpsPanel.this.canvas.isDisposed()) {
                    DHTOpsPanel.this.canvas.redraw();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshView(DHT dht) {
        if (this.current_dht != dht) {
            if (this.current_dht != null) {
                this.current_dht.getControl().removeListener(this);
            }
            this.current_dht = dht;
            Map<DHTControlActivity, ActivityDetail> map = this.activity_map;
            synchronized (map) {
                this.activity_map.clear();
            }
            dht.getControl().addListener(this);
        }
        this.refresh();
    }

    public void setFilter(ActivityFilter f) {
        this.filter = f;
    }

    public void setMinimumSlots(int min) {
        this.min_slots = min;
    }

    public void setScaleAndRotation(float min_x, float max_x, float min_y, float max_y, double rot) {
        this.scale.minX = min_x;
        this.scale.maxX = max_x;
        this.scale.minY = min_y;
        this.scale.maxY = max_y;
        this.scale.rotation = rot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        ArrayList<ActivityDetail> activities;
        if (this.canvas.isDisposed()) {
            return;
        }
        Rectangle size = this.canvas.getBounds();
        if (size.width <= 0 || size.height <= 0) {
            return;
        }
        this.scale.width = size.width;
        this.scale.height = size.height;
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
        }
        this.img = new Image((Device)this.display, size);
        GC gc = new GC(this.img);
        gc.setAdvanced(true);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        Color white = ColorCache.getColor(this.display, 255, 255, 255);
        gc.setForeground(white);
        gc.setBackground(white);
        gc.fillRectangle(size);
        ArrayList<ActivityDetail> to_remove = new ArrayList<ActivityDetail>();
        Map<DHTControlActivity, ActivityDetail> map = this.activity_map;
        synchronized (map) {
            activities = new ArrayList<ActivityDetail>(this.activity_map.values());
        }
        long now = SystemTime.getMonotonousTime();
        int max_slot = Math.max(activities.size(), this.min_slots);
        for (ActivityDetail details : activities) {
            max_slot = Math.max(max_slot, details.getSlot() + 1);
            long comp_at = details.getCompleteTime();
            if (comp_at < 0L || now - comp_at <= 10000L) continue;
            to_remove.add(details);
        }
        boolean[] slots_in_use = new boolean[max_slot];
        for (ActivityDetail details : activities) {
            int slot = details.getSlot();
            if (slot == -1) continue;
            slots_in_use[slot] = true;
        }
        int pos = 0;
        for (ActivityDetail details : activities) {
            int slot = details.getSlot();
            if (slot != -1) continue;
            while (slots_in_use[pos]) {
                ++pos;
            }
            details.setSlot(pos++);
        }
        int x_origin = this.scale.getX(0.0f, 0.0f);
        int y_origin = this.scale.getY(0.0f, 0.0f);
        double slice_angle = Math.PI * 2 / (double)max_slot;
        for (ActivityDetail details : activities) {
            details.draw(gc, x_origin, y_origin, slice_angle);
        }
        gc.setForeground(ColorCache.getColor(gc.getDevice(), 0, 0, 0));
        if (activities.size() == 0) {
            gc.drawText(MessageText.getString("DHTOpsView.idle"), x_origin, y_origin);
        } else {
            gc.drawLine(x_origin - 5, y_origin, x_origin + 5, y_origin);
            gc.drawLine(x_origin, y_origin - 5, x_origin, y_origin + 5);
        }
        gc.dispose();
        this.canvas.redraw();
        if (to_remove.size() > 0) {
            Map<DHTControlActivity, ActivityDetail> map2 = this.activity_map;
            synchronized (map2) {
                for (ActivityDetail detail : to_remove) {
                    this.activity_map.remove(detail.getActivity());
                }
            }
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public void setAutoAlpha(boolean autoAlpha) {
        this.autoAlpha = autoAlpha;
        if (autoAlpha) {
            this.setAlpha(this.canvas.getDisplay().getCursorControl() == this.canvas ? 255 : 150);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
        }
        if (this.current_dht != null) {
            this.current_dht.getControl().removeListener(this);
            this.current_dht = null;
        }
        Map<DHTControlActivity, ActivityDetail> map = this.activity_map;
        synchronized (map) {
            this.activity_map.clear();
        }
    }

    private class ActivityDetail {
        private DHTControlActivity activity;
        private long complete_time = -1L;
        private int slot = -1;
        private int draw_count = 0;
        private String result_str = "";

        private ActivityDetail(DHTControlActivity _act) {
            this.activity = _act;
        }

        private DHTControlActivity getActivity() {
            return this.activity;
        }

        private void setComplete() {
            this.complete_time = SystemTime.getMonotonousTime();
        }

        private long getCompleteTime() {
            return this.complete_time;
        }

        private boolean isComplete() {
            return this.complete_time != -1L && SystemTime.getMonotonousTime() - this.complete_time > 10000L;
        }

        private int getSlot() {
            return this.slot;
        }

        private void setSlot(int _s) {
            this.slot = _s;
        }

        private void draw(GC gc, int x_origin, int y_origin, double slice_angle) {
            ++this.draw_count;
            this.setColour(gc);
            double angle = slice_angle * (double)this.slot;
            DHTControlActivity.ActivityState state_maybe_null = this.activity.getCurrentState();
            if (state_maybe_null != null) {
                int depth = state_maybe_null.getDepth();
                int level_depth = 750 / depth;
                DHTControlActivity.ActivityNode root = state_maybe_null.getRootNode();
                ArrayList<Object[]> level_nodes = new ArrayList<Object[]>();
                float x_start = (float)(50.0 * Math.sin(angle));
                float y_start = (float)(50.0 * Math.cos(angle));
                level_nodes.add(new Object[]{root, Float.valueOf(x_start), Float.valueOf(y_start)});
                int node_distance = 50;
                while (true) {
                    int nodes_at_next_level = 0;
                    for (Object[] entry : level_nodes) {
                        nodes_at_next_level += ((DHTControlActivity.ActivityNode)entry[0]).getChildren().size();
                    }
                    if (nodes_at_next_level == 0) break;
                    node_distance += level_depth;
                    double node_slice_angle = slice_angle / (double)nodes_at_next_level;
                    double current_angle = angle;
                    if (nodes_at_next_level > 1) {
                        current_angle -= slice_angle / 2.0;
                        current_angle += (slice_angle - node_slice_angle * (double)(nodes_at_next_level - 1)) / 2.0;
                    }
                    ArrayList<Object[]> next_level_nodes = new ArrayList<Object[]>();
                    for (Object[] entry : level_nodes) {
                        DHTControlActivity.ActivityNode node = (DHTControlActivity.ActivityNode)entry[0];
                        float node_x = ((Float)entry[1]).floatValue();
                        float node_y = ((Float)entry[2]).floatValue();
                        int seg_start_x = DHTOpsPanel.this.scale.getX(node_x, node_y);
                        int seg_start_y = DHTOpsPanel.this.scale.getY(node_x, node_y);
                        List<DHTControlActivity.ActivityNode> kids = node.getChildren();
                        for (DHTControlActivity.ActivityNode kid : kids) {
                            float kid_x = (float)((double)node_distance * Math.sin(current_angle));
                            float kid_y = (float)((double)node_distance * Math.cos(current_angle));
                            next_level_nodes.add(new Object[]{kid, Float.valueOf(kid_x), Float.valueOf(kid_y)});
                            current_angle += node_slice_angle;
                            int seg_end_x = DHTOpsPanel.this.scale.getX(kid_x, kid_y);
                            int seg_end_y = DHTOpsPanel.this.scale.getY(kid_x, kid_y);
                            gc.drawLine(seg_start_x, seg_start_y, seg_end_x, seg_end_y);
                            gc.drawOval(seg_end_x, seg_end_y, 1, 1);
                        }
                    }
                    level_nodes = next_level_nodes;
                }
            }
            float x_end = (float)(850.0 * Math.sin(angle));
            float y_end = (float)(850.0 * Math.cos(angle));
            int text_x = DHTOpsPanel.this.scale.getX(x_end, y_end);
            int text_y = DHTOpsPanel.this.scale.getY(x_end, y_end);
            String desc = this.activity.getDescription();
            if (this.complete_time >= 0L && this.result_str.length() == 0 && state_maybe_null != null) {
                this.result_str = (desc.length() == 0 ? "" : ": ") + state_maybe_null.getResult();
            }
            gc.drawText(desc + this.result_str, text_x, text_y);
            gc.setAlpha(255);
        }

        private void setColour(GC gc) {
            if (this.complete_time != -1L && this.draw_count > 1) {
                int age = (int)(SystemTime.getMonotonousTime() - this.complete_time);
                gc.setAlpha(Math.max(0, 200 - 255 * age / 10000));
                gc.setForeground(ColorCache.getColor(gc.getDevice(), 0, 0, 0));
            } else {
                gc.setAlpha(255);
                int type = this.activity.getType();
                if (type == 2) {
                    gc.setForeground(ColorCache.getColor(gc.getDevice(), 20, 200, 20));
                } else if (type == 1) {
                    gc.setForeground(ColorCache.getColor(gc.getDevice(), 140, 160, 40));
                } else if (type == 4) {
                    gc.setForeground(ColorCache.getColor(gc.getDevice(), 20, 20, 220));
                } else {
                    gc.setForeground(ColorCache.getColor(gc.getDevice(), 40, 140, 160));
                }
            }
        }
    }

    public static interface ActivityFilter {
        public boolean accept(DHTControlActivity var1);
    }

    private static class Scale {
        int width;
        int height;
        float minX = -1000.0f;
        float maxX = 1000.0f;
        float minY = -1000.0f;
        float maxY = 1000.0f;
        double rotation = 0.0;
        float saveMinX;
        float saveMaxX;
        float saveMinY;
        float saveMaxY;
        double saveRotation;

        private Scale() {
        }

        public int getX(float x, float y) {
            return (int)(((double)x * Math.cos(this.rotation) + (double)y * Math.sin(this.rotation) - (double)this.minX) / (double)(this.maxX - this.minX) * (double)this.width);
        }

        public int getY(float x, float y) {
            return (int)(((double)y * Math.cos(this.rotation) - (double)x * Math.sin(this.rotation) - (double)this.minY) / (double)(this.maxY - this.minY) * (double)this.height);
        }
    }
}

