/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerStats;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.graphics.SpeedGraphic;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;

public class CacheView
implements UISWTViewCoreEventListener {
    public static final String MSGID_PREFIX = "CacheView";
    CacheFileManagerStats stats;
    Composite panel;
    Label lblInUse;
    Label lblSize;
    Label lblPercentUsed;
    ProgressBar pbInUse;
    Label lblReadsFromCache;
    Label lblNumberReadsFromCache;
    Label lblAvgSizeFromCache;
    Label lblReadsFromFile;
    Label lblNumberReadsFromFile;
    Label lblAvgSizeFromFile;
    Label lblPercentReads;
    ProgressBar pbReads;
    Label lblWritesToCache;
    Label lblNumberWritesToCache;
    Label lblAvgSizeToCache;
    Label lblWritesToFile;
    Label lblNumberWritesToFile;
    Label lblAvgSizeToFile;
    Label lblPercentWrites;
    ProgressBar pbWrites;
    Canvas readsFromFile;
    Canvas readsFromCache;
    Canvas writesToCache;
    Canvas writesToFile;
    SpeedGraphic rffGraph;
    SpeedGraphic rfcGraph;
    SpeedGraphic wtcGraph;
    SpeedGraphic wtfGraph;
    private UISWTView swtView;

    public CacheView() {
        try {
            this.stats = CacheFileManagerFactory.getSingleton().getStats();
            this.rfcGraph = SpeedGraphic.getInstance();
            this.wtcGraph = SpeedGraphic.getInstance();
            this.rffGraph = SpeedGraphic.getInstance();
            this.wtfGraph = SpeedGraphic.getInstance();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    private void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        this.panel.setLayout(new GridLayout());
        this.generateGeneralGroup();
        this.generateReadsGroup();
        this.generateWritesGroup();
        this.generateSpeedGroup();
    }

    private void generateGeneralGroup() {
        Group gCacheGeneral = new Group(this.panel, 0);
        Messages.setLanguageText(gCacheGeneral, "CacheView.general.title");
        Utils.setLayoutData((Control)gCacheGeneral, new GridData(768));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 4;
        gCacheGeneral.setLayout(layoutGeneral);
        Label lbl = new Label(gCacheGeneral, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)lbl, gridData);
        Messages.setLanguageText(lbl, "CacheView.general.inUse");
        this.lblInUse = new Label(gCacheGeneral, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblInUse, gridData);
        this.pbInUse = new ProgressBar(gCacheGeneral, 256);
        gridData = new GridData(768);
        gridData.verticalSpan = 2;
        Utils.setLayoutData((Control)this.pbInUse, gridData);
        this.pbInUse.setMinimum(0);
        this.pbInUse.setMaximum(1000);
        this.lblPercentUsed = new Label(gCacheGeneral, 0);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblPercentUsed, gridData);
        lbl = new Label(gCacheGeneral, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)lbl, gridData);
        Messages.setLanguageText(lbl, "CacheView.general.size");
        this.lblSize = new Label(gCacheGeneral, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblSize, gridData);
    }

    private void generateReadsGroup() {
        Group gCacheReads = new Group(this.panel, 0);
        Messages.setLanguageText(gCacheReads, "CacheView.reads.title");
        Utils.setLayoutData((Control)gCacheReads, new GridData(768));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 6;
        gCacheReads.setLayout(layoutGeneral);
        Label lbl = new Label(gCacheReads, 0);
        lbl = new Label(gCacheReads, 0);
        Messages.setLanguageText(lbl, "CacheView.reads.#");
        lbl = new Label(gCacheReads, 0);
        Messages.setLanguageText(lbl, "CacheView.reads.amount");
        lbl = new Label(gCacheReads, 0);
        Messages.setLanguageText(lbl, "CacheView.reads.avgsize");
        lbl = new Label(gCacheReads, 0);
        lbl = new Label(gCacheReads, 0);
        lbl = new Label(gCacheReads, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)lbl, gridData);
        Messages.setLanguageText(lbl, "CacheView.reads.fromCache");
        this.lblNumberReadsFromCache = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblNumberReadsFromCache, gridData);
        this.lblReadsFromCache = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblReadsFromCache, gridData);
        this.lblAvgSizeFromCache = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblAvgSizeFromCache, gridData);
        this.pbReads = new ProgressBar(gCacheReads, 256);
        gridData = new GridData(768);
        gridData.verticalSpan = 2;
        Utils.setLayoutData((Control)this.pbReads, gridData);
        this.pbReads.setMinimum(0);
        this.pbReads.setMaximum(1000);
        this.lblPercentReads = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblPercentReads, gridData);
        lbl = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)lbl, gridData);
        Messages.setLanguageText(lbl, "CacheView.reads.fromFile");
        this.lblNumberReadsFromFile = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblNumberReadsFromFile, gridData);
        this.lblReadsFromFile = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblReadsFromFile, gridData);
        this.lblAvgSizeFromFile = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblAvgSizeFromFile, gridData);
    }

    private void generateSpeedGroup() {
        Group gCacheSpeeds = new Group(this.panel, 0);
        Messages.setLanguageText(gCacheSpeeds, "CacheView.speeds.title");
        Utils.setLayoutData((Control)gCacheSpeeds, new GridData(1808));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 3;
        gCacheSpeeds.setLayout(layoutGeneral);
        Label lbl = new Label(gCacheSpeeds, 0);
        lbl = new Label(gCacheSpeeds, 0);
        GridData gridData = new GridData(64);
        Utils.setLayoutData((Control)lbl, gridData);
        Messages.setLanguageText(lbl, "CacheView.speeds.reads");
        lbl = new Label(gCacheSpeeds, 0);
        gridData = new GridData(64);
        Utils.setLayoutData((Control)lbl, gridData);
        Messages.setLanguageText(lbl, "CacheView.speeds.writes");
        lbl = new Label(gCacheSpeeds, 0);
        Messages.setLanguageText(lbl, "CacheView.speeds.fromCache");
        this.readsFromCache = new Canvas(gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        Utils.setLayoutData((Control)this.readsFromCache, gridData);
        this.rfcGraph.initialize(this.readsFromCache);
        this.writesToCache = new Canvas(gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        Utils.setLayoutData((Control)this.writesToCache, gridData);
        this.wtcGraph.initialize(this.writesToCache);
        lbl = new Label(gCacheSpeeds, 0);
        Messages.setLanguageText(lbl, "CacheView.speeds.fromFile");
        this.readsFromFile = new Canvas(gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        Utils.setLayoutData((Control)this.readsFromFile, gridData);
        this.rffGraph.initialize(this.readsFromFile);
        this.writesToFile = new Canvas(gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        Utils.setLayoutData((Control)this.writesToFile, gridData);
        this.wtfGraph.initialize(this.writesToFile);
    }

    public void periodicUpdate() {
        this.rfcGraph.addIntValue((int)this.stats.getAverageBytesReadFromCache());
        this.rffGraph.addIntValue((int)this.stats.getAverageBytesReadFromFile());
        this.wtcGraph.addIntValue((int)this.stats.getAverageBytesWrittenToCache());
        this.wtfGraph.addIntValue((int)this.stats.getAverageBytesWrittenToFile());
    }

    private void generateWritesGroup() {
        Group gCacheWrites = new Group(this.panel, 0);
        Messages.setLanguageText(gCacheWrites, "CacheView.writes.title");
        Utils.setLayoutData((Control)gCacheWrites, new GridData(768));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 6;
        gCacheWrites.setLayout(layoutGeneral);
        Label lbl = new Label(gCacheWrites, 0);
        lbl = new Label(gCacheWrites, 0);
        Messages.setLanguageText(lbl, "CacheView.reads.#");
        lbl = new Label(gCacheWrites, 0);
        Messages.setLanguageText(lbl, "CacheView.reads.amount");
        lbl = new Label(gCacheWrites, 0);
        Messages.setLanguageText(lbl, "CacheView.reads.avgsize");
        lbl = new Label(gCacheWrites, 0);
        lbl = new Label(gCacheWrites, 0);
        lbl = new Label(gCacheWrites, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)lbl, gridData);
        Messages.setLanguageText(lbl, "CacheView.writes.toCache");
        this.lblNumberWritesToCache = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblNumberWritesToCache, gridData);
        this.lblWritesToCache = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblWritesToCache, gridData);
        this.lblAvgSizeToCache = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblAvgSizeToCache, gridData);
        this.pbWrites = new ProgressBar(gCacheWrites, 256);
        gridData = new GridData(768);
        gridData.verticalSpan = 2;
        Utils.setLayoutData((Control)this.pbWrites, gridData);
        this.pbWrites.setMinimum(0);
        this.pbWrites.setMaximum(1000);
        this.lblPercentWrites = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblPercentWrites, gridData);
        lbl = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)lbl, gridData);
        Messages.setLanguageText(lbl, "CacheView.writes.toFile");
        this.lblNumberWritesToFile = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblNumberWritesToFile, gridData);
        this.lblWritesToFile = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblWritesToFile, gridData);
        this.lblAvgSizeToFile = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)this.lblAvgSizeToFile, gridData);
    }

    private void delete() {
        Utils.disposeComposite(this.panel);
        this.rfcGraph.dispose();
        this.rffGraph.dispose();
        this.wtcGraph.dispose();
        this.wtfGraph.dispose();
    }

    private Composite getComposite() {
        return this.panel;
    }

    private void refresh() {
        this.lblSize.setText(DisplayFormatters.formatByteCountToKiBEtc(this.stats.getSize()));
        this.lblInUse.setText(DisplayFormatters.formatByteCountToKiBEtc(this.stats.getUsedSize()));
        int perThousands = (int)(1000L * this.stats.getUsedSize() / this.stats.getSize());
        this.lblPercentUsed.setText(DisplayFormatters.formatPercentFromThousands(perThousands));
        this.pbInUse.setSelection(perThousands);
        this.refrehReads();
        this.refreshWrites();
        this.rfcGraph.refresh(false);
        this.rffGraph.refresh(false);
        this.wtcGraph.refresh(false);
        this.wtfGraph.refresh(false);
    }

    private void refrehReads() {
        long readsFromCache = this.stats.getBytesReadFromCache();
        long readsFromFile = this.stats.getBytesReadFromFile();
        long nbReadsFromCache = this.stats.getCacheReadCount();
        long nbReadsFromFile = this.stats.getFileReadCount();
        this.lblNumberReadsFromCache.setText("" + nbReadsFromCache);
        this.lblNumberReadsFromFile.setText("" + nbReadsFromFile);
        if (nbReadsFromCache != 0L) {
            long avgReadFromCache = readsFromCache / nbReadsFromCache;
            this.lblAvgSizeFromCache.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadFromCache));
        } else {
            this.lblAvgSizeFromCache.setText("--");
        }
        if (nbReadsFromFile != 0L) {
            long avgReadFromFile = readsFromFile / nbReadsFromFile;
            this.lblAvgSizeFromFile.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadFromFile));
        } else {
            this.lblAvgSizeFromFile.setText("--");
        }
        this.lblReadsFromCache.setText(DisplayFormatters.formatByteCountToKiBEtc(readsFromCache));
        this.lblReadsFromFile.setText(DisplayFormatters.formatByteCountToKiBEtc(readsFromFile));
        long totalRead = readsFromCache + readsFromFile;
        if (totalRead > 0L) {
            int perThousands = (int)(1000L * this.stats.getBytesReadFromCache() / totalRead);
            this.lblPercentReads.setText(DisplayFormatters.formatPercentFromThousands(perThousands) + " " + MessageText.getString("CacheView.reads.hits"));
            this.pbReads.setSelection(perThousands);
        }
    }

    private void refreshWrites() {
        long writesToCache = this.stats.getBytesWrittenToCache();
        long writesToFile = this.stats.getBytesWrittenToFile();
        long nbWritesToCache = this.stats.getCacheWriteCount();
        long nbWritesToFile = this.stats.getFileWriteCount();
        this.lblNumberWritesToCache.setText("" + nbWritesToCache);
        this.lblNumberWritesToFile.setText("" + nbWritesToFile);
        if (nbWritesToCache != 0L) {
            long avgReadToCache = writesToCache / nbWritesToCache;
            this.lblAvgSizeToCache.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadToCache));
        } else {
            this.lblAvgSizeToCache.setText("--");
        }
        if (nbWritesToFile != 0L) {
            long avgReadToFile = writesToFile / nbWritesToFile;
            this.lblAvgSizeToFile.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadToFile));
        } else {
            this.lblAvgSizeToFile.setText("--");
        }
        this.lblWritesToCache.setText(DisplayFormatters.formatByteCountToKiBEtc(writesToCache));
        this.lblWritesToFile.setText(DisplayFormatters.formatByteCountToKiBEtc(writesToFile));
        long totalNbWrites = nbWritesToCache + nbWritesToFile;
        if (totalNbWrites > 0L) {
            int perThousands = (int)(1000L * nbWritesToCache / totalNbWrites);
            this.lblPercentWrites.setText(DisplayFormatters.formatPercentFromThousands(perThousands) + " " + MessageText.getString("CacheView.writes.hits"));
            this.pbWrites.setSelection(perThousands);
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(MessageText.getString("CacheView.title.full"));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl(this.getComposite());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 256: {
                this.periodicUpdate();
            }
        }
        return true;
    }
}

