/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.piece;

import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.util.MapUtils;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPieceListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.Legend;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListenerEx;
import org.gudy.azureus2.ui.swt.views.ViewUtils;

public class PieceInfoView
implements DownloadManagerPieceListener,
UISWTViewCoreEventListenerEx {
    private static final int BLOCK_FILLSIZE = 14;
    private static final int BLOCK_SPACING = 3;
    private static final int BLOCK_SIZE = 17;
    private static final int BLOCKCOLOR_HAVE = 0;
    private static final int BLOCKCOLORL_NOHAVE = 1;
    private static final int BLOCKCOLOR_TRANSFER = 2;
    private static final int BLOCKCOLOR_NEXT = 3;
    private static final int BLOCKCOLOR_AVAILCOUNT = 4;
    public static final String MSGID_PREFIX = "PieceInfoView";
    private Composite pieceInfoComposite;
    private ScrolledComposite sc;
    protected Canvas pieceInfoCanvas;
    private Color[] blockColors;
    private Label topLabel;
    private String topLabelLHS = "";
    private String topLabelRHS = "";
    private Label imageLabel;
    private int graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update") * 2;
    private int loopFactor = 0;
    private Font font = null;
    Image img = null;
    private DownloadManager dlm;
    BlockInfo[] oldBlockInfo;
    private boolean alreadyFilling = false;
    private UISWTView swtView;

    public PieceInfoView() {
        this.blockColors = new Color[]{Colors.blues[9], Colors.white, Colors.red, Colors.fadedRed, Colors.black};
    }

    @Override
    public boolean isCloneable() {
        return true;
    }

    @Override
    public UISWTViewCoreEventListener getClone() {
        return new PieceInfoView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataSourceChanged(Object newDataSource) {
        PEPiece piece;
        DiskManager diskManager;
        Object[] objects;
        DownloadManager newManager = ViewUtils.getDownloadManagerFromDataSource(newDataSource);
        if (newManager != null) {
            this.oldBlockInfo = null;
        } else if (newDataSource instanceof Object[] && (objects = (Object[])newDataSource).length > 0 && objects[0] instanceof PEPiece && (diskManager = (piece = (PEPiece)objects[0]).getDMPiece().getManager()) instanceof DiskManagerImpl) {
            DiskManagerImpl dmi = (DiskManagerImpl)diskManager;
            newManager = dmi.getDownloadManager();
        }
        PieceInfoView pieceInfoView = this;
        synchronized (pieceInfoView) {
            if (this.dlm != null) {
                this.dlm.removePieceListener(this);
            }
            this.dlm = newManager;
            if (this.dlm != null) {
                this.dlm.addPieceListener(this, false);
            }
        }
        if (newManager != null) {
            this.fillPieceInfoSection();
        }
    }

    private String getFullTitle() {
        return MessageText.getString("PeersView.BlockView.title");
    }

    private void initialize(Composite composite) {
        if (this.pieceInfoComposite != null && !this.pieceInfoComposite.isDisposed()) {
            Logger.log(new LogEvent(LogIDs.GUI, 3, "PeerInfoView already initialized! Stack: " + Debug.getStackTrace(true, false)));
            this.delete();
        }
        this.createPeerInfoPanel(composite);
        this.fillPieceInfoSection();
    }

    private Composite createPeerInfoPanel(Composite parent) {
        this.pieceInfoComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.pieceInfoComposite.setLayout(layout);
        GridData gridData = new GridData(4, 4, true, true);
        this.pieceInfoComposite.setLayoutData(gridData);
        this.imageLabel = new Label(this.pieceInfoComposite, 0);
        gridData = new GridData();
        this.imageLabel.setLayoutData(gridData);
        this.topLabel = new Label(this.pieceInfoComposite, 0);
        gridData = new GridData(4, -1, false, false);
        this.topLabel.setLayoutData(gridData);
        this.sc = new ScrolledComposite(this.pieceInfoComposite, 512);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.sc.setLayout(layout);
        gridData = new GridData(4, 4, true, true, 2, 1);
        this.sc.setLayoutData(gridData);
        this.sc.getVerticalBar().setIncrement(17);
        this.pieceInfoCanvas = new Canvas(this.sc, 0x140000);
        gridData = new GridData(4, -1, true, false);
        this.pieceInfoCanvas.setLayoutData(gridData);
        this.pieceInfoCanvas.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                if (e.width <= 0 || e.height <= 0) {
                    return;
                }
                try {
                    Rectangle bounds;
                    Rectangle rectangle = bounds = PieceInfoView.this.img == null ? null : PieceInfoView.this.img.getBounds();
                    if (bounds == null || PieceInfoView.this.dlm == null || PieceInfoView.this.dlm.getPeerManager() == null) {
                        e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                    } else {
                        if (e.x + e.width > bounds.width) {
                            e.gc.fillRectangle(bounds.width, e.y, e.x + e.width - bounds.width + 1, e.height);
                        }
                        if (e.y + e.height > bounds.height) {
                            e.gc.fillRectangle(e.x, bounds.height, e.width, e.y + e.height - bounds.height + 1);
                        }
                        int width = Math.min(e.width, bounds.width - e.x);
                        int height = Math.min(e.height, bounds.height - e.y);
                        e.gc.drawImage(PieceInfoView.this.img, e.x, e.y, width, height, e.x, e.y, width, height);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Listener doNothingListener = new Listener(){

            @Override
            public void handleEvent(Event event2) {
            }
        };
        this.pieceInfoCanvas.addListener(1, doNothingListener);
        this.pieceInfoCanvas.addListener(11, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(Event e) {
                PieceInfoView pieceInfoView = PieceInfoView.this;
                synchronized (pieceInfoView) {
                    if (PieceInfoView.this.alreadyFilling) {
                        return;
                    }
                    PieceInfoView.this.alreadyFilling = true;
                }
                Utils.execSWTThreadLater(0, new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void runSupport() {
                        int iNewColCount;
                        int iOldColCount;
                        if (PieceInfoView.this.img != null && (iOldColCount = PieceInfoView.this.img.getBounds().width / 17) != (iNewColCount = PieceInfoView.this.pieceInfoCanvas.getClientArea().width / 17)) {
                            PieceInfoView.this.refreshInfoCanvas();
                        }
                        PieceInfoView pieceInfoView = PieceInfoView.this;
                        synchronized (pieceInfoView) {
                            PieceInfoView.this.alreadyFilling = false;
                        }
                    }
                });
            }
        });
        this.sc.setContent(this.pieceInfoCanvas);
        this.pieceInfoCanvas.addMouseTrackListener(new MouseTrackAdapter(){

            @Override
            public void mouseHover(MouseEvent event2) {
                int piece_number = PieceInfoView.this.getPieceNumber(event2.x, event2.y);
                if (piece_number >= 0) {
                    DiskManager disk_manager = PieceInfoView.this.dlm.getDiskManager();
                    PEPeerManager pm = PieceInfoView.this.dlm.getPeerManager();
                    DiskManagerPiece dm_piece = disk_manager.getPiece(piece_number);
                    PEPiece pm_piece = pm.getPiece(piece_number);
                    String text = "Piece " + piece_number + ": " + dm_piece.getString();
                    if (pm_piece != null) {
                        text = text + ", active: " + pm_piece.getString();
                    } else if (dm_piece.isNeeded() && !dm_piece.isDone()) {
                        text = text + ", inactive: " + pm.getPiecePicker().getPieceString(piece_number);
                    }
                    PieceInfoView.this.topLabelRHS = text;
                } else {
                    PieceInfoView.this.topLabelRHS = "";
                }
                PieceInfoView.this.updateTopLabel();
            }
        });
        final Menu menu = new Menu(this.pieceInfoCanvas.getShell(), 8);
        this.pieceInfoCanvas.setMenu(menu);
        this.pieceInfoCanvas.addListener(35, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                Point pt = PieceInfoView.this.pieceInfoCanvas.toControl(event2.x, event2.y);
                int piece_number = PieceInfoView.this.getPieceNumber(pt.x, pt.y);
                menu.setData("pieceNumber", piece_number);
            }
        });
        MenuBuildUtils.addMaintenanceListenerForMenu(menu, new MenuBuildUtils.MenuBuilder(){

            @Override
            public void buildMenu(Menu menu, MenuEvent event2) {
                Integer pn = (Integer)menu.getData("pieceNumber");
                if (pn != null && pn != -1) {
                    DownloadManager download_manager = PieceInfoView.this.dlm;
                    if (download_manager == null) {
                        return;
                    }
                    DiskManager disk_manager = download_manager.getDiskManager();
                    PEPeerManager peer_manager = download_manager.getPeerManager();
                    if (disk_manager == null || peer_manager == null) {
                        return;
                    }
                    final PiecePicker picker = peer_manager.getPiecePicker();
                    DiskManagerPiece[] dm_pieces = disk_manager.getPieces();
                    PEPiece[] pe_pieces = peer_manager.getPieces();
                    final int piece_number = pn;
                    final DiskManagerPiece dm_piece = dm_pieces[piece_number];
                    final PEPiece pm_piece = pe_pieces[piece_number];
                    final MenuItem force_piece = new MenuItem(menu, 32);
                    Messages.setLanguageText(force_piece, "label.force.piece");
                    boolean done = dm_piece.isDone();
                    force_piece.setEnabled(!done);
                    if (!done) {
                        force_piece.setSelection(picker.isForcePiece(piece_number));
                        force_piece.addSelectionListener(new SelectionAdapter(){

                            @Override
                            public void widgetSelected(SelectionEvent e) {
                                picker.setForcePiece(piece_number, force_piece.getSelection());
                            }
                        });
                    }
                    MenuItem reset_piece = new MenuItem(menu, 8);
                    Messages.setLanguageText(reset_piece, "label.reset.piece");
                    boolean can_reset = dm_piece.isDone() || dm_piece.getNbWritten() > 0;
                    reset_piece.setEnabled(can_reset);
                    reset_piece.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            dm_piece.reset();
                            if (pm_piece != null) {
                                pm_piece.reset();
                            }
                        }
                    });
                }
            }
        });
        Legend.createLegendComposite(this.pieceInfoComposite, this.blockColors, new String[]{"PiecesView.BlockView.Have", "PiecesView.BlockView.NoHave", "PeersView.BlockView.Transfer", "PeersView.BlockView.NextRequest", "PeersView.BlockView.AvailCount"}, new GridData(4, -1, true, false, 2, 1));
        int iFontPixelsHeight = 10;
        int iFontPointHeight = iFontPixelsHeight * 72 / Utils.getDPIRaw((Device)this.pieceInfoCanvas.getDisplay()).y;
        Font f = this.pieceInfoCanvas.getFont();
        FontData[] fontData = f.getFontData();
        fontData[0].setHeight(iFontPointHeight);
        this.font = new Font((Device)this.pieceInfoCanvas.getDisplay(), fontData);
        return this.pieceInfoComposite;
    }

    private int getPieceNumber(int x, int y) {
        DownloadManager manager = this.dlm;
        if (manager == null) {
            return -1;
        }
        PEPeerManager pm = manager.getPeerManager();
        if (pm == null) {
            return -1;
        }
        Rectangle bounds = this.pieceInfoCanvas.getClientArea();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return -1;
        }
        int y_block = y / 17;
        int iNumCols = bounds.width / 17;
        int x_block = x / 17;
        int piece_number = y_block * iNumCols + x_block;
        if (piece_number >= pm.getPiecePicker().getNumberOfPieces()) {
            return -1;
        }
        return piece_number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillPieceInfoSection() {
        PieceInfoView pieceInfoView = this;
        synchronized (pieceInfoView) {
            if (this.alreadyFilling) {
                return;
            }
            this.alreadyFilling = true;
        }
        Utils.execSWTThreadLater(100, new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                PieceInfoView pieceInfoView = PieceInfoView.this;
                synchronized (pieceInfoView) {
                    if (!PieceInfoView.this.alreadyFilling) {
                        return;
                    }
                }
                try {
                    if (PieceInfoView.this.imageLabel == null || PieceInfoView.this.imageLabel.isDisposed()) {
                        return;
                    }
                    if (PieceInfoView.this.imageLabel.getImage() != null) {
                        Image image = PieceInfoView.this.imageLabel.getImage();
                        PieceInfoView.this.imageLabel.setImage(null);
                        image.dispose();
                    }
                    PieceInfoView.this.refreshInfoCanvas();
                }
                finally {
                    pieceInfoView = PieceInfoView.this;
                    synchronized (pieceInfoView) {
                        PieceInfoView.this.alreadyFilling = false;
                    }
                }
            }
        });
    }

    private void refresh() {
        if (this.loopFactor++ % this.graphicsUpdate == 0) {
            this.refreshInfoCanvas();
        }
    }

    private void updateTopLabel() {
        String text = this.topLabelLHS;
        if (text.length() > 0 && this.topLabelRHS.length() > 0) {
            text = text + "; " + this.topLabelRHS;
        }
        this.topLabel.setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshInfoCanvas() {
        PieceInfoView pieceInfoView = this;
        synchronized (pieceInfoView) {
            this.alreadyFilling = false;
        }
        if (this.pieceInfoCanvas == null || this.pieceInfoCanvas.isDisposed() || !this.pieceInfoCanvas.isVisible()) {
            return;
        }
        this.pieceInfoCanvas.layout(true);
        Rectangle bounds = this.pieceInfoCanvas.getClientArea();
        if (bounds.width <= 0 || bounds.height <= 0) {
            this.topLabelLHS = "";
            this.updateTopLabel();
            return;
        }
        if (this.dlm == null) {
            GC gc = new GC(this.pieceInfoCanvas);
            gc.fillRectangle(bounds);
            gc.dispose();
            this.topLabelLHS = MessageText.getString("view.one.download.only");
            this.topLabelRHS = "";
            this.updateTopLabel();
            return;
        }
        PEPeerManager pm = this.dlm.getPeerManager();
        DiskManager dm = this.dlm.getDiskManager();
        if (pm == null || dm == null) {
            GC gc = new GC(this.pieceInfoCanvas);
            gc.fillRectangle(bounds);
            gc.dispose();
            this.topLabelLHS = "";
            this.updateTopLabel();
            return;
        }
        int iNumCols = bounds.width / 17;
        int iNeededHeight = ((dm.getNbPieces() - 1) / iNumCols + 1) * 17;
        if (this.img != null && !this.img.isDisposed()) {
            Rectangle imgBounds = this.img.getBounds();
            if (imgBounds.width != bounds.width || imgBounds.height != iNeededHeight) {
                this.oldBlockInfo = null;
                this.img.dispose();
                this.img = null;
            }
        }
        DiskManagerPiece[] dm_pieces = dm.getPieces();
        PEPiece[] currentDLPieces = pm.getPieces();
        byte[] uploadingPieces = new byte[dm_pieces.length];
        for (PEPeer peer : pm.getPeers()) {
            int[] peerRequestedPieces = peer.getIncomingRequestedPieceNumbers();
            if (peerRequestedPieces == null || peerRequestedPieces.length <= 0) continue;
            int pieceNum = peerRequestedPieces[0];
            if (uploadingPieces[pieceNum] < 2) {
                uploadingPieces[pieceNum] = 2;
            }
            for (int j = 1; j < peerRequestedPieces.length; ++j) {
                pieceNum = peerRequestedPieces[j];
                if (uploadingPieces[pieceNum] >= 1) continue;
                uploadingPieces[pieceNum] = 1;
            }
        }
        if (this.sc.getMinHeight() != iNeededHeight) {
            this.sc.setMinHeight(iNeededHeight);
            this.sc.layout(true, true);
            bounds = this.pieceInfoCanvas.getClientArea();
        }
        int[] availability = pm.getAvailability();
        int minAvailability = Integer.MAX_VALUE;
        int minAvailability2 = Integer.MAX_VALUE;
        if (availability != null && availability.length > 0) {
            for (int i = 0; i < availability.length; ++i) {
                if (availability[i] == 0 || availability[i] >= minAvailability) continue;
                minAvailability2 = minAvailability;
                minAvailability = availability[i];
                if (minAvailability == 1) break;
            }
        }
        if (this.img == null) {
            this.img = new Image((Device)this.pieceInfoCanvas.getDisplay(), bounds.width, iNeededHeight);
            this.oldBlockInfo = null;
        }
        GC gcImg = new GC(this.img);
        BlockInfo[] newBlockInfo = new BlockInfo[dm_pieces.length];
        int iRow = 0;
        try {
            gcImg.setAdvanced(true);
            if (this.oldBlockInfo == null) {
                gcImg.setBackground(this.pieceInfoCanvas.getBackground());
                gcImg.fillRectangle(0, 0, bounds.width, iNeededHeight);
            }
            gcImg.setFont(this.font);
            int iCol = 0;
            for (int i = 0; i < dm_pieces.length; ++i) {
                int colorIndex;
                if (iCol >= iNumCols) {
                    iCol = 0;
                    ++iRow;
                }
                newBlockInfo[i] = new BlockInfo();
                boolean done = dm_pieces[i].isDone();
                int iXPos = iCol * 17 + 1;
                int iYPos = iRow * 17 + 1;
                if (done) {
                    colorIndex = 0;
                    newBlockInfo[i].haveWidth = 14;
                } else {
                    boolean partiallyDone = dm_pieces[i].getNbWritten() > 0;
                    int width = 14;
                    if (partiallyDone) {
                        int iNewWidth = (int)((float)dm_pieces[i].getNbWritten() / (float)dm_pieces[i].getNbBlocks() * (float)width);
                        if (iNewWidth >= width) {
                            iNewWidth = width - 1;
                        } else if (iNewWidth <= 0) {
                            iNewWidth = 1;
                        }
                        newBlockInfo[i].haveWidth = iNewWidth;
                    }
                }
                if (currentDLPieces[i] != null && currentDLPieces[i].hasUndownloadedBlock()) {
                    newBlockInfo[i].downloadingIndicator = true;
                }
                boolean bl = newBlockInfo[i].uploadingIndicator = uploadingPieces[i] > 0;
                if (newBlockInfo[i].uploadingIndicator) {
                    boolean bl2 = newBlockInfo[i].uploadingIndicatorSmall = uploadingPieces[i] < 2;
                }
                if (availability != null) {
                    newBlockInfo[i].availNum = availability[i];
                    if (minAvailability2 == availability[i]) {
                        newBlockInfo[i].availDotted = true;
                    }
                } else {
                    newBlockInfo[i].availNum = -1;
                }
                if (this.oldBlockInfo != null && i < this.oldBlockInfo.length && this.oldBlockInfo[i].sameAs(newBlockInfo[i])) {
                    ++iCol;
                    continue;
                }
                gcImg.setBackground(this.pieceInfoCanvas.getBackground());
                gcImg.fillRectangle(iCol * 17, iRow * 17, 17, 17);
                colorIndex = 0;
                gcImg.setBackground(this.blockColors[colorIndex]);
                gcImg.fillRectangle(iXPos, iYPos, newBlockInfo[i].haveWidth, 14);
                colorIndex = 1;
                gcImg.setBackground(this.blockColors[colorIndex]);
                gcImg.fillRectangle(iXPos + newBlockInfo[i].haveWidth, iYPos, 14 - newBlockInfo[i].haveWidth, 14);
                if (newBlockInfo[i].downloadingIndicator) {
                    this.drawDownloadIndicator(gcImg, iXPos, iYPos, false);
                }
                if (newBlockInfo[i].uploadingIndicator) {
                    this.drawUploadIndicator(gcImg, iXPos, iYPos, newBlockInfo[i].uploadingIndicatorSmall);
                }
                if (newBlockInfo[i].availNum != -1) {
                    if (minAvailability == newBlockInfo[i].availNum) {
                        gcImg.setForeground(this.blockColors[4]);
                        gcImg.drawRectangle(iXPos - 1, iYPos - 1, 15, 15);
                    }
                    if (minAvailability2 == newBlockInfo[i].availNum) {
                        gcImg.setLineStyle(3);
                        gcImg.setForeground(this.blockColors[4]);
                        gcImg.drawRectangle(iXPos - 1, iYPos - 1, 15, 15);
                        gcImg.setLineStyle(1);
                    }
                    String sNumber = String.valueOf(newBlockInfo[i].availNum);
                    Point size = gcImg.stringExtent(sNumber);
                    if (newBlockInfo[i].availNum < 100) {
                        int x = iXPos + 7 - size.x / 2;
                        int y = iYPos + 7 - size.y / 2;
                        gcImg.setForeground(this.blockColors[4]);
                        gcImg.drawText(sNumber, x, y, true);
                    }
                }
                ++iCol;
            }
            this.oldBlockInfo = newBlockInfo;
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LogIDs.GUI, "drawing piece map", e));
        }
        finally {
            gcImg.dispose();
        }
        this.topLabelLHS = MessageText.getString("PiecesView.BlockView.Header", new String[]{"" + iNumCols, "" + (iRow + 1), "" + dm_pieces.length});
        this.updateTopLabel();
        this.pieceInfoCanvas.redraw();
    }

    private void drawDownloadIndicator(GC gcImg, int iXPos, int iYPos, boolean small) {
        if (small) {
            gcImg.setBackground(this.blockColors[3]);
            gcImg.fillPolygon(new int[]{iXPos + 2, iYPos + 2, iXPos + 14 - 1, iYPos + 2, iXPos + 7, iYPos + 14 - 1});
        } else {
            gcImg.setBackground(this.blockColors[2]);
            gcImg.fillPolygon(new int[]{iXPos, iYPos, iXPos + 14, iYPos, iXPos + 7, iYPos + 14});
        }
    }

    private void drawUploadIndicator(GC gcImg, int iXPos, int iYPos, boolean small) {
        if (!small) {
            gcImg.setBackground(this.blockColors[2]);
            gcImg.fillPolygon(new int[]{iXPos, iYPos + 14, iXPos + 14, iYPos + 14, iXPos + 7, iYPos});
        } else {
            gcImg.setBackground(this.blockColors[3]);
            gcImg.fillPolygon(new int[]{iXPos + 1, iYPos + 14 - 2, iXPos + 14 - 2, iYPos + 14 - 2, iXPos + 7, iYPos + 2});
        }
    }

    private Composite getComposite() {
        return this.pieceInfoComposite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete() {
        if (this.imageLabel != null && !this.imageLabel.isDisposed() && this.imageLabel.getImage() != null) {
            Image image = this.imageLabel.getImage();
            this.imageLabel.setImage(null);
            image.dispose();
        }
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
            this.img = null;
        }
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
            this.font = null;
        }
        PieceInfoView pieceInfoView = this;
        synchronized (pieceInfoView) {
            if (this.dlm != null) {
                this.dlm.removePieceListener(this);
                this.dlm = null;
            }
        }
    }

    private Image obfusticatedImage(Image image) {
        UIDebugGenerator.obfusticateArea(image, this.topLabel, "");
        return image;
    }

    @Override
    public void pieceAdded(PEPiece piece) {
        this.fillPieceInfoSection();
    }

    @Override
    public void pieceRemoved(PEPiece piece) {
        this.fillPieceInfoSection();
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl(this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 9: {
                Object data = event2.getData();
                if (!(data instanceof Map)) break;
                this.obfusticatedImage((Image)MapUtils.getMapObject((Map)data, "image", null, Image.class));
            }
        }
        return true;
    }

    private static class BlockInfo {
        public int haveWidth = -1;
        int availNum;
        boolean availDotted;
        boolean uploadingIndicator;
        boolean uploadingIndicatorSmall;
        boolean downloadingIndicator;

        public boolean sameAs(BlockInfo otherBlockInfo) {
            return this.haveWidth == otherBlockInfo.haveWidth && this.availNum == otherBlockInfo.availNum && this.availDotted == otherBlockInfo.availDotted && this.uploadingIndicator == otherBlockInfo.uploadingIndicator && this.uploadingIndicatorSmall == otherBlockInfo.uploadingIndicatorSmall && this.downloadingIndicator == otherBlockInfo.downloadingIndicator;
        }
    }
}

