/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.SpeedManagerListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.views.stats.TransferStatsView;

public class ConfigSectionTransferAutoSpeedSelect
implements UISWTConfigSection {
    private static final String CFG_PREFIX = "ConfigView.section.transfer.autospeed.";
    StringListParameter versionList;
    BooleanParameter enableAutoSpeed;
    BooleanParameter enableAutoSpeedWhileSeeding;

    @Override
    public String configSectionGetParentSection() {
        return "transfer";
    }

    @Override
    public String configSectionGetName() {
        return "transfer.select";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
    }

    @Override
    public int maxUserMode() {
        return 0;
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        if (!AzureusCoreFactory.isCoreRunning()) {
            cSection.setLayout(new FillLayout());
            Label lblNotAvail = new Label(cSection, 64);
            Messages.setLanguageText(lblNotAvail, "core.not.available");
            return cSection;
        }
        GridData gridData = new GridData(272);
        Utils.setLayoutData((Control)cSection, gridData);
        GridLayout subPanel = new GridLayout();
        subPanel.numColumns = 3;
        cSection.setLayout(subPanel);
        Group modeGroup = new Group(cSection, 0);
        Messages.setLanguageText(modeGroup, "ConfigTransferAutoSpeed.algorithm.selector");
        GridLayout modeLayout = new GridLayout();
        modeLayout.numColumns = 3;
        modeGroup.setLayout(modeLayout);
        gridData = new GridData(768);
        Utils.setLayoutData((Control)modeGroup, gridData);
        Label label = new Label(modeGroup, 0);
        Messages.setLanguageText(label, "ConfigTransferAutoSpeed.algorithm");
        gridData = new GridData();
        Utils.setLayoutData((Control)label, gridData);
        String AutoSpeedClassic = MessageText.getString("ConfigTransferAutoSpeed.auto.speed.classic");
        String AutoSpeedBeta = MessageText.getString("ConfigTransferAutoSpeed.auto.speed.beta");
        String AutoSpeedNeural = MessageText.getString("ConfigTransferAutoSpeed.auto.speed.neural");
        String[] modeNames = new String[]{AutoSpeedClassic, AutoSpeedBeta, AutoSpeedNeural};
        String[] modes = new String[]{"1", "2", "3"};
        this.versionList = new StringListParameter(modeGroup, "Auto_Upload_Speed_Version_String", modeNames, modes);
        long verNum = COConfigurationManager.getLongParameter("Auto Upload Speed Version");
        if (verNum == 1L) {
            this.versionList.setValue(modes[0]);
        } else if (verNum == 2L) {
            this.versionList.setValue(modes[1]);
        } else if (verNum == 3L) {
            this.versionList.setValue(modes[2]);
        } else {
            this.versionList.setValue(modes[0]);
        }
        this.versionList.addChangeListener(new ConvertToLongChangeListener());
        Label spacer = new Label(modeGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        Utils.setLayoutData((Control)spacer, gridData);
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 2;
        this.enableAutoSpeed = new BooleanParameter((Composite)modeGroup, "Auto Upload Speed Enabled", "ConfigView.section.transfer.autospeed.enableauto");
        this.enableAutoSpeed.setLayoutData(gridData);
        spacer = new Label(modeGroup, 0);
        this.enableAutoSpeedWhileSeeding = new BooleanParameter((Composite)modeGroup, "Auto Upload Speed Seeding Enabled", "ConfigView.section.transfer.autospeed.enableautoseeding");
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 2;
        this.enableAutoSpeedWhileSeeding.setLayoutData(gridData);
        this.enableAutoSpeed.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(this.enableAutoSpeedWhileSeeding.getControls(), true));
        spacer = new Label(modeGroup, 0);
        spacer = new Label(cSection, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        Utils.setLayoutData((Control)spacer, gridData);
        Group networkGroup = new Group(cSection, 0);
        Messages.setLanguageText(networkGroup, "ConfigView.section.transfer.autospeed.networks");
        GridLayout networksLayout = new GridLayout();
        networksLayout.numColumns = 5;
        networkGroup.setLayout(networksLayout);
        gridData = new GridData(768);
        networkGroup.setLayoutData(gridData);
        label = new Label(networkGroup, 0);
        Messages.setLanguageText(label, "SpeedView.stats.asn");
        final Label asn_label = new Label(networkGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        asn_label.setLayoutData(gridData);
        label = new Label(networkGroup, 0);
        Messages.setLanguageText(label, "SpeedView.stats.estupcap");
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        Utils.setLayoutData((Control)label, gridData);
        final Label up_cap = new Label(networkGroup, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        Utils.setLayoutData((Control)up_cap, gridData);
        label = new Label(networkGroup, 0);
        Messages.setLanguageText(label, "SpeedView.stats.estdowncap");
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        Utils.setLayoutData((Control)label, gridData);
        final Label down_cap = new Label(networkGroup, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        Utils.setLayoutData((Control)down_cap, gridData);
        final SpeedManager sm = AzureusCoreFactory.getSingleton().getSpeedManager();
        final TransferStatsView.limitToTextHelper limit_to_text = new TransferStatsView.limitToTextHelper();
        asn_label.setText(sm.getASN());
        up_cap.setText(limit_to_text.getLimitText(sm.getEstimatedUploadCapacityBytesPerSec()));
        down_cap.setText(limit_to_text.getLimitText(sm.getEstimatedDownloadCapacityBytesPerSec()));
        spacer = new Label(networkGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        Utils.setLayoutData((Control)spacer, gridData);
        Label info_label = new Label(networkGroup, 64);
        Messages.setLanguageText((Widget)info_label, "ConfigView.section.transfer.autospeed.network.info", new String[]{DisplayFormatters.getRateUnit(1)});
        Utils.setLayoutData((Control)info_label, Utils.getWrappableLabelGridData(5, 0));
        label = new Label(networkGroup, 0);
        Messages.setLanguageText(label, "SpeedView.stats.estupcap");
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        Utils.setLayoutData((Control)label, gridData);
        String co_up = "AutoSpeed Network Upload Speed (temp)";
        String co_up_type = "AutoSpeed Network Upload Speed Type (temp)";
        SpeedManagerLimitEstimate up_lim = sm.getEstimatedUploadCapacityBytesPerSec();
        COConfigurationManager.setParameter(co_up, up_lim.getBytesPerSec() / 1024);
        COConfigurationManager.setParameter(co_up_type, limit_to_text.getSettableType(up_lim));
        final IntParameter max_upload = new IntParameter(networkGroup, co_up);
        final Label upload_bits = new Label(networkGroup, 0);
        gridData = new GridData();
        Utils.setLayoutData((Control)upload_bits, gridData);
        upload_bits.setText(this.getMBitLimit(limit_to_text, up_lim.getBytesPerSec() / 1024 * 1024));
        final StringListParameter max_upload_type = new StringListParameter(networkGroup, co_up_type, limit_to_text.getSettableTypes(), limit_to_text.getSettableTypes());
        max_upload_type.addChangeListener(new ParameterChangeAdapter(){

            @Override
            public void parameterChanged(Parameter p, boolean caused_internally) {
                if (max_upload_type.isDisposed()) {
                    return;
                }
                float type = limit_to_text.textToType(max_upload_type.getValue());
                SpeedManagerLimitEstimate existing = sm.getEstimatedUploadCapacityBytesPerSec();
                if (existing.getEstimateType() != type) {
                    sm.setEstimatedUploadCapacityBytesPerSec(existing.getBytesPerSec(), type);
                }
            }
        });
        max_upload.addChangeListener(new ParameterChangeAdapter(){

            @Override
            public void parameterChanged(Parameter p, boolean caused_internally) {
                if (max_upload.isDisposed()) {
                    return;
                }
                int value = max_upload.getValue() * 1024;
                SpeedManagerLimitEstimate existing = sm.getEstimatedUploadCapacityBytesPerSec();
                if (existing.getBytesPerSec() != value) {
                    sm.setEstimatedUploadCapacityBytesPerSec(value, existing.getEstimateType());
                }
            }
        });
        label = new Label(networkGroup, 0);
        label = new Label(networkGroup, 0);
        Messages.setLanguageText(label, "SpeedView.stats.estdowncap");
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        Utils.setLayoutData((Control)label, gridData);
        SpeedManagerLimitEstimate down_lim = sm.getEstimatedDownloadCapacityBytesPerSec();
        String co_down = "AutoSpeed Network Download Speed (temp)";
        String co_down_type = "AutoSpeed Network Download Speed Type (temp)";
        COConfigurationManager.setParameter(co_down, down_lim.getBytesPerSec() / 1024);
        COConfigurationManager.setParameter(co_down_type, limit_to_text.getSettableType(down_lim));
        final IntParameter max_download = new IntParameter(networkGroup, co_down);
        final Label download_bits = new Label(networkGroup, 0);
        gridData = new GridData();
        Utils.setLayoutData((Control)download_bits, gridData);
        download_bits.setText(this.getMBitLimit(limit_to_text, down_lim.getBytesPerSec() / 1024 * 1024));
        final StringListParameter max_download_type = new StringListParameter(networkGroup, co_down_type, limit_to_text.getSettableTypes(), limit_to_text.getSettableTypes());
        max_download_type.addChangeListener(new ParameterChangeAdapter(){

            @Override
            public void parameterChanged(Parameter p, boolean caused_internally) {
                if (max_download_type.isDisposed()) {
                    return;
                }
                float type = limit_to_text.textToType(max_download_type.getValue());
                SpeedManagerLimitEstimate existing = sm.getEstimatedDownloadCapacityBytesPerSec();
                if (existing.getEstimateType() != type) {
                    sm.setEstimatedDownloadCapacityBytesPerSec(existing.getBytesPerSec(), type);
                }
            }
        });
        max_download.addChangeListener(new ParameterChangeAdapter(){

            @Override
            public void parameterChanged(Parameter p, boolean caused_internally) {
                if (max_download.isDisposed()) {
                    return;
                }
                int value = max_download.getValue() * 1024;
                SpeedManagerLimitEstimate existing = sm.getEstimatedDownloadCapacityBytesPerSec();
                if (existing.getBytesPerSec() != value) {
                    sm.setEstimatedDownloadCapacityBytesPerSec(value, existing.getEstimateType());
                }
            }
        });
        label = new Label(networkGroup, 0);
        Label reset_label = new Label(networkGroup, 0);
        Messages.setLanguageText(reset_label, "ConfigView.section.transfer.autospeed.resetnetwork");
        Button reset_button = new Button(networkGroup, 8);
        Messages.setLanguageText(reset_button, "ConfigView.section.transfer.autospeed.reset.button");
        reset_button.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                sm.reset();
            }
        });
        sm.addListener(new SpeedManagerListener(){
            private final SpeedManagerListener listener = this;

            @Override
            public void propertyChanged(final int property) {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        if (asn_label.isDisposed()) {
                            sm.removeListener(listener);
                        } else if (property == 1) {
                            asn_label.setText(sm.getASN());
                        } else if (property == 2) {
                            SpeedManagerLimitEstimate limit = sm.getEstimatedUploadCapacityBytesPerSec();
                            up_cap.setText(limit_to_text.getLimitText(limit));
                            upload_bits.setText(ConfigSectionTransferAutoSpeedSelect.this.getMBitLimit(limit_to_text, limit.getBytesPerSec()));
                            max_upload.setValue(limit.getBytesPerSec() / 1024);
                            max_upload_type.setValue(limit_to_text.getSettableType(limit));
                        } else if (property == 3) {
                            SpeedManagerLimitEstimate limit = sm.getEstimatedDownloadCapacityBytesPerSec();
                            down_cap.setText(limit_to_text.getLimitText(limit));
                            download_bits.setText(ConfigSectionTransferAutoSpeedSelect.this.getMBitLimit(limit_to_text, limit.getBytesPerSec()));
                            max_download.setValue(limit.getBytesPerSec() / 1024);
                            max_download_type.setValue(limit_to_text.getSettableType(limit));
                        }
                    }
                });
            }
        });
        spacer = new Label(cSection, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        Utils.setLayoutData((Control)spacer, gridData);
        BooleanParameter debug_au = new BooleanParameter(cSection, "Auto Upload Speed Debug Enabled", "ConfigView.section.transfer.autospeed.enabledebug");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        debug_au.setLayoutData(gridData);
        spacer = new Label(cSection, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        Utils.setLayoutData((Control)spacer, gridData);
        Group azWiki = new Group(cSection, 64);
        gridData = new GridData();
        Utils.setLayoutData((Control)azWiki, gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 1;
        layout.marginWidth = 20;
        azWiki.setLayout(layout);
        azWiki.setText(MessageText.getString("Utils.link.visit"));
        Label linkLabel = new Label(azWiki, 0);
        linkLabel.setText(Constants.APP_NAME + " Wiki AutoSpeed (beta)");
        linkLabel.setData("http://wiki.vuze.com/w/Auto_Speed");
        linkLabel.setCursor(linkLabel.getDisplay().getSystemCursor(21));
        linkLabel.setForeground(Colors.blue);
        gridData = new GridData();
        Utils.setLayoutData((Control)linkLabel, gridData);
        linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }

            @Override
            public void mouseUp(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }
        });
        ClipboardCopy.addCopyToClipMenu(linkLabel);
        return cSection;
    }

    protected String getMBitLimit(TransferStatsView.limitToTextHelper helper, long value) {
        return "(" + (value == 0L ? helper.getUnlimited() : DisplayFormatters.formatByteCountToBitsPerSec(value)) + ")";
    }

    static class ConvertToLongChangeListener
    implements ParameterChangeListener {
        ConvertToLongChangeListener() {
        }

        @Override
        public void parameterChanged(Parameter p, boolean caused_internally) {
            try {
                String str = COConfigurationManager.getStringParameter("Auto_Upload_Speed_Version_String");
                long asLong = Long.parseLong(str);
                COConfigurationManager.setParameter("Auto Upload Speed Version", asLong);
            }
            catch (Throwable t) {
                COConfigurationManager.setParameter("Auto Upload Speed Version", 1);
            }
        }

        @Override
        public void intParameterChanging(Parameter p, int toValue) {
        }

        @Override
        public void booleanParameterChanging(Parameter p, boolean toValue) {
        }

        @Override
        public void stringParameterChanging(Parameter p, String toValue) {
        }

        @Override
        public void floatParameterChanging(Parameter owner, double toValue) {
        }
    }
}

