/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionTransferAutoSpeedBeta
implements UISWTConfigSection {
    private Group commentGroup;
    private Group uploadCapGroup;
    private Group dhtGroup;
    private IntParameter adjustmentInterval;
    private BooleanParameter skipAfterAdjustment;

    @Override
    public String configSectionGetParentSection() {
        return "transfer.select";
    }

    @Override
    public String configSectionGetName() {
        return "transfer.select.v2";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
    }

    @Override
    public int maxUserMode() {
        return 0;
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData(gridData);
        GridLayout subPanel = new GridLayout();
        subPanel.numColumns = 3;
        cSection.setLayout(subPanel);
        this.commentGroup = new Group(cSection, 0);
        Messages.setLanguageText(this.commentGroup, "ConfigTransferAutoSpeed.add.comment.to.log.group");
        GridLayout commentLayout = new GridLayout();
        commentLayout.numColumns = 3;
        this.commentGroup.setLayout(commentLayout);
        gridData = new GridData(768);
        this.commentGroup.setLayoutData(gridData);
        Label commentLabel = new Label(this.commentGroup, 0);
        Messages.setLanguageText(commentLabel, "ConfigTransferAutoSpeed.add.comment.to.log");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        commentLabel.setLayoutData(gridData);
        final Text commentBox = new Text(this.commentGroup, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        commentBox.setText("");
        commentBox.setLayoutData(gridData);
        Button commentButton = new Button(this.commentGroup, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        commentButton.setLayoutData(gridData);
        Messages.setLanguageText(commentButton, "ConfigTransferAutoSpeed.log.button");
        commentButton.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                AEDiagnosticsLogger dLog = AEDiagnostics.getLogger("AutoSpeed");
                String comment = commentBox.getText();
                if (comment != null && comment.length() > 0) {
                    dLog.log("user-comment:" + comment);
                    commentBox.setText("");
                }
            }
        });
        Label commentSpacer = new Label(cSection, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        commentSpacer.setLayoutData(gridData);
        this.uploadCapGroup = new Group(cSection, 0);
        Messages.setLanguageText(this.uploadCapGroup, "ConfigTransferAutoSpeed.upload.capacity.usage");
        GridLayout uCapLayout = new GridLayout();
        uCapLayout.numColumns = 2;
        this.uploadCapGroup.setLayout(uCapLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.uploadCapGroup.setLayoutData(gridData);
        Label upCapModeLbl = new Label(this.uploadCapGroup, 0);
        gridData = new GridData();
        upCapModeLbl.setLayoutData(gridData);
        Messages.setLanguageText(upCapModeLbl, "ConfigTransferAutoSpeed.mode");
        Label ucSetLbl = new Label(this.uploadCapGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        Messages.setLanguageText(ucSetLbl, "ConfigTransferAutoSpeed.capacity.used");
        Label dlModeLbl = new Label(this.uploadCapGroup, 0);
        gridData = new GridData();
        Messages.setLanguageText(dlModeLbl, "ConfigTransferAutoSpeed.while.downloading");
        String[] downloadModeNames = new String[]{" 80%", " 70%", " 60%", " 50%"};
        int[] downloadModeValues = new int[]{80, 70, 60, 50};
        new IntListParameter(this.uploadCapGroup, "SpeedLimitMonitor.setting.upload.used.download.mode", downloadModeNames, downloadModeValues);
        Label cSpacer = new Label(cSection, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        cSpacer.setLayoutData(gridData);
        this.dhtGroup = new Group(cSection, 0);
        Messages.setLanguageText(this.dhtGroup, "ConfigTransferAutoSpeed.data.update.frequency");
        this.dhtGroup.setLayout(subPanel);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.dhtGroup.setLayoutData(gridData);
        Label iCount = new Label(this.dhtGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 1;
        iCount.setLayoutData(gridData);
        Messages.setLanguageText(iCount, "ConfigTransferAutoSpeed.adjustment.interval");
        this.adjustmentInterval = new IntParameter(this.dhtGroup, "SpeedManagerAlgorithmProviderV2.intervals.between.adjust");
        gridData = new GridData();
        this.adjustmentInterval.setLayoutData(gridData);
        cSpacer = new Label(cSection, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        cSpacer.setLayoutData(gridData);
        Label skip = new Label(this.dhtGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 1;
        skip.setLayoutData(gridData);
        Messages.setLanguageText(skip, "ConfigTransferAutoSpeed.skip.after.adjust");
        this.skipAfterAdjustment = new BooleanParameter(this.dhtGroup, "SpeedManagerAlgorithmProviderV2.setting.wait.after.adjust");
        gridData = new GridData();
        this.skipAfterAdjustment.setLayoutData(gridData);
        cSpacer = new Label(cSection, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        cSpacer.setLayoutData(gridData);
        return cSection;
    }

    void enableGroups(String strategyListValue) {
        if (strategyListValue == null) {
            return;
        }
        boolean isBothEnabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
        boolean isSeedingEnabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Seeding Enabled");
        long version = COConfigurationManager.getLongParameter("Auto Upload Speed Version");
        boolean isV2Enabled = false;
        if ((isBothEnabled || isSeedingEnabled) && version == 2L) {
            isV2Enabled = true;
        }
        if (this.commentGroup != null) {
            if (isV2Enabled) {
                this.commentGroup.setEnabled(true);
                this.commentGroup.setVisible(true);
            } else {
                this.commentGroup.setEnabled(false);
                this.commentGroup.setVisible(false);
            }
        }
    }

    static class GroupModeChangeListener
    implements ParameterChangeListener {
        GroupModeChangeListener() {
        }

        @Override
        public void parameterChanged(Parameter p, boolean caused_internally) {
        }

        @Override
        public void intParameterChanging(Parameter p, int toValue) {
        }

        @Override
        public void booleanParameterChanging(Parameter p, boolean toValue) {
        }

        @Override
        public void stringParameterChanging(Parameter p, String toValue) {
        }

        @Override
        public void floatParameterChanging(Parameter owner, double toValue) {
        }
    }

    static class RestoreDefaultsListener
    implements Listener {
        RestoreDefaultsListener() {
        }

        @Override
        public void handleEvent(Event event2) {
            ConfigurationDefaults configDefs = ConfigurationDefaults.getInstance();
            try {
                long downMax = configDefs.getLongParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit");
                String downConf = configDefs.getStringParameter("SpeedLimitMonitor.setting.download.limit.conf");
                long upMax = configDefs.getLongParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit");
                String upConf = configDefs.getStringParameter("SpeedLimitMonitor.setting.upload.limit.conf");
                COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", downMax);
                COConfigurationManager.setParameter("SpeedLimitMonitor.setting.download.limit.conf", downConf);
                COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", upMax);
                COConfigurationManager.setParameter("SpeedLimitMonitor.setting.upload.limit.conf", upConf);
            }
            catch (ConfigurationParameterNotFoundException configurationParameterNotFoundException) {
                // empty catch block
            }
        }
    }
}

