/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.FloatParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionTransferAutoSpeed
implements UISWTConfigSection {
    private static final String CFG_PREFIX = "ConfigView.section.transfer.autospeed.";

    @Override
    public String configSectionGetParentSection() {
        return "transfer.select";
    }

    @Override
    public String configSectionGetName() {
        return "transfer.autospeed";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
    }

    @Override
    public int maxUserMode() {
        return 2;
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData(gridData);
        GridLayout advanced_layout = new GridLayout();
        advanced_layout.numColumns = 2;
        cSection.setLayout(advanced_layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Label linfo = new Label(cSection, 64);
        Messages.setLanguageText(linfo, "ConfigView.section.transfer.autospeed.info");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        linfo.setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new LinkLabel(cSection, gridData, "ConfigView.label.please.visit.here", "http://wiki.vuze.com/w/Auto_Speed");
        String[] units = new String[]{DisplayFormatters.getRateUnit(1)};
        Label llmux = new Label(cSection, 0);
        Messages.setLanguageText((Widget)llmux, "ConfigView.section.transfer.autospeed.minupload", units);
        IntParameter min_upload = new IntParameter(cSection, "AutoSpeed Min Upload KBs");
        gridData = new GridData();
        min_upload.setLayoutData(gridData);
        Label llmdx = new Label(cSection, 0);
        Messages.setLanguageText((Widget)llmdx, "ConfigView.section.transfer.autospeed.maxupload", units);
        IntParameter max_upload = new IntParameter(cSection, "AutoSpeed Max Upload KBs");
        gridData = new GridData();
        max_upload.setLayoutData(gridData);
        if (userMode > 0) {
            BooleanParameter enable_down_adj = new BooleanParameter(cSection, "AutoSpeed Download Adj Enable", "ConfigView.section.transfer.autospeed.enabledownadj");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            enable_down_adj.setLayoutData(gridData);
            Label label = new Label(cSection, 0);
            Messages.setLanguageText(label, "ConfigView.section.transfer.autospeed.downadjratio");
            FloatParameter down_adj = new FloatParameter(cSection, "AutoSpeed Download Adj Ratio", 0.0f, Float.MAX_VALUE, false, 2);
            gridData = new GridData();
            down_adj.setLayoutData(gridData);
            enable_down_adj.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{down_adj.getControl()}));
        }
        if (userMode > 1) {
            Label label = new Label(cSection, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.transfer.autospeed.maxinc", units);
            final IntParameter max_increase = new IntParameter(cSection, "AutoSpeed Max Increment KBs");
            gridData = new GridData();
            max_increase.setLayoutData(gridData);
            label = new Label(cSection, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.transfer.autospeed.maxdec", units);
            final IntParameter max_decrease = new IntParameter(cSection, "AutoSpeed Max Decrement KBs");
            gridData = new GridData();
            max_decrease.setLayoutData(gridData);
            label = new Label(cSection, 0);
            Messages.setLanguageText(label, "ConfigView.section.transfer.autospeed.chokeping");
            final IntParameter choke_ping = new IntParameter(cSection, "AutoSpeed Choking Ping Millis");
            gridData = new GridData();
            choke_ping.setLayoutData(gridData);
            label = new Label(cSection, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.transfer.autospeed.forcemin", units);
            final IntParameter forced_min = new IntParameter(cSection, "AutoSpeed Forced Min KBs");
            gridData = new GridData();
            forced_min.setLayoutData(gridData);
            label = new Label(cSection, 0);
            Messages.setLanguageText(label, "ConfigView.section.transfer.autospeed.latencyfactor");
            final IntParameter latency_factor = new IntParameter(cSection, "AutoSpeed Latency Factor", 1, Integer.MAX_VALUE);
            gridData = new GridData();
            latency_factor.setLayoutData(gridData);
            Label reset_label = new Label(cSection, 0);
            Messages.setLanguageText(reset_label, "ConfigView.section.transfer.autospeed.reset");
            Button reset_button = new Button(cSection, 8);
            Messages.setLanguageText(reset_button, "ConfigView.section.transfer.autospeed.reset.button");
            reset_button.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    max_increase.resetToDefault();
                    max_decrease.resetToDefault();
                    choke_ping.resetToDefault();
                    latency_factor.resetToDefault();
                    forced_min.resetToDefault();
                }
            });
        }
        return cSection;
    }
}

