/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class ConfigSectionStats
implements UISWTConfigSection {
    private static final int defaultStatsPeriod = 30;
    private static final int[] statsPeriods = new int[]{1, 2, 3, 4, 5, 10, 15, 20, 25, 30, 40, 50, 60, 120, 180, 240, 300, 360, 420, 480, 540, 600, 900, 1200, 1800, 2400, 3000, 3600, 7200, 10800, 14400, 21600, 43200, 86400};

    @Override
    public String configSectionGetParentSection() {
        return "root";
    }

    @Override
    public String configSectionGetName() {
        return "stats";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.releaseImage("openFolderButton");
    }

    @Override
    public int maxUserMode() {
        return 0;
    }

    @Override
    public Composite configSectionCreate(final Composite parent) {
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image imgOpenFolder = imageLoader.getImage("openFolderButton");
        Composite gOutter = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        gOutter.setLayoutData(gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        gOutter.setLayout(layout);
        Group gGeneral = new Group(gOutter, 0);
        Messages.setLanguageText(gGeneral, "ConfigView.section.general");
        layout = new GridLayout(2, false);
        gGeneral.setLayout(layout);
        gGeneral.setLayoutData(new GridData(768));
        Label lSmooth = new Label(gGeneral, 0);
        Messages.setLanguageText(lSmooth, "stats.general.smooth_secs");
        IntParameter smooth_secs = new IntParameter(gGeneral, "Stats Smoothing Secs", 30, 1800);
        Group gDisplay = new Group(gOutter, 0);
        Messages.setLanguageText(gDisplay, "stats.display.group");
        layout = new GridLayout(1, false);
        gDisplay.setLayout(layout);
        gDisplay.setLayoutData(new GridData(768));
        gridData = new GridData();
        BooleanParameter graph_dividers = new BooleanParameter((Composite)gDisplay, "Stats Graph Dividers", "ConfigView.section.stats.graph_update_dividers");
        graph_dividers.setLayoutData(gridData);
        Group gSnap = new Group(gOutter, 0);
        Messages.setLanguageText(gSnap, "stats.snapshot.group");
        layout = new GridLayout(3, false);
        gSnap.setLayout(layout);
        gSnap.setLayoutData(new GridData(768));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        BooleanParameter enableStats = new BooleanParameter((Composite)gSnap, "Stats Enable", "ConfigView.section.stats.enable");
        enableStats.setLayoutData(gridData);
        Control[] controls = new Control[13];
        Label lStatsPath = new Label(gSnap, 0);
        Messages.setLanguageText(lStatsPath, "ConfigView.section.stats.defaultsavepath");
        gridData = new GridData();
        gridData.widthHint = 150;
        final StringParameter pathParameter = new StringParameter((Composite)gSnap, "Stats Dir", "");
        pathParameter.setLayoutData(gridData);
        controls[0] = lStatsPath;
        controls[1] = pathParameter.getControl();
        Button browse = new Button(gSnap, 8);
        browse.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(browse.getBackground());
        browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        controls[2] = browse;
        browse.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                dialog.setFilterPath(pathParameter.getValue());
                dialog.setText(MessageText.getString("ConfigView.section.stats.choosedefaultsavepath"));
                String path = dialog.open();
                if (path != null) {
                    pathParameter.setValue(path);
                }
            }
        });
        Label lSaveFile = new Label(gSnap, 0);
        Messages.setLanguageText(lSaveFile, "ConfigView.section.stats.savefile");
        controls[3] = lSaveFile;
        gridData = new GridData();
        gridData.widthHint = 150;
        StringParameter fileParameter = new StringParameter((Composite)gSnap, "Stats File", "Azureus_Stats.xml");
        fileParameter.setLayoutData(gridData);
        controls[4] = fileParameter.getControl();
        new Label(gSnap, 0);
        Label lxslFile = new Label(gSnap, 0);
        Messages.setLanguageText(lxslFile, "ConfigView.section.stats.xslfile");
        controls[5] = lxslFile;
        gridData = new GridData();
        gridData.widthHint = 150;
        StringParameter xslParameter = new StringParameter((Composite)gSnap, "Stats XSL File", "");
        xslParameter.setLayoutData(gridData);
        controls[6] = xslParameter.getControl();
        Label lxslDetails = new Label(gSnap, 0);
        Messages.setLanguageText(lxslDetails, "ConfigView.section.stats.xslfiledetails");
        String linkFAQ = "http://plugins.vuze.com/faq.php#20";
        lxslDetails.setCursor(lxslDetails.getDisplay().getSystemCursor(21));
        lxslDetails.setForeground(Colors.blue);
        lxslDetails.setData("http://plugins.vuze.com/faq.php#20");
        lxslDetails.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
                Utils.launch("http://plugins.vuze.com/faq.php#20");
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
                Utils.launch("http://plugins.vuze.com/faq.php#20");
            }
        });
        ClipboardCopy.addCopyToClipMenu(lxslDetails);
        controls[7] = lxslDetails;
        Label lSaveFreq = new Label(gSnap, 0);
        Messages.setLanguageText(lSaveFreq, "ConfigView.section.stats.savefreq");
        controls[8] = lSaveFreq;
        String[] spLabels = new String[statsPeriods.length];
        int[] spValues = new int[statsPeriods.length];
        for (int i = 0; i < statsPeriods.length; ++i) {
            int num = statsPeriods[i];
            spLabels[i] = num % 3600 == 0 ? " " + statsPeriods[i] / 3600 + " " + MessageText.getString("ConfigView.section.stats.hours") : (num % 60 == 0 ? " " + statsPeriods[i] / 60 + " " + MessageText.getString("ConfigView.section.stats.minutes") : " " + statsPeriods[i] + " " + MessageText.getString("ConfigView.section.stats.seconds"));
            spValues[i] = statsPeriods[i];
        }
        controls[9] = lSaveFreq;
        controls[10] = new IntListParameter(gSnap, "Stats Period", 30, spLabels, spValues).getControl();
        new Label(gSnap, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        BooleanParameter exportPeers = new BooleanParameter((Composite)gSnap, "Stats Export Peer Details", "ConfigView.section.stats.exportpeers");
        exportPeers.setLayoutData(gridData);
        controls[11] = exportPeers.getControl();
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        BooleanParameter exportFiles = new BooleanParameter((Composite)gSnap, "Stats Export File Details", "ConfigView.section.stats.exportfiles");
        exportFiles.setLayoutData(gridData);
        controls[12] = exportFiles.getControl();
        enableStats.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(controls));
        Group gXfer = new Group(gOutter, 0);
        Messages.setLanguageText(gXfer, "ConfigView.section.transfer");
        layout = new GridLayout(3, false);
        gXfer.setLayout(layout);
        gXfer.setLayoutData(new GridData(768));
        ArrayList<Button> buttons = new ArrayList<Button>();
        Label set_mark_label = new Label(gXfer, 0);
        Messages.setLanguageText(set_mark_label, "ConfigView.section.transfer.setmark");
        Button set_mark_button = new Button(gXfer, 8);
        buttons.add(set_mark_button);
        Messages.setLanguageText(set_mark_button, "Button.set");
        set_mark_button.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                OverallStats stats2 = StatsFactory.getStats();
                stats2.setMark();
            }
        });
        Button clear_mark_button = new Button(gXfer, 8);
        buttons.add(clear_mark_button);
        Messages.setLanguageText(clear_mark_button, "Button.clear");
        clear_mark_button.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                OverallStats stats2 = StatsFactory.getStats();
                stats2.clearMark();
            }
        });
        Group gLong = new Group(gOutter, 0);
        Messages.setLanguageText(gLong, "stats.longterm.group");
        layout = new GridLayout(2, false);
        gLong.setLayout(layout);
        gLong.setLayoutData(new GridData(768));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        BooleanParameter enableLongStats = new BooleanParameter((Composite)gLong, "long.term.stats.enable", "ConfigView.section.stats.enable");
        enableLongStats.setLayoutData(gridData);
        Label lWeekStart = new Label(gLong, 0);
        Messages.setLanguageText(lWeekStart, "stats.long.weekstart");
        String[] wsLabels = new String[7];
        int[] wsValues = new int[7];
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat format = new SimpleDateFormat("E");
        for (int i = 0; i < 7; ++i) {
            int dow = i + 1;
            cal.set(7, dow);
            wsLabels[i] = format.format(cal.getTime());
            wsValues[i] = i + 1;
        }
        IntListParameter week_start = new IntListParameter(gLong, "long.term.stats.weekstart", 1, wsLabels, wsValues);
        Label lMonthStart = new Label(gLong, 0);
        Messages.setLanguageText(lMonthStart, "stats.long.monthstart");
        IntParameter month_start = new IntParameter(gLong, "long.term.stats.monthstart", 1, 28);
        enableLongStats.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{lWeekStart, lMonthStart}));
        enableLongStats.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(week_start, month_start));
        Label lt_reset_label = new Label(gLong, 0);
        Messages.setLanguageText(lt_reset_label, "ConfigView.section.transfer.lts.reset");
        Button lt_reset_button = new Button(gLong, 8);
        buttons.add(lt_reset_button);
        Messages.setLanguageText(lt_reset_button, "Button.clear");
        lt_reset_button.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                MessageBoxShell mb = new MessageBoxShell(296, MessageText.getString("ConfigView.section.security.resetcerts.warning.title"), MessageText.getString("ConfigView.section.transfer.ltsreset.warning.msg"));
                mb.setDefaultButtonUsingStyle(256);
                mb.setParent(parent.getShell());
                mb.open(new UserPrompterResultListener(){

                    @Override
                    public void prompterClosed(int returnVal) {
                        if (returnVal != 32) {
                            return;
                        }
                        Utils.getOffOfSWTThread(new AERunnable(){

                            @Override
                            public void runSupport() {
                                StatsFactory.clearLongTermStats();
                            }
                        });
                    }
                });
            }
        });
        Utils.makeButtonsEqualWidth(buttons);
        return gOutter;
    }
}

