/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.PluginConfigModel;
import org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.BooleanParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.DualChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.plugins.PluginParameter;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.views.ConfigView;

public class ConfigSectionPlugins
implements UISWTConfigSection,
ParameterListener {
    private static final String HEADER_PREFIX = "ConfigView.pluginlist.column.";
    private static final String[] COLUMN_HEADERS = new String[]{"loadAtStartup", "type", "name", "version", "directory", "unloadable"};
    private static final int[] COLUMN_SIZES = new int[]{180, 70, 250, 100, 100, 50};
    private static final int[] COLUMN_ALIGNS = new int[]{0x1000000, 16384, 16384, 131072, 16384, 0x1000000};
    private ConfigView configView;
    FilterComparator comparator;
    List pluginIFs;
    private Table table;
    private Image imgRedLed;
    private Image imgGreenLed;

    public ConfigSectionPlugins(ConfigView _configView) {
        this.configView = _configView;
        this.comparator = new FilterComparator();
    }

    @Override
    public String configSectionGetParentSection() {
        return "root";
    }

    @Override
    public String configSectionGetName() {
        return "plugins";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public int maxUserMode() {
        return 0;
    }

    @Override
    public void configSectionDelete() {
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.releaseImage("redled");
        imageLoader.releaseImage("greenled");
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        String sAppPluginDir;
        String sUserPluginDir;
        if (!AzureusCoreFactory.isCoreRunning()) {
            Composite cSection = new Composite(parent, 0);
            cSection.setLayout(new FillLayout());
            Label lblNotAvail = new Label(cSection, 64);
            Messages.setLanguageText(lblNotAvail, "core.not.available");
            return cSection;
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.imgRedLed = imageLoader.getImage("redled");
        this.imgGreenLed = imageLoader.getImage("greenled");
        Composite infoGroup = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        Utils.setLayoutData((Control)infoGroup, gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        infoGroup.setLayout(layout);
        infoGroup.setLayout(new GridLayout());
        String sep = System.getProperty("file.separator");
        File fUserPluginDir = FileUtil.getUserFile("plugins");
        try {
            sUserPluginDir = fUserPluginDir.getCanonicalPath();
        }
        catch (Throwable e) {
            sUserPluginDir = fUserPluginDir.toString();
        }
        if (!sUserPluginDir.endsWith(sep)) {
            sUserPluginDir = sUserPluginDir + sep;
        }
        File fAppPluginDir = FileUtil.getApplicationFile("plugins");
        try {
            sAppPluginDir = fAppPluginDir.getCanonicalPath();
        }
        catch (Throwable e) {
            sAppPluginDir = fAppPluginDir.toString();
        }
        if (!sAppPluginDir.endsWith(sep)) {
            sAppPluginDir = sAppPluginDir + sep;
        }
        Label label = new Label(infoGroup, 64);
        Utils.setLayoutData((Control)label, new GridData(768));
        Messages.setLanguageText(label, "ConfigView.pluginlist.whereToPut");
        label = new Label(infoGroup, 64);
        gridData = new GridData(768);
        gridData.horizontalIndent = 10;
        Utils.setLayoutData((Control)label, gridData);
        label.setText(sUserPluginDir.replaceAll("&", "&&"));
        label.setForeground(Colors.blue);
        label.setCursor(label.getDisplay().getSystemCursor(21));
        final String _sUserPluginDir = sUserPluginDir;
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                if (_sUserPluginDir.endsWith("/plugins/") || _sUserPluginDir.endsWith("\\plugins\\")) {
                    File f = new File(_sUserPluginDir);
                    String dir = _sUserPluginDir;
                    if (!f.exists() || !f.isDirectory()) {
                        dir = _sUserPluginDir.substring(0, _sUserPluginDir.length() - 9);
                    }
                    Utils.launch(dir);
                }
            }
        });
        label = new Label(infoGroup, 64);
        Utils.setLayoutData((Control)label, new GridData(768));
        Messages.setLanguageText(label, "ConfigView.pluginlist.whereToPutOr");
        label = new Label(infoGroup, 64);
        gridData = new GridData(768);
        gridData.horizontalIndent = 10;
        Utils.setLayoutData((Control)label, gridData);
        label.setText(sAppPluginDir.replaceAll("&", "&&"));
        label.setForeground(Colors.blue);
        label.setCursor(label.getDisplay().getSystemCursor(21));
        final String _sAppPluginDir = sAppPluginDir;
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                if (_sAppPluginDir.endsWith("/plugins/") || _sAppPluginDir.endsWith("\\plugins\\")) {
                    File f = new File(_sAppPluginDir);
                    if (f.exists() && f.isDirectory()) {
                        Utils.launch(_sAppPluginDir);
                    } else {
                        String azureusDir = _sAppPluginDir.substring(0, _sAppPluginDir.length() - 9);
                        System.out.println(azureusDir);
                        Utils.launch(azureusDir);
                    }
                }
            }
        });
        this.pluginIFs = this.rebuildPluginIFs();
        Collections.sort(this.pluginIFs, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((PluginInterface)o1).getPluginName().compareToIgnoreCase(((PluginInterface)o2).getPluginName());
            }
        });
        Label labelInfo = new Label(infoGroup, 64);
        Utils.setLayoutData((Control)labelInfo, new GridData(768));
        Messages.setLanguageText(labelInfo, "ConfigView.pluginlist.info");
        this.table = new Table(infoGroup, 268503076);
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.widthHint = 200;
        Utils.setLayoutData((Control)this.table, gridData);
        for (int i = 0; i < COLUMN_HEADERS.length; ++i) {
            final TableColumn tc = new TableColumn(this.table, COLUMN_ALIGNS[i]);
            tc.setWidth(Utils.adjustPXForDPI(COLUMN_SIZES[i]));
            tc.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    boolean ascending = ConfigSectionPlugins.this.comparator.setField(ConfigSectionPlugins.this.table.indexOf(tc));
                    try {
                        ConfigSectionPlugins.this.table.setSortColumn(tc);
                        ConfigSectionPlugins.this.table.setSortDirection(ascending ? 128 : 1024);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    Collections.sort(ConfigSectionPlugins.this.pluginIFs, ConfigSectionPlugins.this.comparator);
                    ConfigSectionPlugins.this.table.clearAll();
                }
            });
            Messages.setLanguageText(tc, HEADER_PREFIX + COLUMN_HEADERS[i]);
        }
        this.table.setHeaderVisible(true);
        Composite cButtons = new Composite(infoGroup, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 5;
        cButtons.setLayout(layout);
        Utils.setLayoutData((Control)cButtons, new GridData());
        final Button btnUnload = new Button(cButtons, 8);
        Utils.setLayoutData((Control)btnUnload, new GridData());
        Messages.setLanguageText(btnUnload, "ConfigView.pluginlist.unloadSelected");
        btnUnload.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                final int[] items = ConfigSectionPlugins.this.table.getSelectionIndices();
                new AEThread2("unload"){

                    @Override
                    public void run() {
                        for (int i = 0; i < items.length; ++i) {
                            int index = items[i];
                            if (index < 0 || index >= ConfigSectionPlugins.this.pluginIFs.size()) continue;
                            PluginInterface pluginIF = (PluginInterface)ConfigSectionPlugins.this.pluginIFs.get(index);
                            if (pluginIF.getPluginState().isOperational() && pluginIF.getPluginState().isUnloadable()) {
                                try {
                                    pluginIF.getPluginState().unload();
                                }
                                catch (PluginException e1) {
                                    e1.printStackTrace();
                                }
                            }
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    ConfigSectionPlugins.this.pluginIFs = ConfigSectionPlugins.this.rebuildPluginIFs();
                                    ConfigSectionPlugins.this.table.setItemCount(ConfigSectionPlugins.this.pluginIFs.size());
                                    Collections.sort(ConfigSectionPlugins.this.pluginIFs, ConfigSectionPlugins.this.comparator);
                                    ConfigSectionPlugins.this.table.clearAll();
                                }
                            });
                        }
                    }
                }.start();
            }
        });
        btnUnload.setEnabled(false);
        final Button btnLoad = new Button(cButtons, 8);
        Utils.setLayoutData((Control)btnUnload, new GridData());
        Messages.setLanguageText(btnLoad, "ConfigView.pluginlist.loadSelected");
        btnLoad.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                final int[] items = ConfigSectionPlugins.this.table.getSelectionIndices();
                new AEThread2("load"){

                    @Override
                    public void run() {
                        for (int i = 0; i < items.length; ++i) {
                            PluginInterface pluginIF;
                            int index = items[i];
                            if (index < 0 || index >= ConfigSectionPlugins.this.pluginIFs.size() || (pluginIF = (PluginInterface)ConfigSectionPlugins.this.pluginIFs.get(index)).getPluginState().isOperational()) continue;
                            if (pluginIF.getPluginState().isDisabled()) {
                                if (pluginIF.getPluginState().hasFailed()) continue;
                                pluginIF.getPluginState().setDisabled(false);
                            }
                            try {
                                pluginIF.getPluginState().reload();
                            }
                            catch (PluginException e1) {
                                Debug.printStackTrace(e1);
                            }
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (ConfigSectionPlugins.this.table == null || ConfigSectionPlugins.this.table.isDisposed()) {
                                        return;
                                    }
                                    ConfigSectionPlugins.this.pluginIFs = ConfigSectionPlugins.this.rebuildPluginIFs();
                                    ConfigSectionPlugins.this.table.setItemCount(ConfigSectionPlugins.this.pluginIFs.size());
                                    Collections.sort(ConfigSectionPlugins.this.pluginIFs, ConfigSectionPlugins.this.comparator);
                                    ConfigSectionPlugins.this.table.clearAll();
                                }
                            });
                        }
                    }
                }.start();
            }
        });
        btnLoad.setEnabled(false);
        Button btnScan = new Button(cButtons, 8);
        Utils.setLayoutData((Control)btnScan, new GridData());
        Messages.setLanguageText(btnScan, "ConfigView.pluginlist.scan");
        btnScan.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                AzureusCoreFactory.getSingleton().getPluginManager().refreshPluginList(false);
                ConfigSectionPlugins.this.pluginIFs = ConfigSectionPlugins.this.rebuildPluginIFs();
                ConfigSectionPlugins.this.table.setItemCount(ConfigSectionPlugins.this.pluginIFs.size());
                Collections.sort(ConfigSectionPlugins.this.pluginIFs, ConfigSectionPlugins.this.comparator);
                ConfigSectionPlugins.this.table.clearAll();
            }
        });
        final Button btnUninstall = new Button(cButtons, 8);
        Utils.setLayoutData((Control)btnUninstall, new GridData());
        Messages.setLanguageText(btnUninstall, "ConfigView.pluginlist.uninstallSelected");
        btnUninstall.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                btnUninstall.setEnabled(false);
                final int[] items = ConfigSectionPlugins.this.table.getSelectionIndices();
                new AEThread2("uninstall"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block5: {
                            try {
                                ArrayList<PluginInterface> pis = new ArrayList<PluginInterface>();
                                for (int i = 0; i < items.length; ++i) {
                                    int index = items[i];
                                    if (index < 0 || index >= ConfigSectionPlugins.this.pluginIFs.size()) continue;
                                    PluginInterface pluginIF = (PluginInterface)ConfigSectionPlugins.this.pluginIFs.get(index);
                                    pis.add(pluginIF);
                                }
                                if (pis.size() <= 0) break block5;
                                PluginInterface[] ps = new PluginInterface[pis.size()];
                                pis.toArray(ps);
                                try {
                                    final AESemaphore wait_sem = new AESemaphore("unist:wait");
                                    ps[0].getPluginManager().getPluginInstaller().uninstall(ps, new PluginInstallationListener(){

                                        @Override
                                        public void completed() {
                                            wait_sem.release();
                                        }

                                        @Override
                                        public void cancelled() {
                                            wait_sem.release();
                                        }

                                        @Override
                                        public void failed(PluginException e) {
                                            wait_sem.release();
                                        }
                                    });
                                    wait_sem.reserve();
                                }
                                catch (Exception e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                            catch (Throwable throwable) {
                                Utils.execSWTThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ConfigSectionPlugins.this.pluginIFs = ConfigSectionPlugins.this.rebuildPluginIFs();
                                        ConfigSectionPlugins.this.table.setItemCount(ConfigSectionPlugins.this.pluginIFs.size());
                                        Collections.sort(ConfigSectionPlugins.this.pluginIFs, ConfigSectionPlugins.this.comparator);
                                        ConfigSectionPlugins.this.table.clearAll();
                                        ConfigSectionPlugins.this.table.setSelection(new int[0]);
                                    }
                                });
                                throw throwable;
                            }
                        }
                        Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                    }
                }.start();
            }
        });
        btnUninstall.setEnabled(false);
        Button btnInstall = new Button(cButtons, 8);
        Utils.setLayoutData((Control)btnInstall, new GridData());
        btnInstall.setText(MessageText.getString("UpdateWindow.columns.install") + "...");
        btnInstall.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                new InstallPluginWizard();
            }
        });
        this.table.addListener(36, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                TableItem item = (TableItem)event2.item;
                int index = ConfigSectionPlugins.this.table.indexOf(item);
                PluginInterface pluginIF = (PluginInterface)ConfigSectionPlugins.this.pluginIFs.get(index);
                for (int i = 0; i < COLUMN_HEADERS.length; ++i) {
                    String sText;
                    if (i == 2) {
                        item.setImage(i, pluginIF.getPluginState().isOperational() ? ConfigSectionPlugins.this.imgGreenLed : ConfigSectionPlugins.this.imgRedLed);
                    }
                    if ((sText = ConfigSectionPlugins.this.comparator.getFieldValue(i, pluginIF)) == null) {
                        sText = "";
                    }
                    item.setText(i, sText);
                }
                item.setGrayed(pluginIF.getPluginState().isMandatory());
                boolean bEnabled = pluginIF.getPluginState().isLoadedAtStartup();
                Utils.setCheckedInSetData(item, bEnabled);
                item.setData("PluginID", pluginIF.getPluginID());
                Utils.alternateRowBackground(item);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] items = ConfigSectionPlugins.this.table.getSelection();
                if (items.length == 1) {
                    PluginConfigModel[] models;
                    int index = ConfigSectionPlugins.this.table.indexOf(items[0]);
                    PluginInterface pluginIF = (PluginInterface)ConfigSectionPlugins.this.pluginIFs.get(index);
                    for (PluginConfigModel model : models = pluginIF.getUIManager().getPluginConfigModels()) {
                        if (model.getPluginInterface() != pluginIF || !(model instanceof BasicPluginConfigModel)) continue;
                        String id = ((BasicPluginConfigModel)model).getSection();
                        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                        if (uiFunctions == null) continue;
                        uiFunctions.getMDI().showEntryByID("ConfigView", id);
                    }
                }
            }
        });
        this.table.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                int index = ConfigSectionPlugins.this.table.indexOf(item);
                PluginInterface pluginIF = (PluginInterface)ConfigSectionPlugins.this.pluginIFs.get(index);
                if (e.detail == 32) {
                    if (item.getGrayed()) {
                        if (!item.getChecked()) {
                            item.setChecked(true);
                        }
                        return;
                    }
                    pluginIF.getPluginState().setDisabled(!item.getChecked());
                    pluginIF.getPluginState().setLoadedAtStartup(item.getChecked());
                }
                btnUnload.setEnabled(pluginIF.getPluginState().isOperational() && pluginIF.getPluginState().isUnloadable());
                btnLoad.setEnabled(!pluginIF.getPluginState().isOperational() && !pluginIF.getPluginState().hasFailed());
                btnUninstall.setEnabled(!pluginIF.getPluginState().isBuiltIn() && !pluginIF.getPluginState().isMandatory());
            }
        });
        this.table.setItemCount(this.pluginIFs.size());
        return infoGroup;
    }

    private List rebuildPluginIFs() {
        List<PluginInterface> pluginIFs = Arrays.asList(AzureusCoreFactory.getSingleton().getPluginManager().getPlugins());
        for (PluginInterface pi : pluginIFs) {
            COConfigurationManager.addParameterListener("PluginInfo." + pi.getPluginID() + ".enabled", (ParameterListener)this);
        }
        return pluginIFs;
    }

    @Override
    public void parameterChanged(String parameterName) {
        if (this.table != null) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (ConfigSectionPlugins.this.table != null && !ConfigSectionPlugins.this.table.isDisposed()) {
                        ConfigSectionPlugins.this.table.clearAll();
                    }
                }
            });
        }
    }

    public void initPluginSubSections() {
        TreeItem treePlugins = this.configView.findTreeItem("plugins");
        ParameterRepository repository = ParameterRepository.getInstance();
        Object[] names = repository.getNames();
        Arrays.sort(names);
        for (int i = 0; i < names.length; ++i) {
            Parameter parameter;
            int j;
            Object pluginName = names[i];
            Parameter[] parameters = repository.getParameterBlock((String)pluginName);
            boolean bUsePrefix = MessageText.keyExists("ConfigView.section.plugins." + (String)pluginName);
            Composite pluginGroup = this.configView.createConfigSection(treePlugins, (String)pluginName, -2, bUsePrefix);
            GridLayout pluginLayout = new GridLayout();
            pluginLayout.numColumns = 3;
            pluginGroup.setLayout(pluginLayout);
            HashMap<Parameter, PluginParameter> parameterToPluginParameter = new HashMap<Parameter, PluginParameter>();
            for (j = 0; j < parameters.length; ++j) {
                parameter = parameters[j];
                parameterToPluginParameter.put(parameter, new PluginParameter(pluginGroup, parameter));
            }
            for (j = 0; j < parameters.length; ++j) {
                Control[] cd;
                parameter = parameters[j];
                if (!(parameter instanceof BooleanParameterImpl)) continue;
                List parametersToEnable = ((BooleanParameterImpl)parameter).getEnabledOnSelectionParameters();
                ArrayList controlsToEnable = new ArrayList();
                for (Parameter parameterToEnable : parametersToEnable) {
                    PluginParameter pp = (PluginParameter)parameterToPluginParameter.get(parameterToEnable);
                    Control[] controls = pp.getControls();
                    Collections.addAll(controlsToEnable, controls);
                }
                List parametersToDisable = ((BooleanParameterImpl)parameter).getDisabledOnSelectionParameters();
                ArrayList controlsToDisable = new ArrayList();
                for (Parameter parameterToDisable : parametersToDisable) {
                    PluginParameter pp = (PluginParameter)parameterToPluginParameter.get(parameterToDisable);
                    Control[] controls = pp.getControls();
                    Collections.addAll(controlsToDisable, controls);
                }
                Control[] ce = new Control[controlsToEnable.size()];
                if (ce.length + (cd = new Control[controlsToDisable.size()]).length <= 0) continue;
                DualChangeSelectionActionPerformer ap = new DualChangeSelectionActionPerformer(controlsToEnable.toArray(ce), controlsToDisable.toArray(cd));
                PluginParameter pp = (PluginParameter)parameterToPluginParameter.get(parameter);
                pp.setAdditionalActionPerfomer(ap);
            }
        }
    }

    static class FilterComparator
    implements Comparator {
        boolean ascending = true;
        static final int FIELD_LOAD = 0;
        static final int FIELD_TYPE = 1;
        static final int FIELD_NAME = 2;
        static final int FIELD_VERSION = 3;
        static final int FIELD_DIRECTORY = 4;
        static final int FIELD_UNLOADABLE = 5;
        int field = 2;
        String sUserPluginDir;
        String sAppPluginDir;

        public FilterComparator() {
            String sep = System.getProperty("file.separator");
            this.sUserPluginDir = FileUtil.getUserFile("plugins").toString();
            if (!this.sUserPluginDir.endsWith(sep)) {
                this.sUserPluginDir = this.sUserPluginDir + sep;
            }
            this.sAppPluginDir = FileUtil.getApplicationFile("plugins").toString();
            if (!this.sAppPluginDir.endsWith(sep)) {
                this.sAppPluginDir = this.sAppPluginDir + sep;
            }
        }

        public int compare(Object arg0, Object arg1) {
            PluginInterface if0 = (PluginInterface)arg0;
            PluginInterfaceImpl if1 = (PluginInterfaceImpl)arg1;
            int result = 0;
            switch (this.field) {
                case 0: {
                    boolean b0 = if0.getPluginState().isLoadedAtStartup();
                    boolean b1 = if1.getPluginState().isLoadedAtStartup();
                    int n = b0 == b1 ? 0 : (result = b0 ? -1 : 1);
                    if (result != 0) break;
                    result = if0.getPluginID().compareToIgnoreCase(if1.getPluginID());
                    break;
                }
                case 1: 
                case 4: {
                    result = this.getFieldValue(this.field, if0).compareToIgnoreCase(this.getFieldValue(this.field, if1));
                    break;
                }
                case 3: {
                    String s0 = if0.getPluginVersion();
                    String s1 = if1.getPluginVersion();
                    if (s0 == null) {
                        s0 = "";
                    }
                    if (s1 == null) {
                        s1 = "";
                    }
                    result = s0.compareToIgnoreCase(s1);
                    break;
                }
                case 5: {
                    boolean b0 = if0.getPluginState().isUnloadable();
                    boolean b1 = if1.getPluginState().isUnloadable();
                    result = b0 == b1 ? 0 : (b0 ? -1 : 1);
                    break;
                }
            }
            if (result == 0) {
                result = if0.getPluginName().compareToIgnoreCase(if1.getPluginName());
            }
            if (!this.ascending) {
                result *= -1;
            }
            return result;
        }

        public boolean setField(int newField) {
            this.ascending = this.field == newField ? !this.ascending : true;
            this.field = newField;
            return this.ascending;
        }

        public String getFieldValue(int iField, PluginInterface pluginIF) {
            switch (iField) {
                case 0: {
                    return pluginIF.getPluginID();
                }
                case 4: {
                    String sDirName = pluginIF.getPluginDirectoryName();
                    if (sDirName.length() > this.sUserPluginDir.length() && sDirName.substring(0, this.sUserPluginDir.length()).equals(this.sUserPluginDir)) {
                        return sDirName.substring(this.sUserPluginDir.length());
                    }
                    if (sDirName.length() > this.sAppPluginDir.length() && sDirName.substring(0, this.sAppPluginDir.length()).equals(this.sAppPluginDir)) {
                        return sDirName.substring(this.sAppPluginDir.length());
                    }
                    return sDirName;
                }
                case 2: {
                    return pluginIF.getPluginName();
                }
                case 1: {
                    String sDirName = pluginIF.getPluginDirectoryName();
                    String sKey = sDirName.length() > this.sUserPluginDir.length() && sDirName.substring(0, this.sUserPluginDir.length()).equals(this.sUserPluginDir) ? "perUser" : (sDirName.length() > this.sAppPluginDir.length() && sDirName.substring(0, this.sAppPluginDir.length()).equals(this.sAppPluginDir) ? "shared" : "builtIn");
                    return MessageText.getString("ConfigView.pluginlist.column.type." + sKey);
                }
                case 3: {
                    return pluginIF.getPluginVersion();
                }
                case 5: {
                    return MessageText.getString("Button." + (pluginIF.getPluginState().isUnloadable() ? "yes" : "no")).replaceAll("&", "");
                }
            }
            return "";
        }
    }
}

