/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.FileParameter;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionInterfaceTables
implements UISWTConfigSection {
    private static final String MSG_PREFIX = "ConfigView.section.style.";

    @Override
    public String configSectionGetParentSection() {
        return "style";
    }

    @Override
    public String configSectionGetName() {
        return "tables";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
    }

    @Override
    public int maxUserMode() {
        return 2;
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        GridData gridData;
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean isAZ3 = COConfigurationManager.getStringParameter("ui").equals("az3");
        Composite cSection = new Composite(parent, 0);
        Utils.setLayoutData((Control)cSection, new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        cSection.setLayout(layout);
        Group cGeneral = new Group(cSection, 0);
        Messages.setLanguageText(cGeneral, "ConfigView.section.global");
        layout = new GridLayout();
        layout.numColumns = 2;
        cGeneral.setLayout(layout);
        Utils.setLayoutData((Control)cGeneral, new GridData(768));
        Label label = new Label(cGeneral, 0);
        Messages.setLanguageText(label, "ConfigView.section.style.defaultSortOrder");
        int[] sortOrderValues = new int[]{0, 1, 2};
        String[] sortOrderLabels = new String[]{MessageText.getString("ConfigView.section.style.defaultSortOrder.asc"), MessageText.getString("ConfigView.section.style.defaultSortOrder.desc"), MessageText.getString("ConfigView.section.style.defaultSortOrder.flip")};
        new IntListParameter(cGeneral, "config.style.table.defaultSortOrder", sortOrderLabels, sortOrderValues);
        if (userMode > 0) {
            label = new Label(cGeneral, 0);
            Messages.setLanguageText(label, "ConfigView.section.style.guiUpdate");
            int[] values = new int[]{10, 25, 50, 100, 250, 500, 1000, 2000, 5000, 10000, 15000};
            String[] labels = new String[]{"10 ms", "25 ms", "50 ms", "100 ms", "250 ms", "500 ms", "1 s", "2 s", "5 s", "10 s", "15 s"};
            new IntListParameter(cGeneral, "GUI Refresh", 1000, labels, values);
            label = new Label(cGeneral, 0);
            Messages.setLanguageText(label, "ConfigView.section.style.graphicsUpdate");
            gridData = new GridData();
            IntParameter graphicUpdate = new IntParameter(cGeneral, "Graphics Update", 1, Integer.MAX_VALUE);
            graphicUpdate.setLayoutData(gridData);
            label = new Label(cGeneral, 0);
            Messages.setLanguageText(label, "ConfigView.section.style.reOrderDelay");
            gridData = new GridData();
            IntParameter reorderDelay = new IntParameter(cGeneral, "ReOrder Delay");
            reorderDelay.setLayoutData(gridData);
            new BooleanParameter((Composite)cGeneral, "NameColumn.showProgramIcon", "ConfigView.section.style.showProgramIcon").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
            new BooleanParameter((Composite)cGeneral, "Table.extendedErase", "ConfigView.section.style.extendedErase").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
            boolean hhEnabled = COConfigurationManager.getIntParameter("Table.headerHeight") > 0;
            Button chkHeaderHeight = new Button(cGeneral, 32);
            Messages.setLanguageText(chkHeaderHeight, "ConfigView.section.style.enableHeaderHeight");
            chkHeaderHeight.setSelection(hhEnabled);
            final IntParameter paramHH = new IntParameter(cGeneral, "Table.headerHeight", 0, 100);
            paramHH.setEnabled(hhEnabled);
            chkHeaderHeight.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        COConfigurationManager.setParameter("Table.headerHeight", 16);
                        paramHH.setEnabled(true);
                    } else {
                        COConfigurationManager.setParameter("Table.headerHeight", 0);
                        paramHH.setEnabled(false);
                    }
                }

                @Override
                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            boolean cdEnabled = COConfigurationManager.getStringParameter("Table.column.dateformat", "").length() > 0;
            Button chkCustomDate = new Button(cGeneral, 32);
            Messages.setLanguageText(chkCustomDate, "ConfigView.section.style.customDateFormat");
            chkCustomDate.setSelection(cdEnabled);
            final StringParameter paramCustomDate = new StringParameter((Composite)cGeneral, "Table.column.dateformat", "");
            paramCustomDate.setLayoutData(new GridData(4, 4, true, false));
            paramCustomDate.setEnabled(cdEnabled);
            paramCustomDate.addChangeListener(new ParameterChangeAdapter(){

                @Override
                public void parameterChanged(Parameter p, boolean caused_internally) {
                    String s = (String)p.getValueObject();
                    boolean ok = false;
                    try {
                        SimpleDateFormat temp = new SimpleDateFormat(s);
                        temp.format(new Date());
                        ok = true;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    p.getControl().setBackground(ok ? null : Colors.colorErrorBG);
                }
            });
            chkCustomDate.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        COConfigurationManager.setParameter("Table.column.dateformat", "yyyy/MM/dd");
                        paramCustomDate.setEnabled(true);
                    } else {
                        COConfigurationManager.setParameter("Table.column.dateformat", "");
                        paramCustomDate.setEnabled(false);
                    }
                }

                @Override
                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        Group cLibrary = new Group(cSection, 0);
        Messages.setLanguageText(cLibrary, "ConfigView.section.style.library");
        layout = new GridLayout();
        layout.numColumns = 2;
        cLibrary.setLayout(layout);
        Utils.setLayoutData((Control)cLibrary, new GridData(768));
        new BooleanParameter((Composite)cLibrary, "Table.useTree", "ConfigView.section.style.useTree").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        if (userMode > 1) {
            new BooleanParameter((Composite)cLibrary, "DND Always In Incomplete", "ConfigView.section.style.DNDalwaysInIncomplete").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        }
        if (isAZ3) {
            new BooleanParameter((Composite)cLibrary, "Library.EnableSimpleView", "ConfigView.section.style.EnableSimpleView").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
            new BooleanParameter((Composite)cLibrary, "Library.CatInSideBar", "ConfigView.section.style.CatInSidebar").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        }
        new BooleanParameter((Composite)cLibrary, "Library.ShowCatButtons", "ConfigView.section.style.ShowCatButtons").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        if (isAZ3) {
            new BooleanParameter((Composite)cLibrary, "Library.TagInSideBar", "ConfigView.section.style.TagInSidebar").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        }
        BooleanParameter show_tag = new BooleanParameter((Composite)cLibrary, "Library.ShowTagButtons", "ConfigView.section.style.ShowTagButtons");
        show_tag.setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        BooleanParameter show_tag_comp_only = new BooleanParameter((Composite)cLibrary, "Library.ShowTagButtons.CompOnly", "ConfigView.section.style.ShowTagButtons.CompOnly");
        gridData = new GridData(4, 16384, true, false, 2, 1);
        gridData.horizontalIndent = 25;
        show_tag_comp_only.setLayoutData(gridData);
        show_tag.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(show_tag_comp_only));
        if (isAZ3) {
            new BooleanParameter((Composite)cLibrary, "Library.ShowTabsInTorrentView", "ConfigView.section.style.ShowTabsInTorrentView").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        }
        new BooleanParameter(cLibrary, "Library.showFancyMenu", true, "ConfigView.section.style.ShowFancyMenu").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        label = new Label(cLibrary, 0);
        Messages.setLanguageText(label, "ConfigView.label.dm.dblclick");
        String[] dblclickOptions = new String[]{"ConfigView.option.dm.dblclick.play", "ConfigView.option.dm.dblclick.details", "ConfigView.option.dm.dblclick.show", "ConfigView.option.dm.dblclick.launch", "ConfigView.option.dm.dblclick.launch.qv", "ConfigView.option.dm.dblclick.open.browser"};
        String[] dblclickLabels = new String[dblclickOptions.length];
        String[] dblclickValues = new String[dblclickOptions.length];
        for (int i = 0; i < dblclickOptions.length; ++i) {
            dblclickLabels[i] = MessageText.getString(dblclickOptions[i]);
            dblclickValues[i] = "" + i;
        }
        new StringListParameter(cLibrary, "list.dm.dblclick", dblclickLabels, dblclickValues);
        Composite cLaunchWeb = new Composite(cLibrary, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        cLaunchWeb.setLayout(layout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 25;
        Utils.setLayoutData((Control)cLaunchWeb, gridData);
        BooleanParameter web_in_browser = new BooleanParameter(cLaunchWeb, "Library.LaunchWebsiteInBrowser", "library.launch.web.in.browser");
        BooleanParameter web_in_browser_anon = new BooleanParameter(cLaunchWeb, "Library.LaunchWebsiteInBrowserAnon", "library.launch.web.in.browser.anon");
        web_in_browser.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(web_in_browser_anon));
        Group cLaunch = new Group(cLibrary, 0);
        Messages.setLanguageText(cLaunch, "ConfigView.section.style.launch");
        layout = new GridLayout();
        layout.numColumns = 5;
        cLaunch.setLayout(layout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        Utils.setLayoutData((Control)cLaunch, gridData);
        Label info_label = new Label(cLaunch, 64);
        Messages.setLanguageText(info_label, "ConfigView.label.lh.info");
        gridData = Utils.getWrappableLabelGridData(5, 256);
        Utils.setLayoutData((Control)info_label, gridData);
        for (int i = 0; i < 4; ++i) {
            label = new Label(cLaunch, 0);
            Messages.setLanguageText(label, "ConfigView.label.lh.ext");
            StringParameter exts = new StringParameter((Composite)cLaunch, "Table.lh" + i + ".exts", "");
            gridData = new GridData();
            gridData.widthHint = 200;
            exts.setLayoutData(gridData);
            label = new Label(cLaunch, 0);
            Messages.setLanguageText(label, "ConfigView.label.lh.prog");
            final FileParameter prog = new FileParameter(cLaunch, "Table.lh" + i + ".prog", "", new String[0]);
            gridData = new GridData();
            gridData.widthHint = 400;
            prog.getControls()[0].setLayoutData(gridData);
            if (!Constants.isOSX) continue;
            COConfigurationManager.addParameterListener("Table.lh" + i + ".prog", new ParameterListener(){
                private boolean changing = false;
                private String last_changed = "";

                @Override
                public void parameterChanged(String parameter_name) {
                    if (prog.isDisposed()) {
                        COConfigurationManager.removeParameterListener(parameter_name, this);
                    } else {
                        if (this.changing) {
                            return;
                        }
                        final String value = COConfigurationManager.getStringParameter(parameter_name);
                        if (value.equals(this.last_changed)) {
                            return;
                        }
                        if (value.endsWith(".app")) {
                            Utils.execSWTThreadLater(1, new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    last_changed = value;
                                    try {
                                        changing = true;
                                        File file = new File(value);
                                        String app_name = file.getName();
                                        int pos = app_name.lastIndexOf(".");
                                        app_name = app_name.substring(0, pos);
                                        String new_value = value + "/Contents/MacOS/" + app_name;
                                        if (new File(new_value).exists()) {
                                            prog.setValue(new_value);
                                        }
                                    }
                                    finally {
                                        changing = false;
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }
        Group cSeachSubs = new Group(cSection, 0);
        Messages.setLanguageText(cSeachSubs, "ConfigView.section.style.searchsubs");
        layout = new GridLayout();
        layout.numColumns = 2;
        cSeachSubs.setLayout(layout);
        Utils.setLayoutData((Control)cSeachSubs, new GridData(768));
        new BooleanParameter((Composite)cSeachSubs, "Search View Is Web View", "ConfigView.section.style.search.is.web.view").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        new BooleanParameter((Composite)cSeachSubs, "Search View Switch Hidden", "ConfigView.section.style.search.hide.view.switch").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        label = new Label(cSeachSubs, 0);
        Messages.setLanguageText(label, "ConfigView.section.style.searchsubs.row.height");
        gridData = new GridData();
        IntParameter graphicUpdate = new IntParameter(cSeachSubs, "Search Subs Row Height", 16, 64);
        graphicUpdate.setLayoutData(gridData);
        return cSection;
    }
}

