/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.PasswordParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionInterfacePassword
implements UISWTConfigSection {
    private static final String LBLKEY_PREFIX = "ConfigView.label.";
    private static final int REQUIRED_MODE = 0;
    Label passwordMatch;

    @Override
    public String configSectionGetParentSection() {
        return "style";
    }

    @Override
    public String configSectionGetName() {
        return "interface.password";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
    }

    @Override
    public int maxUserMode() {
        return 0;
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        Utils.setLayoutData((Control)cSection, gridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.numColumns = 2;
        cSection.setLayout(layout);
        Label label = new Label(cSection, 0);
        Messages.setLanguageText(label, "ConfigView.label.password");
        gridData = new GridData();
        gridData.widthHint = 150;
        PasswordParameter pw1 = new PasswordParameter(cSection, "Password");
        pw1.setLayoutData(gridData);
        Text t1 = (Text)pw1.getControl();
        label = new Label(cSection, 0);
        Messages.setLanguageText(label, "ConfigView.label.passwordconfirm");
        gridData = new GridData();
        gridData.widthHint = 150;
        PasswordParameter pw2 = new PasswordParameter(cSection, "Password Confirm");
        pw2.setLayoutData(gridData);
        Text t2 = (Text)pw2.getControl();
        label = new Label(cSection, 0);
        Messages.setLanguageText(label, "ConfigView.label.passwordmatch");
        this.passwordMatch = new Label(cSection, 0);
        gridData = new GridData();
        gridData.widthHint = 150;
        Utils.setLayoutData((Control)this.passwordMatch, gridData);
        this.refreshPWLabel();
        t1.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                ConfigSectionInterfacePassword.this.refreshPWLabel();
            }
        });
        t2.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                ConfigSectionInterfacePassword.this.refreshPWLabel();
            }
        });
        return cSection;
    }

    private void refreshPWLabel() {
        if (this.passwordMatch == null || this.passwordMatch.isDisposed()) {
            return;
        }
        byte[] password = COConfigurationManager.getByteParameter("Password", "".getBytes());
        COConfigurationManager.setParameter("Password enabled", false);
        if (password.length == 0) {
            this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchnone"));
        } else {
            byte[] confirm = COConfigurationManager.getByteParameter("Password Confirm", "".getBytes());
            if (confirm.length == 0) {
                this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchno"));
            } else {
                boolean same = true;
                for (int i = 0; i < password.length; ++i) {
                    if (password[i] == confirm[i]) continue;
                    same = false;
                }
                if (same) {
                    this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchyes"));
                    COConfigurationManager.setParameter("Password enabled", true);
                } else {
                    this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchno"));
                }
            }
        }
    }
}

