/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.DirectoryParameter;
import org.gudy.azureus2.ui.swt.config.FileParameter;
import org.gudy.azureus2.ui.swt.config.InfoParameter;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.StringAreaParameter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionInterfaceDisplay
implements UISWTConfigSection {
    private static final String MSG_PREFIX = "ConfigView.section.style.";

    @Override
    public String configSectionGetParentSection() {
        return "style";
    }

    @Override
    public String configSectionGetName() {
        return "display";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
    }

    @Override
    public int maxUserMode() {
        return 2;
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        ArrayList<Button> buttons;
        List<PluginInterface> pis;
        GridData gridData;
        Label label;
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean isAZ3 = COConfigurationManager.getStringParameter("ui").equals("az3");
        Composite cSection = new Composite(parent, 0);
        Utils.setLayoutData((Control)cSection, new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        cSection.setLayout(layout);
        Group gVarious = new Group(cSection, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        gVarious.setLayout(layout);
        Utils.setLayoutData((Control)gVarious, new GridData(768));
        gVarious.setText(MessageText.getString("label.various"));
        new BooleanParameter((Composite)gVarious, "Show Download Basket", "ConfigView.section.style.showdownloadbasket");
        if (!isAZ3) {
            new BooleanParameter((Composite)gVarious, "IconBar.enabled", "ConfigView.section.style.showiconbar");
        }
        new BooleanParameter((Composite)gVarious, "suppress_file_download_dialog", "ConfigView.section.interface.display.suppress.file.download.dialog");
        new BooleanParameter((Composite)gVarious, "Suppress Sharing Dialog", "ConfigView.section.interface.display.suppress.sharing.dialog");
        new BooleanParameter((Composite)gVarious, "show_torrents_menu", "Menu.show.torrent.menu");
        if (!Constants.isLinux) {
            new BooleanParameter((Composite)gVarious, "mainwindow.search.history.enabled", "search.history.enable");
        }
        if (Constants.isWindowsXP) {
            final Button enableXPStyle = new Button(gVarious, 32);
            Messages.setLanguageText(enableXPStyle, "ConfigView.section.style.enableXPStyle");
            boolean enabled = false;
            boolean valid = false;
            try {
                File f = new File(System.getProperty("java.home") + "\\bin\\javaw.exe.manifest");
                if (f.exists()) {
                    enabled = true;
                }
                if ((f = FileUtil.getApplicationFile("javaw.exe.manifest")).exists()) {
                    valid = true;
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                valid = false;
            }
            enableXPStyle.setEnabled(valid);
            enableXPStyle.setSelection(enabled);
            enableXPStyle.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event arg0) {
                    if (enableXPStyle.getSelection()) {
                        try {
                            File fDest = new File(System.getProperty("java.home") + "\\bin\\javaw.exe.manifest");
                            File fOrigin = new File("javaw.exe.manifest");
                            if (!fDest.exists() && fOrigin.exists()) {
                                FileUtil.copyFile(fOrigin, fDest);
                            }
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                        }
                    } else {
                        try {
                            File fDest = new File(System.getProperty("java.home") + "\\bin\\javaw.exe.manifest");
                            fDest.delete();
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            });
        }
        if (Constants.isOSX) {
            new BooleanParameter((Composite)gVarious, "enable_small_osx_fonts", "ConfigView.section.style.osx_small_fonts");
        }
        if (PlatformManagerFactory.getPlatformManager().hasCapability(PlatformManagerCapabilities.ShowFileInBrowser)) {
            BooleanParameter bp = new BooleanParameter((Composite)gVarious, "MyTorrentsView.menu.show_parent_folder_enabled", "ConfigView.section.style.use_show_parent_folder");
            Messages.setLanguageText((Widget)bp.getControl(), "ConfigView.section.style.use_show_parent_folder", new String[]{MessageText.getString("MyTorrentsView.menu.open_parent_folder"), MessageText.getString("MyTorrentsView.menu.explore")});
            if (Constants.isOSX) {
                new BooleanParameter((Composite)gVarious, "FileBrowse.usePathFinder", "ConfigView.section.style.usePathFinder");
            }
        }
        if (Constants.isOSX_10_5_OrHigher) {
            Composite cSWT = new Composite(gVarious, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            cSWT.setLayout(layout);
            Utils.setLayoutData((Control)cSWT, new GridData());
            label = new Label(cSWT, 0);
            label.setText("SWT Library");
            String[] swtLibraries = new String[]{"carbon", "cocoa"};
            new StringListParameter(cSWT, "ConfigView.section.style.swt.library.selection", swtLibraries, swtLibraries);
        }
        if (userMode > 0) {
            BooleanParameter paramEnableForceDPI = new BooleanParameter((Composite)gVarious, "enable.ui.forceDPI", "ConfigView.section.style.forceDPI");
            paramEnableForceDPI.setLayoutData(new GridData());
            IntParameter forceDPI = new IntParameter(gVarious, "Force DPI", 0, Integer.MAX_VALUE);
            forceDPI.setLayoutData(new GridData());
            paramEnableForceDPI.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(forceDPI.getControl()));
        }
        if (isAZ3) {
            Group gSideBar = new Group(cSection, 0);
            Messages.setLanguageText(gSideBar, "v3.MainWindow.menu.view.sidebar");
            layout = new GridLayout();
            layout.numColumns = 2;
            gSideBar.setLayout(layout);
            Utils.setLayoutData((Control)gSideBar, new GridData(768));
            new BooleanParameter((Composite)gSideBar, "Show Side Bar", "sidebar.show");
            label = new Label(gSideBar, 0);
            label = new Label(gSideBar, 0);
            Messages.setLanguageText(label, "sidebar.top.level.gap");
            new IntParameter(gSideBar, "Side Bar Top Level Gap", 0, 5);
            new BooleanParameter((Composite)gSideBar, "Show Options In Side Bar", "sidebar.show.options");
            label = new Label(gSideBar, 0);
        }
        Group cStatusBar = new Group(cSection, 0);
        Messages.setLanguageText(cStatusBar, "ConfigView.section.style.status");
        layout = new GridLayout();
        layout.numColumns = 1;
        cStatusBar.setLayout(layout);
        Utils.setLayoutData((Control)cStatusBar, new GridData(768));
        new BooleanParameter((Composite)cStatusBar, "Status Area Show SR", "ConfigView.section.style.status.show_sr");
        new BooleanParameter((Composite)cStatusBar, "Status Area Show NAT", "ConfigView.section.style.status.show_nat");
        new BooleanParameter((Composite)cStatusBar, "Status Area Show DDB", "ConfigView.section.style.status.show_ddb");
        new BooleanParameter((Composite)cStatusBar, "Status Area Show IPF", "ConfigView.section.style.status.show_ipf");
        new BooleanParameter((Composite)cStatusBar, "status.rategraphs", "ConfigView.section.style.status.show_rategraphs");
        if (userMode > 0) {
            Group cUnits = new Group(cSection, 0);
            Messages.setLanguageText(cUnits, "ConfigView.section.style.units");
            layout = new GridLayout();
            layout.numColumns = 1;
            cUnits.setLayout(layout);
            Utils.setLayoutData((Control)cUnits, new GridData(768));
            new BooleanParameter((Composite)cUnits, "config.style.useSIUnits", "ConfigView.section.style.useSIUnits");
            new BooleanParameter((Composite)cUnits, "config.style.forceSIValues", "ConfigView.section.style.forceSIValues");
            new BooleanParameter((Composite)cUnits, "config.style.useUnitsRateBits", "ConfigView.section.style.useUnitsRateBits");
            new BooleanParameter((Composite)cUnits, "config.style.doNotUseGB", "ConfigView.section.style.doNotUseGB");
            new BooleanParameter((Composite)cUnits, "config.style.dataStatsOnly", "ConfigView.section.style.dataStatsOnly");
            new BooleanParameter((Composite)cUnits, "config.style.separateProtDataStats", "ConfigView.section.style.separateProtDataStats");
            new BooleanParameter((Composite)cUnits, "ui.scaled.graphics.binary.based", "ConfigView.section.style.scaleBinary");
        }
        if (userMode > 0) {
            Group formatters_group = new Group(cSection, 0);
            Messages.setLanguageText(formatters_group, "ConfigView.label.general.formatters");
            layout = new GridLayout();
            formatters_group.setLayout(layout);
            Utils.setLayoutData((Control)formatters_group, new GridData(768));
            StringAreaParameter formatters = new StringAreaParameter(formatters_group, "config.style.formatOverrides");
            gridData = new GridData(768);
            gridData.heightHint = formatters.getPreferredHeight(3);
            formatters.setLayoutData(gridData);
            Composite format_info = new Composite(formatters_group, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 3;
            format_info.setLayout(layout);
            Utils.setLayoutData((Control)format_info, new GridData(768));
            new LinkLabel(format_info, "ConfigView.label.general.formatters.link", MessageText.getString("ConfigView.label.general.formatters.link.url"));
            label = new Label(format_info, 0);
            Messages.setLanguageText(label, "GeneralView.label.status");
            InfoParameter info_param = new InfoParameter(format_info, "config.style.formatOverrides.status");
            gridData = new GridData(768);
            info_param.setLayoutData(gridData);
        }
        if (userMode > 0) {
            Group gExternalBrowser = new Group(cSection, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            gExternalBrowser.setLayout(layout);
            Utils.setLayoutData((Control)gExternalBrowser, new GridData(768));
            gExternalBrowser.setText(MessageText.getString("config.external.browser"));
            label = new Label(gExternalBrowser, 64);
            Messages.setLanguageText(label, "config.external.browser.info1");
            Utils.setLayoutData((Control)label, Utils.getWrappableLabelGridData(1, 0));
            label = new Label(gExternalBrowser, 64);
            Messages.setLanguageText(label, "config.external.browser.info2");
            Utils.setLayoutData((Control)label, Utils.getWrappableLabelGridData(1, 0));
            final ArrayList<String[]> browser_choices = new ArrayList<String[]>();
            browser_choices.add(new String[]{"system", MessageText.getString("external.browser.system")});
            browser_choices.add(new String[]{"manual", MessageText.getString("external.browser.manual")});
            pis = AzureusCoreFactory.getSingleton().getPluginManager().getPluginsWithMethod("launchURL", new Class[]{URL.class, Boolean.TYPE, Runnable.class});
            String pi_names = "";
            for (PluginInterface pi : pis) {
                String pi_name = pi.getPluginName();
                pi_names = pi_names + (pi_names.length() == 0 ? "" : "/") + pi_name;
                browser_choices.add(new String[]{"plugin:" + pi.getPluginID(), pi_name});
            }
            Composite cEBArea = new Composite(gExternalBrowser, 64);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)cEBArea, gridData);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            cEBArea.setLayout(layout);
            label = new Label(cEBArea, 64);
            Messages.setLanguageText(label, "config.external.browser.select");
            final Group cEB = new Group(cEBArea, 64);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)cEB, gridData);
            layout = new GridLayout();
            layout.numColumns = browser_choices.size();
            layout.marginHeight = 0;
            cEB.setLayout(layout);
            buttons = new ArrayList<Button>();
            for (int i = 0; i < browser_choices.size(); ++i) {
                Button button = new Button(cEB, 16);
                button.setText(((String[])browser_choices.get(i))[1]);
                button.setData("index", String.valueOf(i));
                buttons.add(button);
            }
            String existing = COConfigurationManager.getStringParameter("browser.external.id", ((String[])browser_choices.get(0))[0]);
            int existing_index = -1;
            for (int i = 0; i < browser_choices.size(); ++i) {
                if (!((String[])browser_choices.get(i))[0].equals(existing)) continue;
                existing_index = i;
                break;
            }
            if (existing_index == -1) {
                existing_index = 0;
                COConfigurationManager.setParameter("browser.external.id", ((String[])browser_choices.get(0))[0]);
            }
            ((Button)buttons.get(existing_index)).setSelection(true);
            Messages.setLanguageText(new Label(cEBArea, 64), "config.external.browser.prog");
            Composite manualArea = new Composite(cEBArea, 0);
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            manualArea.setLayout(layout);
            Utils.setLayoutData((Control)manualArea, new GridData(768));
            final FileParameter manualProg = new FileParameter(manualArea, "browser.external.prog", "", new String[0]);
            manualProg.setEnabled(existing_index == 1);
            Listener radioListener = new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    Button button = (Button)event2.widget;
                    if (button.getSelection()) {
                        Control[] children = cEB.getChildren();
                        for (int j = 0; j < children.length; ++j) {
                            Control child = children[j];
                            if (child == button || !(child instanceof Button)) continue;
                            Button b = (Button)child;
                            b.setSelection(false);
                        }
                        int index = Integer.parseInt((String)button.getData("index"));
                        COConfigurationManager.setParameter("browser.external.id", ((String[])browser_choices.get(index))[0]);
                        manualProg.setEnabled(index == 1);
                    }
                }
            };
            for (Button b : buttons) {
                b.addListener(13, radioListener);
            }
            if (pis.size() > 0) {
                Composite nonPubArea = new Composite(gExternalBrowser, 0);
                layout = new GridLayout(2, false);
                layout.marginHeight = 0;
                nonPubArea.setLayout(layout);
                Utils.setLayoutData((Control)nonPubArea, new GridData(768));
                String temp = MessageText.getString("config.external.browser.non.pub", new String[]{pi_names});
                BooleanParameter non_pub = new BooleanParameter(nonPubArea, "browser.external.non.pub", true, "!" + temp + "!");
            }
            Composite testArea = new Composite(gExternalBrowser, 0);
            layout = new GridLayout(4, false);
            layout.marginHeight = 0;
            testArea.setLayout(layout);
            Utils.setLayoutData((Control)testArea, new GridData(768));
            label = new Label(testArea, 64);
            Messages.setLanguageText(label, "config.external.browser.test");
            final Button test_button = new Button(testArea, 8);
            Messages.setLanguageText(test_button, "configureWizard.nat.test");
            final Text test_url = new Text(testArea, 2048);
            Utils.setLayoutData((Control)test_url, new GridData(768));
            test_url.setText("http://www.vuze.com/");
            test_button.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    test_button.setEnabled(false);
                    final String url_str = test_url.getText().trim();
                    new AEThread2("async"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Utils.launch(url_str, true);
                            }
                            catch (Throwable throwable) {
                                Utils.execSWTThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!test_button.isDisposed()) {
                                            test_button.setEnabled(true);
                                        }
                                    }
                                });
                                throw throwable;
                            }
                            Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                        }
                    }.start();
                }
            });
            label = new Label(testArea, 0);
            Utils.setLayoutData((Control)label, new GridData(768));
            label = new Label(gExternalBrowser, 64);
            Messages.setLanguageText(label, "config.external.browser.switch.info");
            Group switchArea = new Group(gExternalBrowser, 0);
            layout = new GridLayout(3, false);
            switchArea.setLayout(layout);
            Utils.setLayoutData((Control)switchArea, new GridData(768));
            label = new Label(switchArea, 64);
            Messages.setLanguageText(label, "config.external.browser.switch.feature");
            label = new Label(switchArea, 64);
            Messages.setLanguageText(label, "config.external.browser.switch.external");
            label = new Label(switchArea, 64);
            gridData = new GridData(768);
            gridData.horizontalIndent = 10;
            Utils.setLayoutData((Control)label, gridData);
            Messages.setLanguageText(label, "config.external.browser.switch.implic");
            label = new Label(switchArea, 64);
            gridData = new GridData();
            gridData.verticalIndent = 10;
            Utils.setLayoutData((Control)label, gridData);
            Messages.setLanguageText(label, "config.external.browser.switch.search");
            BooleanParameter switchSearch = new BooleanParameter(switchArea, "browser.external.search");
            gridData = new GridData();
            gridData.verticalIndent = 10;
            gridData.horizontalAlignment = 0x1000000;
            switchSearch.setLayoutData(gridData);
            label = new Label(switchArea, 64);
            gridData = Utils.getWrappableLabelGridData(1, 768);
            gridData.verticalIndent = 10;
            gridData.horizontalIndent = 10;
            Utils.setLayoutData((Control)label, gridData);
            Messages.setLanguageText(label, "config.external.browser.switch.search.inf");
            label = new Label(switchArea, 64);
            gridData = new GridData();
            Utils.setLayoutData((Control)label, gridData);
            Messages.setLanguageText(label, "config.external.browser.switch.subs");
            BooleanParameter switchSubs = new BooleanParameter(switchArea, "browser.external.subs");
            gridData = new GridData();
            gridData.horizontalAlignment = 0x1000000;
            switchSubs.setLayoutData(gridData);
            label = new Label(switchArea, 64);
            gridData = Utils.getWrappableLabelGridData(1, 768);
            gridData.horizontalIndent = 10;
            Utils.setLayoutData((Control)label, gridData);
            Messages.setLanguageText(label, "config.external.browser.switch.subs.inf");
        }
        if (userMode > 1) {
            Group gInternalBrowser = new Group(cSection, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            gInternalBrowser.setLayout(layout);
            Utils.setLayoutData((Control)gInternalBrowser, new GridData(768));
            gInternalBrowser.setText(MessageText.getString("config.internal.browser"));
            label = new Label(gInternalBrowser, 64);
            gridData = Utils.getWrappableLabelGridData(1, 768);
            Utils.setLayoutData((Control)label, gridData);
            Messages.setLanguageText(label, "config.internal.browser.info1");
            BooleanParameter intbrow_disable = new BooleanParameter((Composite)gInternalBrowser, "browser.internal.disable", "config.browser.internal.disable");
            label = new Label(gInternalBrowser, 64);
            gridData = Utils.getWrappableLabelGridData(1, 768);
            gridData.horizontalIndent = 15;
            Utils.setLayoutData((Control)label, gridData);
            Messages.setLanguageText(label, "config.browser.internal.disable.info");
            label = new Label(gInternalBrowser, 64);
            gridData = Utils.getWrappableLabelGridData(1, 768);
            Utils.setLayoutData((Control)label, gridData);
            Messages.setLanguageText(label, "config.internal.browser.info3");
            pis = AEProxyFactory.getPluginHTTPProxyProviders(true);
            final ArrayList<String[]> proxy_choices = new ArrayList<String[]>();
            proxy_choices.add(new String[]{"none", MessageText.getString("PeersView.uniquepiece.none")});
            for (PluginInterface pi : pis) {
                proxy_choices.add(new String[]{"plugin:" + pi.getPluginID(), pi.getPluginName()});
            }
            Composite cIPArea = new Composite(gInternalBrowser, 64);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)cIPArea, gridData);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            cIPArea.setLayout(layout);
            label = new Label(cIPArea, 64);
            gridData = Utils.getWrappableLabelGridData(1, 768);
            Utils.setLayoutData((Control)label, gridData);
            Messages.setLanguageText(label, "config.internal.browser.proxy.select");
            final Group cIP = new Group(cIPArea, 64);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)cIP, gridData);
            layout = new GridLayout();
            layout.numColumns = proxy_choices.size();
            layout.marginHeight = 0;
            cIP.setLayout(layout);
            buttons = new ArrayList();
            for (int i = 0; i < proxy_choices.size(); ++i) {
                Button button = new Button(cIP, 16);
                button.setText(((String[])proxy_choices.get(i))[1]);
                button.setData("index", String.valueOf(i));
                buttons.add(button);
            }
            String existing = COConfigurationManager.getStringParameter("browser.internal.proxy.id", ((String[])proxy_choices.get(0))[0]);
            int existing_index = -1;
            for (int i = 0; i < proxy_choices.size(); ++i) {
                if (!((String[])proxy_choices.get(i))[0].equals(existing)) continue;
                existing_index = i;
                break;
            }
            if (existing_index == -1) {
                existing_index = 0;
                COConfigurationManager.setParameter("browser.internal.proxy.id", ((String[])proxy_choices.get(0))[0]);
            }
            ((Button)buttons.get(existing_index)).setSelection(true);
            Listener radioListener = new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    Button button = (Button)event2.widget;
                    if (button.getSelection()) {
                        Control[] children = cIP.getChildren();
                        for (int j = 0; j < children.length; ++j) {
                            Control child = children[j];
                            if (child == button || !(child instanceof Button)) continue;
                            Button b = (Button)child;
                            b.setSelection(false);
                        }
                        int index = Integer.parseInt((String)button.getData("index"));
                        COConfigurationManager.setParameter("browser.internal.proxy.id", ((String[])proxy_choices.get(index))[0]);
                    }
                }
            };
            for (Button b : buttons) {
                b.addListener(13, radioListener);
            }
            label = new Label(gInternalBrowser, 64);
            gridData = Utils.getWrappableLabelGridData(1, 768);
            Utils.setLayoutData((Control)label, gridData);
            Messages.setLanguageText(label, "config.internal.browser.info2");
            BooleanParameter fMoz = new BooleanParameter((Composite)gInternalBrowser, "swt.forceMozilla", "ConfigView.section.style.forceMozilla");
            Composite pArea = new Composite(gInternalBrowser, 0);
            pArea.setLayout(new GridLayout(3, false));
            Utils.setLayoutData((Control)pArea, new GridData(768));
            Messages.setLanguageText(new Label(pArea, 64), "ConfigView.section.style.xulRunnerPath");
            DirectoryParameter xulDir = new DirectoryParameter(pArea, "swt.xulRunner.path", "");
            fMoz.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(((Parameter)xulDir).getControls(), false));
            intbrow_disable.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(((Parameter)xulDir).getControls(), true));
            intbrow_disable.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{fMoz.getControl()}, true));
            for (Button b : buttons) {
                intbrow_disable.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{b}, true));
            }
        }
        Group gRefresh = new Group(cSection, 0);
        gRefresh.setText(MessageText.getString("upnp.refresh.button"));
        layout = new GridLayout();
        layout.numColumns = 2;
        gRefresh.setLayout(layout);
        Utils.setLayoutData((Control)gRefresh, new GridData(768));
        label = new Label(gRefresh, 0);
        Messages.setLanguageText(label, "ConfigView.section.style.guiUpdate");
        int[] values = new int[]{10, 25, 50, 100, 250, 500, 1000, 2000, 5000, 10000, 15000};
        String[] labels = new String[]{"10 ms", "25 ms", "50 ms", "100 ms", "250 ms", "500 ms", "1 s", "2 s", "5 s", "10 s", "15 s"};
        new IntListParameter(gRefresh, "GUI Refresh", 1000, labels, values);
        label = new Label(gRefresh, 0);
        Messages.setLanguageText(label, "ConfigView.section.style.inactiveUpdate");
        gridData = new GridData();
        IntParameter inactiveUpdate = new IntParameter(gRefresh, "Refresh When Inactive", 1, Integer.MAX_VALUE);
        inactiveUpdate.setLayoutData(gridData);
        label = new Label(gRefresh, 0);
        Messages.setLanguageText(label, "ConfigView.section.style.graphicsUpdate");
        gridData = new GridData();
        IntParameter graphicUpdate = new IntParameter(gRefresh, "Graphics Update", 1, Integer.MAX_VALUE);
        graphicUpdate.setLayoutData(gridData);
        return cSection;
    }
}

