/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.applet.Applet;
import java.io.File;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionInterfaceAlerts
implements UISWTConfigSection {
    private static final String INTERFACE_PREFIX = "ConfigView.section.interface.";
    private static final String LBLKEY_PREFIX = "ConfigView.label.";
    private static final String STYLE_PREFIX = "ConfigView.section.style.";
    private static final int REQUIRED_MODE = 0;

    @Override
    public String configSectionGetParentSection() {
        return "style";
    }

    @Override
    public String configSectionGetName() {
        return "interface.alerts";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.releaseImage("openFolderButton");
    }

    @Override
    public int maxUserMode() {
        return 0;
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        Image imgOpenFolder = null;
        ImageLoader imageLoader = ImageLoader.getInstance();
        imgOpenFolder = imageLoader.getImage("openFolderButton");
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData(gridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        cSection.setLayout(layout);
        Composite cArea = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        cArea.setLayout(layout);
        cArea.setLayoutData(new GridData(768));
        this.playSoundWhen(cArea, imgOpenFolder, "Play Download Finished Announcement", "Play Download Finished Announcement Text", "playdownloadspeech", "Play Download Finished", "Play Download Finished File", "playdownloadfinished");
        this.playSoundWhen(cArea, imgOpenFolder, "Play Download Error Announcement", "Play Download Error Announcement Text", "playdownloaderrorspeech", "Play Download Error", "Play Download Error File", "playdownloaderror");
        this.playSoundWhen(cArea, imgOpenFolder, "Play File Finished Announcement", "Play File Finished Announcement Text", "playfilespeech", "Play File Finished", "Play File Finished File", "playfilefinished");
        this.playSoundWhen(cArea, imgOpenFolder, "Play Notification Added Announcement", "Play Notification Added Announcement Text", "playnotificationaddedspeech", "Play Notification Added", "Play Notification Added File", "playnotificationadded");
        boolean isAZ3 = COConfigurationManager.getStringParameter("ui").equals("az3");
        if (isAZ3) {
            BooleanParameter p = new BooleanParameter(cArea, "Request Attention On New Download", "ConfigView.label.dl.add.req.attention");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            p.setLayoutData(gridData);
        }
        BooleanParameter activate_win = new BooleanParameter(cArea, "Activate Window On External Download", "ConfigView.label.show.win.on.add");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        activate_win.setLayoutData(gridData);
        BooleanParameter no_auto_activate = new BooleanParameter(cArea, "Reduce Auto Activate Window", "ConfigView.label.reduce.auto.activate");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        no_auto_activate.setLayoutData(gridData);
        Group gPopup = new Group(cSection, 0);
        Messages.setLanguageText(gPopup, "label.popups");
        layout = new GridLayout();
        layout.numColumns = 2;
        gPopup.setLayout(layout);
        gPopup.setLayoutData(new GridData(768));
        BooleanParameter popup_dl_added = new BooleanParameter((Composite)gPopup, "Popup Download Added", "ConfigView.label.popupdownloadadded");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        popup_dl_added.setLayoutData(gridData);
        BooleanParameter popup_dl_completed = new BooleanParameter((Composite)gPopup, "Popup Download Finished", "ConfigView.label.popupdownloadfinished");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        popup_dl_completed.setLayoutData(gridData);
        BooleanParameter popup_dl_error = new BooleanParameter((Composite)gPopup, "Popup Download Error", "ConfigView.label.popupdownloaderror");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        popup_dl_error.setLayoutData(gridData);
        BooleanParameter popup_file_completed = new BooleanParameter((Composite)gPopup, "Popup File Finished", "ConfigView.label.popupfilefinished");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        popup_file_completed.setLayoutData(gridData);
        BooleanParameter disable_sliding = new BooleanParameter((Composite)gPopup, "GUI_SWT_DisableAlertSliding", "ConfigView.section.style.disableAlertSliding");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        disable_sliding.setLayoutData(gridData);
        BooleanParameter show_alert_timestamps = new BooleanParameter((Composite)gPopup, "Show Timestamp For Alerts", "ConfigView.label.popup.timestamp");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        show_alert_timestamps.setLayoutData(gridData);
        Label label = new Label(gPopup, 64);
        Messages.setLanguageText(label, "ConfigView.label.popup.autohide");
        label.setLayoutData(new GridData());
        IntParameter auto_hide_alert = new IntParameter(gPopup, "Message Popup Autoclose in Seconds", 0, 86400);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        auto_hide_alert.setLayoutData(gridData);
        return cSection;
    }

    private void playSoundWhen(final Composite cArea, Image imgOpenFolder, String announceEnableConfig, String announceKeyConfig, String announceResource, String playEnableConfig, String playKeyConfig, String playResource) {
        if (Constants.isOSX) {
            new BooleanParameter(cArea, announceEnableConfig, LBLKEY_PREFIX + announceResource);
            StringParameter d_speechParameter = new StringParameter(cArea, announceKeyConfig);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.widthHint = 150;
            d_speechParameter.setLayoutData(gridData);
            ((Text)d_speechParameter.getControl()).setTextLimit(40);
        }
        new BooleanParameter(cArea, playEnableConfig, LBLKEY_PREFIX + playResource);
        GridData gridData = new GridData(768);
        final StringParameter e_pathParameter = new StringParameter(cArea, playKeyConfig, "");
        if (e_pathParameter.getValue().length() == 0) {
            e_pathParameter.setValue("<default>");
        }
        e_pathParameter.setLayoutData(gridData);
        Button d_browse = new Button(cArea, 8);
        d_browse.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(d_browse.getBackground());
        d_browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        d_browse.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                FileDialog dialog = new FileDialog(cArea.getShell(), 65536);
                dialog.setFilterExtensions(new String[]{"*.wav"});
                dialog.setFilterNames(new String[]{"*.wav"});
                dialog.setText(MessageText.getString("ConfigView.section.interface.wavlocation"));
                final String path = dialog.open();
                if (path != null) {
                    e_pathParameter.setValue(path);
                    new AEThread2("SoundTest"){

                        @Override
                        public void run() {
                            try {
                                Applet.newAudioClip(new File(path).toURI().toURL()).play();
                                Thread.sleep(2500L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
            }
        });
        Label d_sound_info = new Label(cArea, 64);
        Messages.setLanguageText(d_sound_info, "ConfigView.section.interface.wavlocation.info");
        gridData = new GridData(768);
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)d_sound_info, gridData);
    }
}

