/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionFilePerformance
implements UISWTConfigSection {
    @Override
    public String configSectionGetParentSection() {
        return "files";
    }

    @Override
    public String configSectionGetName() {
        return "file.perf";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
    }

    @Override
    public int maxUserMode() {
        return 2;
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Composite cSection = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        cSection.setLayout(layout);
        GridData gridData = new GridData(272);
        gridData.horizontalSpan = 2;
        Utils.setLayoutData((Control)cSection, gridData);
        Label label = new Label(cSection, 64);
        Messages.setLanguageText(label, "ConfigView.section.file.perf.explain");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        Utils.setLayoutData((Control)label, gridData);
        BooleanParameter friendly_hashchecking = new BooleanParameter(cSection, "diskmanager.friendly.hashchecking", "ConfigView.section.file.friendly.hashchecking");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        friendly_hashchecking.setLayoutData(gridData);
        BooleanParameter check_smallest = new BooleanParameter(cSection, "diskmanager.hashchecking.smallestfirst", "ConfigView.section.file.hashchecking.smallestfirst");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        check_smallest.setLayoutData(gridData);
        BooleanParameter disk_cache = new BooleanParameter(cSection, "diskmanager.perf.cache.enable", "ConfigView.section.file.perf.cache.enable");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        disk_cache.setLayoutData(gridData);
        long max_mem_bytes = Runtime.getRuntime().maxMemory();
        long mb_1 = 0x100000L;
        long mb_32 = 32L * mb_1;
        Label cache_size_label = new Label(cSection, 0);
        gridData = new GridData(2);
        cache_size_label.setLayoutData(gridData);
        Messages.setLanguageText((Widget)cache_size_label, "ConfigView.section.file.perf.cache.size", new String[]{DisplayFormatters.getUnitBase10(2)});
        IntParameter cache_size = new IntParameter(cSection, "diskmanager.perf.cache.size", 1, COConfigurationManager.CONFIG_CACHE_SIZE_MAX_MB);
        gridData = new GridData(2);
        cache_size.setLayoutData(gridData);
        Label cache_explain_label = new Label(cSection, 64);
        gridData = new GridData(770);
        gridData.widthHint = 300;
        Utils.setLayoutData((Control)cache_explain_label, gridData);
        Messages.setLanguageText((Widget)cache_explain_label, "ConfigView.section.file.perf.cache.size.explain", new String[]{DisplayFormatters.formatByteCountToKiBEtc(mb_32), DisplayFormatters.formatByteCountToKiBEtc(max_mem_bytes), "http://wiki.vuze.com/w/"});
        if (userMode > 0) {
            Label cnst_label = new Label(cSection, 0);
            gridData = new GridData(2);
            Utils.setLayoutData((Control)cnst_label, gridData);
            Messages.setLanguageText((Widget)cnst_label, "ConfigView.section.file.perf.cache.notsmallerthan", new String[]{DisplayFormatters.getUnitBase10(1)});
            IntParameter cache_not_smaller_than = new IntParameter(cSection, "diskmanager.perf.cache.notsmallerthan");
            cache_not_smaller_than.setMinimumValue(0);
            gridData = new GridData(2);
            cache_not_smaller_than.setLayoutData(gridData);
            BooleanParameter disk_cache_read = new BooleanParameter(cSection, "diskmanager.perf.cache.enable.read", "ConfigView.section.file.perf.cache.enable.read");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            disk_cache_read.setLayoutData(gridData);
            BooleanParameter disk_cache_write = new BooleanParameter(cSection, "diskmanager.perf.cache.enable.write", "ConfigView.section.file.perf.cache.enable.write");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            disk_cache_write.setLayoutData(gridData);
            BooleanParameter disk_cache_flush = new BooleanParameter(cSection, "diskmanager.perf.cache.flushpieces", "ConfigView.section.file.perf.cache.flushpieces");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            disk_cache_flush.setLayoutData(gridData);
            BooleanParameter disk_cache_trace = new BooleanParameter(cSection, "diskmanager.perf.cache.trace", "ConfigView.section.file.perf.cache.trace");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            disk_cache_trace.setLayoutData(gridData);
            disk_cache.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{cnst_label}));
            disk_cache.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(cache_not_smaller_than.getControls()));
            disk_cache.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(disk_cache_trace.getControls()));
            disk_cache.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(disk_cache_read.getControls()));
            disk_cache.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(disk_cache_write.getControls()));
            disk_cache.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(disk_cache_flush.getControls()));
            disk_cache.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(disk_cache_trace.getControls()));
            if (userMode > 1) {
                label = new Label(cSection, 0);
                gridData = new GridData(2);
                label.setLayoutData(gridData);
                Messages.setLanguageText(label, "ConfigView.section.file.max_open_files");
                IntParameter file_max_open = new IntParameter(cSection, "File Max Open");
                gridData = new GridData(2);
                file_max_open.setLayoutData(gridData);
                label = new Label(cSection, 64);
                gridData = new GridData(770);
                gridData.widthHint = 300;
                Utils.setLayoutData((Control)label, gridData);
                Messages.setLanguageText(label, "ConfigView.section.file.max_open_files.explain");
                label = new Label(cSection, 0);
                gridData = new GridData(2);
                Utils.setLayoutData((Control)label, gridData);
                String label_text = MessageText.getString("ConfigView.section.file.writemblimit", new String[]{DisplayFormatters.getUnitBase10(2)});
                label.setText(label_text);
                IntParameter write_block_limit = new IntParameter(cSection, "diskmanager.perf.write.maxmb");
                gridData = new GridData(2);
                write_block_limit.setLayoutData(gridData);
                label = new Label(cSection, 64);
                gridData = new GridData(770);
                gridData.widthHint = 300;
                Utils.setLayoutData((Control)label, gridData);
                Messages.setLanguageText(label, "ConfigView.section.file.writemblimit.explain");
                label = new Label(cSection, 0);
                gridData = new GridData(2);
                Utils.setLayoutData((Control)label, gridData);
                label_text = MessageText.getString("ConfigView.section.file.readmblimit", new String[]{DisplayFormatters.getUnitBase10(2)});
                label.setText(label_text);
                IntParameter check_piece_limit = new IntParameter(cSection, "diskmanager.perf.read.maxmb");
                gridData = new GridData(2);
                check_piece_limit.setLayoutData(gridData);
                label = new Label(cSection, 64);
                gridData = new GridData(770);
                gridData.widthHint = 300;
                Utils.setLayoutData((Control)label, gridData);
                Messages.setLanguageText(label, "ConfigView.section.file.readmblimit.explain");
            }
        }
        disk_cache.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(cache_size.getControls()));
        disk_cache.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{cache_size_label, cache_explain_label}));
        return cSection;
    }
}

