/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.GenericActionPerformer;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionConnectionProxy
implements UISWTConfigSection {
    private static final String CFG_PREFIX = "ConfigView.section.proxy.";
    private static final int REQUIRED_MODE = 2;

    @Override
    public int maxUserMode() {
        return 2;
    }

    @Override
    public String configSectionGetParentSection() {
        return "server";
    }

    @Override
    public String configSectionGetName() {
        return "proxy";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        Utils.setLayoutData((Control)cSection, gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        cSection.setLayout(layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode < 2) {
            Label label = new Label(cSection, 64);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)label, gridData);
            String[] modeKeys = new String[]{"ConfigView.section.mode.beginner", "ConfigView.section.mode.intermediate", "ConfigView.section.mode.advanced"};
            String param1 = 2 < modeKeys.length ? MessageText.getString(modeKeys[2]) : String.valueOf(2);
            String param2 = userMode < modeKeys.length ? MessageText.getString(modeKeys[userMode]) : String.valueOf(userMode);
            label.setText(MessageText.getString("ConfigView.notAvailableForMode", new String[]{param1, param2}));
            return cSection;
        }
        Group gProxyTracker = new Group(cSection, 0);
        Messages.setLanguageText(gProxyTracker, "ConfigView.section.proxy.group.tracker");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        Utils.setLayoutData((Control)gProxyTracker, gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gProxyTracker.setLayout(layout);
        final BooleanParameter enableProxy = new BooleanParameter((Composite)gProxyTracker, "Enable.Proxy", "ConfigView.section.proxy.enable_proxy");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enableProxy.setLayoutData(gridData);
        final BooleanParameter enableSocks = new BooleanParameter((Composite)gProxyTracker, "Enable.SOCKS", "ConfigView.section.proxy.enable_socks");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enableSocks.setLayoutData(gridData);
        Label lHost = new Label(gProxyTracker, 0);
        Messages.setLanguageText(lHost, "ConfigView.section.proxy.host");
        final StringParameter pHost = new StringParameter(gProxyTracker, "Proxy.Host", "", false);
        gridData = new GridData();
        gridData.widthHint = 105;
        pHost.setLayoutData(gridData);
        Label lPort = new Label(gProxyTracker, 0);
        Messages.setLanguageText(lPort, "ConfigView.section.proxy.port");
        final StringParameter pPort = new StringParameter(gProxyTracker, "Proxy.Port", "", false);
        gridData = new GridData();
        gridData.widthHint = 40;
        pPort.setLayoutData(gridData);
        Label lUser = new Label(gProxyTracker, 0);
        Messages.setLanguageText(lUser, "ConfigView.section.proxy.username");
        final StringParameter pUser = new StringParameter((Composite)gProxyTracker, "Proxy.Username", false);
        gridData = new GridData();
        gridData.widthHint = 105;
        pUser.setLayoutData(gridData);
        Label lPass = new Label(gProxyTracker, 0);
        Messages.setLanguageText(lPass, "ConfigView.section.proxy.password");
        final StringParameter pPass = new StringParameter(gProxyTracker, "Proxy.Password", "", false);
        gridData = new GridData();
        gridData.widthHint = 105;
        pPass.setLayoutData(gridData);
        final BooleanParameter trackerDNSKill = new BooleanParameter((Composite)gProxyTracker, "Proxy.SOCKS.Tracker.DNS.Disable", "ConfigView.section.proxy.no.local.dns");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        trackerDNSKill.setLayoutData(gridData);
        final NetworkAdminSocksProxy[] test_proxy = new NetworkAdminSocksProxy[]{null};
        final Button test_socks = new Button(gProxyTracker, 8);
        Messages.setLanguageText(test_socks, "ConfigView.section.proxy.testsocks");
        test_socks.addListener(13, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(Event event2) {
                NetworkAdminSocksProxy[] networkAdminSocksProxyArray = test_proxy;
                synchronized (test_proxy) {
                    final NetworkAdminSocksProxy target = test_proxy[0];
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    if (target != null) {
                        final TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("ConfigView.section.proxy.testsocks.title"), null, "Testing SOCKS connection to " + target.getHost() + ":" + target.getPort(), false);
                        final AESemaphore test_done = new AESemaphore("");
                        new AEThread2("SOCKS test"){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    String[] vers = target.getVersionsSupported();
                                    String ver = "";
                                    for (String v : vers) {
                                        ver = ver + (ver.length() == 0 ? "" : ", ") + v;
                                    }
                                    this.appendText(viewer, "\r\nConnection OK - supported version(s): " + ver);
                                }
                                catch (Throwable e) {
                                    this.appendText(viewer, "\r\n" + Debug.getNestedExceptionMessage(e));
                                }
                                finally {
                                    test_done.release();
                                }
                            }
                        }.start();
                        new AEThread2("SOCKS test dotter"){

                            @Override
                            public void run() {
                                while (!test_done.reserveIfAvailable()) {
                                    this.appendText(viewer, ".");
                                    try {
                                        Thread.sleep(500L);
                                    }
                                    catch (Throwable e) {
                                        break;
                                    }
                                }
                            }
                        }.start();
                    }
                    return;
                }
            }

            private void appendText(final TextViewerWindow viewer, final String line) {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!viewer.isDisposed()) {
                            viewer.append2(line);
                        }
                    }
                });
            }
        });
        Parameter[] socks_params = new Parameter[]{enableProxy, enableSocks, pHost, pPort, pUser, pPass, trackerDNSKill};
        ParameterChangeAdapter socks_adapter = new ParameterChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void parameterChanged(Parameter p, boolean caused_internally) {
                if (test_socks.isDisposed()) {
                    p.removeChangeListener(this);
                    return;
                }
                if (caused_internally) return;
                boolean enabled = enableProxy.isSelected() != false && enableSocks.isSelected() != false && pHost.getValue().trim().length() > 0 && pPort.getValue().trim().length() > 0;
                boolean socks_enabled = enableProxy.isSelected() != false && enableSocks.isSelected() != false;
                trackerDNSKill.setEnabled(socks_enabled);
                if (enabled) {
                    try {
                        int port = Integer.parseInt(pPort.getValue());
                        NetworkAdminSocksProxy nasp = NetworkAdmin.getSingleton().createSocksProxy(pHost.getValue(), port, pUser.getValue(), pPass.getValue());
                        NetworkAdminSocksProxy[] networkAdminSocksProxyArray = test_proxy;
                        // MONITORENTER : test_proxy
                        test_proxy[0] = nasp;
                        // MONITOREXIT : networkAdminSocksProxyArray
                    }
                    catch (Throwable e) {
                        enabled = false;
                    }
                }
                if (!enabled) {
                    NetworkAdminSocksProxy[] e = test_proxy;
                    // MONITORENTER : test_proxy
                    test_proxy[0] = null;
                    // MONITOREXIT : e
                }
                final boolean f_enabled = enabled;
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!test_socks.isDisposed()) {
                            test_socks.setEnabled(f_enabled);
                        }
                    }
                });
            }
        };
        for (Parameter p : socks_params) {
            p.addChangeListener(socks_adapter);
        }
        socks_adapter.parameterChanged(null, false);
        Group gProxyPeer = new Group(cSection, 0);
        Messages.setLanguageText(gProxyPeer, "ConfigView.section.proxy.group.peer");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        Utils.setLayoutData((Control)gProxyPeer, gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gProxyPeer.setLayout(layout);
        final BooleanParameter enableSocksPeer = new BooleanParameter((Composite)gProxyPeer, "Proxy.Data.Enable", "ConfigView.section.proxy.enable_socks.peer");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enableSocksPeer.setLayoutData(gridData);
        BooleanParameter socksPeerInform = new BooleanParameter((Composite)gProxyPeer, "Proxy.Data.SOCKS.inform", "ConfigView.section.proxy.peer.informtracker");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        socksPeerInform.setLayoutData(gridData);
        Label lSocksVersion = new Label(gProxyPeer, 0);
        Messages.setLanguageText(lSocksVersion, "ConfigView.section.proxy.socks.version");
        String[] socks_types = new String[]{"V4", "V4a", "V5"};
        String[] dropLabels = new String[socks_types.length];
        String[] dropValues = new String[socks_types.length];
        for (int i = 0; i < socks_types.length; ++i) {
            dropLabels[i] = socks_types[i];
            dropValues[i] = socks_types[i];
        }
        StringListParameter socksType = new StringListParameter((Composite)gProxyPeer, "Proxy.Data.SOCKS.version", "V4", dropLabels, dropValues);
        final BooleanParameter sameConfig = new BooleanParameter((Composite)gProxyPeer, "Proxy.Data.Same", "ConfigView.section.proxy.peer.same");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        sameConfig.setLayoutData(gridData);
        Label lDataHost = new Label(gProxyPeer, 0);
        Messages.setLanguageText(lDataHost, "ConfigView.section.proxy.host");
        StringParameter pDataHost = new StringParameter((Composite)gProxyPeer, "Proxy.Data.Host", "");
        gridData = new GridData();
        gridData.widthHint = 105;
        pDataHost.setLayoutData(gridData);
        Label lDataPort = new Label(gProxyPeer, 0);
        Messages.setLanguageText(lDataPort, "ConfigView.section.proxy.port");
        StringParameter pDataPort = new StringParameter((Composite)gProxyPeer, "Proxy.Data.Port", "");
        gridData = new GridData();
        gridData.widthHint = 40;
        pDataPort.setLayoutData(gridData);
        Label lDataUser = new Label(gProxyPeer, 0);
        Messages.setLanguageText(lDataUser, "ConfigView.section.proxy.username");
        StringParameter pDataUser = new StringParameter(gProxyPeer, "Proxy.Data.Username");
        gridData = new GridData();
        gridData.widthHint = 105;
        pDataUser.setLayoutData(gridData);
        Label lDataPass = new Label(gProxyPeer, 0);
        Messages.setLanguageText(lDataPass, "ConfigView.section.proxy.password");
        StringParameter pDataPass = new StringParameter((Composite)gProxyPeer, "Proxy.Data.Password", "");
        gridData = new GridData();
        gridData.widthHint = 105;
        pDataPass.setLayoutData(gridData);
        final Control[] proxy_controls = new Control[]{enableSocks.getControl(), lHost, pHost.getControl(), lPort, pPort.getControl(), lUser, pUser.getControl(), lPass, pPass.getControl()};
        GenericActionPerformer proxy_enabler = new GenericActionPerformer(new Control[0]){

            @Override
            public void performAction() {
                for (int i = 0; i < proxy_controls.length; ++i) {
                    proxy_controls[i].setEnabled(enableProxy.isSelected());
                }
            }
        };
        final Control[] proxy_peer_controls = new Control[]{lDataHost, pDataHost.getControl(), lDataPort, pDataPort.getControl(), lDataUser, pDataUser.getControl(), lDataPass, pDataPass.getControl()};
        final Control[] proxy_peer_details = new Control[]{sameConfig.getControl(), socksPeerInform.getControl(), socksType.getControl(), lSocksVersion};
        GenericActionPerformer proxy_peer_enabler = new GenericActionPerformer(new Control[0]){

            @Override
            public void performAction() {
                int i;
                for (i = 0; i < proxy_peer_controls.length; ++i) {
                    proxy_peer_controls[i].setEnabled(enableSocksPeer.isSelected() != false && sameConfig.isSelected() == false);
                }
                for (i = 0; i < proxy_peer_details.length; ++i) {
                    proxy_peer_details[i].setEnabled(enableSocksPeer.isSelected());
                }
            }
        };
        enableSocks.setAdditionalActionPerformer(proxy_enabler);
        enableProxy.setAdditionalActionPerformer(proxy_enabler);
        enableSocksPeer.setAdditionalActionPerformer(proxy_peer_enabler);
        sameConfig.setAdditionalActionPerformer(proxy_peer_enabler);
        Label label = new Label(cSection, 64);
        Messages.setLanguageText(label, "ConfigView.section.proxy.dns.info");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        Utils.setLayoutData((Control)label, gridData);
        BooleanParameter disablepps = new BooleanParameter(cSection, "Proxy.SOCKS.disable.plugin.proxies", "ConfigView.section.proxy.disable.plugin.proxies");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        disablepps.setLayoutData(gridData);
        BooleanParameter checkOnStart = new BooleanParameter(cSection, "Proxy.Check.On.Start", "ConfigView.section.proxy.check.on.start");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        checkOnStart.setLayoutData(gridData);
        BooleanParameter showIcon = new BooleanParameter(cSection, "Proxy.SOCKS.ShowIcon", "ConfigView.section.proxy.show_icon");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        showIcon.setLayoutData(gridData);
        BooleanParameter flagIncoming = new BooleanParameter(cSection, "Proxy.SOCKS.ShowIcon.FlagIncoming", "ConfigView.section.proxy.show_icon.flag.incoming");
        gridData = new GridData();
        gridData.horizontalIndent = 50;
        gridData.horizontalSpan = 2;
        flagIncoming.setLayoutData(gridData);
        showIcon.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(flagIncoming));
        label = new Label(cSection, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        Utils.setLayoutData((Control)label, gridData);
        label.setText(MessageText.getString("ConfigView.section.proxy.username.info"));
        return cSection;
    }
}

