/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.GenericActionPerformer;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionConnectionEncryption
implements UISWTConfigSection {
    private static final String CFG_PREFIX = "ConfigView.section.connection.encryption.";
    private static final int REQUIRED_MODE = 1;

    @Override
    public int maxUserMode() {
        return 1;
    }

    @Override
    public String configSectionGetParentSection() {
        return "server";
    }

    @Override
    public String configSectionGetName() {
        return "connection.encryption";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData(gridData);
        GridLayout advanced_layout = new GridLayout();
        cSection.setLayout(advanced_layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode < 1) {
            Label label = new Label(cSection, 64);
            gridData = new GridData();
            label.setLayoutData(gridData);
            String[] modeKeys = new String[]{"ConfigView.section.mode.beginner", "ConfigView.section.mode.intermediate", "ConfigView.section.mode.advanced"};
            String param1 = 1 < modeKeys.length ? MessageText.getString(modeKeys[1]) : String.valueOf(1);
            String param2 = userMode < modeKeys.length ? MessageText.getString(modeKeys[userMode]) : String.valueOf(userMode);
            label.setText(MessageText.getString("ConfigView.notAvailableForMode", new String[]{param1, param2}));
            return cSection;
        }
        Group gCrypto = new Group(cSection, 0);
        Messages.setLanguageText(gCrypto, "ConfigView.section.connection.encryption.encrypt.group");
        gridData = new GridData(768);
        gCrypto.setLayoutData(gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        gCrypto.setLayout(layout);
        Label lcrypto = new Label(gCrypto, 64);
        Messages.setLanguageText(lcrypto, "ConfigView.section.connection.encryption.encrypt.info");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        Utils.setLayoutData((Control)lcrypto, gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new LinkLabel(gCrypto, gridData, "ConfigView.section.connection.encryption.encrypt.info.link", "http://wiki.vuze.com/w/Avoid_traffic_shaping");
        final BooleanParameter require = new BooleanParameter((Composite)gCrypto, "network.transport.encrypted.require", "ConfigView.section.connection.encryption.require_encrypted_transport");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        require.setLayoutData(gridData);
        String[] encryption_types = new String[]{"Plain", "RC4"};
        String[] dropLabels = new String[encryption_types.length];
        String[] dropValues = new String[encryption_types.length];
        for (int i = 0; i < encryption_types.length; ++i) {
            dropLabels[i] = encryption_types[i];
            dropValues[i] = encryption_types[i];
        }
        Composite cEncryptLevel = new Composite(gCrypto, 0);
        gridData = new GridData(272);
        gridData.horizontalSpan = 2;
        cEncryptLevel.setLayoutData(gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cEncryptLevel.setLayout(layout);
        Label lmin = new Label(cEncryptLevel, 0);
        Messages.setLanguageText(lmin, "ConfigView.section.connection.encryption.min_encryption_level");
        StringListParameter min_level = new StringListParameter(cEncryptLevel, "network.transport.encrypted.min_level", encryption_types[1], dropLabels, dropValues);
        Label lcryptofb = new Label(gCrypto, 64);
        Messages.setLanguageText(lcryptofb, "ConfigView.section.connection.encryption.encrypt.fallback_info");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        Utils.setLayoutData((Control)lcryptofb, gridData);
        BooleanParameter fallback_outgoing = new BooleanParameter((Composite)gCrypto, "network.transport.encrypted.fallback.outgoing", "ConfigView.section.connection.encryption.encrypt.fallback_outgoing");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        fallback_outgoing.setLayoutData(gridData);
        final BooleanParameter fallback_incoming = new BooleanParameter((Composite)gCrypto, "network.transport.encrypted.fallback.incoming", "ConfigView.section.connection.encryption.encrypt.fallback_incoming");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        fallback_incoming.setLayoutData(gridData);
        final BooleanParameter use_crypto_port = new BooleanParameter((Composite)gCrypto, "network.transport.encrypted.use.crypto.port", "ConfigView.section.connection.encryption.use_crypto_port");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        use_crypto_port.setLayoutData(gridData);
        final Control[] ap_controls = new Control[]{min_level.getControl(), lmin, lcryptofb, fallback_outgoing.getControl(), fallback_incoming.getControl()};
        GenericActionPerformer iap = new GenericActionPerformer(new Control[0]){

            @Override
            public void performAction() {
                boolean required = require.isSelected();
                boolean ucp_enabled = fallback_incoming.isSelected() == false && required;
                use_crypto_port.getControl().setEnabled(ucp_enabled);
                for (int i = 0; i < ap_controls.length; ++i) {
                    ap_controls[i].setEnabled(required);
                }
            }
        };
        fallback_incoming.setAdditionalActionPerformer(iap);
        require.setAdditionalActionPerformer(iap);
        return cSection;
    }
}

