/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionConnection
implements UISWTConfigSection {
    private static final String CFG_PREFIX = "ConfigView.section.connection.";

    @Override
    public String configSectionGetParentSection() {
        return "root";
    }

    @Override
    public String configSectionGetName() {
        return "server";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
    }

    @Override
    public int maxUserMode() {
        return 2;
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        Utils.setLayoutData((Control)cSection, gridData);
        GridLayout layout = new GridLayout();
        cSection.setLayout(layout);
        Composite cMiniArea = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cMiniArea.setLayout(layout);
        gridData = new GridData(768);
        Utils.setLayoutData((Control)cMiniArea, gridData);
        final boolean separate_ports = userMode > 1 || COConfigurationManager.getIntParameter("TCP.Listen.Port") != COConfigurationManager.getIntParameter("UDP.Listen.Port");
        Label label = new Label(cMiniArea, 0);
        Messages.setLanguageText(label, separate_ports ? "ConfigView.label.tcplistenport" : "ConfigView.label.serverport");
        gridData = new GridData(128);
        Utils.setLayoutData((Control)label, gridData);
        final IntParameter tcplisten = new IntParameter(cMiniArea, "TCP.Listen.Port", 1, 65535);
        gridData = new GridData();
        tcplisten.setLayoutData(gridData);
        tcplisten.addChangeListener(new ParameterChangeAdapter(){

            @Override
            public void intParameterChanging(Parameter p, int toValue) {
                if (toValue == Constants.INSTANCE_PORT) {
                    toValue = Constants.INSTANCE_PORT + 1;
                    tcplisten.setValue(toValue);
                }
                if (!separate_ports) {
                    COConfigurationManager.setParameter("UDP.Listen.Port", toValue);
                    COConfigurationManager.setParameter("UDP.NonData.Listen.Port", toValue);
                }
            }
        });
        if (separate_ports) {
            label = new Label(cMiniArea, 0);
            Messages.setLanguageText(label, "ConfigView.label.udplistenport");
            gridData = new GridData(128);
            Utils.setLayoutData((Control)label, gridData);
            final IntParameter udp_listen = new IntParameter(cMiniArea, "UDP.Listen.Port", 1, 65535);
            gridData = new GridData();
            udp_listen.setLayoutData(gridData);
            final boolean MULTI_UDP = false;
            udp_listen.addChangeListener(new ParameterChangeAdapter(){

                @Override
                public void intParameterChanging(Parameter p, int toValue) {
                    if (toValue == Constants.INSTANCE_PORT) {
                        toValue = Constants.INSTANCE_PORT + 1;
                        udp_listen.setValue(toValue);
                    }
                    if (!MULTI_UDP) {
                        COConfigurationManager.setParameter("UDP.NonData.Listen.Port", toValue);
                    }
                }
            });
            if (MULTI_UDP) {
                Composite cNonDataUDPArea = new Composite(cSection, 0);
                layout = new GridLayout();
                layout.numColumns = 2;
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                cNonDataUDPArea.setLayout(layout);
                gridData = new GridData(768);
                Utils.setLayoutData((Control)cNonDataUDPArea, gridData);
                final BooleanParameter commonUDP = new BooleanParameter(cNonDataUDPArea, "UDP.NonData.Listen.Port.Same", "ConfigView.section.connection.nondata.udp.same");
                gridData = new GridData();
                gridData.horizontalIndent = 16;
                commonUDP.setLayoutData(gridData);
                final IntParameter non_data_udp_listen = new IntParameter(cNonDataUDPArea, "UDP.NonData.Listen.Port");
                non_data_udp_listen.addChangeListener(new ParameterChangeAdapter(){

                    @Override
                    public void intParameterChanging(Parameter p, int toValue) {
                        if (toValue == Constants.INSTANCE_PORT) {
                            toValue = Constants.INSTANCE_PORT + 1;
                            non_data_udp_listen.setValue(toValue);
                        }
                    }
                });
                udp_listen.addChangeListener(new ParameterChangeAdapter(){

                    @Override
                    public void parameterChanged(Parameter p, boolean caused_internally) {
                        int udp_listen_port;
                        if (commonUDP.isSelected().booleanValue() && (udp_listen_port = udp_listen.getValue()) != Constants.INSTANCE_PORT) {
                            COConfigurationManager.setParameter("UDP.NonData.Listen.Port", udp_listen_port);
                            non_data_udp_listen.setValue(udp_listen_port);
                        }
                    }
                });
                gridData = new GridData();
                non_data_udp_listen.setLayoutData(gridData);
                commonUDP.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(non_data_udp_listen.getControls(), true));
                commonUDP.addChangeListener(new ParameterChangeAdapter(){

                    @Override
                    public void parameterChanged(Parameter p, boolean caused_internally) {
                        if (commonUDP.isSelected().booleanValue()) {
                            int udp_listen_port = COConfigurationManager.getIntParameter("UDP.Listen.Port");
                            if (COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port") != udp_listen_port) {
                                COConfigurationManager.setParameter("UDP.NonData.Listen.Port", udp_listen_port);
                                non_data_udp_listen.setValue(udp_listen_port);
                            }
                        }
                    }
                });
                BooleanParameter enable_tcp = new BooleanParameter(cNonDataUDPArea, "TCP.Listen.Port.Enable", "ConfigView.section.connection.tcp.enable");
                gridData = new GridData();
                enable_tcp.setLayoutData(gridData);
                label = new Label(cNonDataUDPArea, 0);
                BooleanParameter enable_udp = new BooleanParameter(cNonDataUDPArea, "UDP.Listen.Port.Enable", "ConfigView.section.connection.udp.enable");
                gridData = new GridData();
                enable_udp.setLayoutData(gridData);
                label = new Label(cNonDataUDPArea, 0);
                enable_tcp.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(tcplisten));
                enable_udp.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(udp_listen));
            }
        }
        if (userMode > 0) {
            Composite cRandPortArea = new Composite(cMiniArea, 0);
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cRandPortArea.setLayout(layout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)cRandPortArea, gridData);
            BooleanParameter rand_enable = new BooleanParameter(cRandPortArea, "Listen.Port.Randomize.Enable", "ConfigView.section.connection.port.rand.enable");
            label = new Label(cRandPortArea, 0);
            label.setText(MessageText.getString("ConfigView.section.connection.port.rand.range"));
            gridData = new GridData();
            gridData.horizontalIndent = 20;
            Utils.setLayoutData((Control)label, gridData);
            StringParameter rand_range = new StringParameter(cRandPortArea, "Listen.Port.Randomize.Range");
            gridData = new GridData();
            gridData.widthHint = 100;
            rand_range.setLayoutData(gridData);
            BooleanParameter rand_together = new BooleanParameter(cRandPortArea, "Listen.Port.Randomize.Together", "ConfigView.section.connection.port.rand.together");
            rand_enable.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(label));
            rand_enable.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Parameter[]{rand_range, rand_together}));
        }
        if (userMode > 1) {
            BooleanParameter prefer_udp = new BooleanParameter(cMiniArea, "peercontrol.prefer.udp", "ConfigView.section.connection.prefer.udp");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            prefer_udp.setLayoutData(gridData);
        }
        if (userMode < 2) {
            label = new Label(cSection, 0);
            gridData = new GridData();
            Utils.setLayoutData((Control)label, gridData);
            label.setText(MessageText.getString("Utils.link.visit") + ":");
            Label linkLabel = new Label(cSection, 0);
            linkLabel.setText(MessageText.getString("ConfigView.section.connection.serverport.wiki"));
            linkLabel.setData("http://wiki.vuze.com/w/Why_ports_like_6881_are_no_good_choice");
            linkLabel.setCursor(linkLabel.getDisplay().getSystemCursor(21));
            linkLabel.setForeground(Colors.blue);
            gridData = new GridData();
            Utils.setLayoutData((Control)linkLabel, gridData);
            linkLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseDoubleClick(MouseEvent arg0) {
                    Utils.launch((String)((Label)arg0.widget).getData());
                }

                @Override
                public void mouseDown(MouseEvent arg0) {
                    Utils.launch((String)((Label)arg0.widget).getData());
                }
            });
            ClipboardCopy.addCopyToClipMenu(linkLabel);
        }
        if (userMode > 0) {
            Group http_group = new Group(cSection, 0);
            Messages.setLanguageText(http_group, "ConfigView.section.connection.group.http");
            GridLayout http_layout = new GridLayout();
            http_layout.numColumns = 2;
            http_group.setLayout(http_layout);
            gridData = new GridData(768);
            http_group.setLayoutData(gridData);
            label = new Label(http_group, 64);
            Messages.setLanguageText(label, "ConfigView.section.connection.group.http.info");
            new LinkLabel(http_group, "ConfigView.label.please.visit.here", "http://wiki.vuze.com/w/HTTP_Seeding");
            BooleanParameter enable_http = new BooleanParameter((Composite)http_group, "HTTP.Data.Listen.Port.Enable", "ConfigView.section.connection.http.enable");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            enable_http.setLayoutData(gridData);
            label = new Label(http_group, 0);
            Messages.setLanguageText(label, "ConfigView.section.connection.http.port");
            IntParameter http_port = new IntParameter(http_group, "HTTP.Data.Listen.Port");
            gridData = new GridData();
            http_port.setLayoutData(gridData);
            label = new Label(http_group, 0);
            Messages.setLanguageText(label, "ConfigView.section.connection.http.portoverride");
            IntParameter http_port_override = new IntParameter(http_group, "HTTP.Data.Listen.Port.Override");
            gridData = new GridData();
            http_port_override.setLayoutData(gridData);
            enable_http.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(http_port));
            enable_http.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(http_port_override));
        }
        if (userMode > 0) {
            Group ws_group = new Group(cSection, 0);
            Messages.setLanguageText(ws_group, "ConfigView.section.connection.group.webseed");
            GridLayout ws_layout = new GridLayout();
            ws_layout.numColumns = 2;
            ws_group.setLayout(ws_layout);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)ws_group, gridData);
            new BooleanParameter((Composite)ws_group, "webseed.activation.uses.availability", "ConfigView.section.connection.webseed.act.on.avail");
        }
        if (userMode > 0) {
            Group peer_sources_group = new Group(cSection, 0);
            Messages.setLanguageText(peer_sources_group, "ConfigView.section.connection.group.peersources");
            GridLayout peer_sources_layout = new GridLayout();
            peer_sources_group.setLayout(peer_sources_layout);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)peer_sources_group, gridData);
            label = new Label(peer_sources_group, 64);
            Messages.setLanguageText(label, "ConfigView.section.connection.group.peersources.info");
            gridData = new GridData();
            Utils.setLayoutData((Control)label, gridData);
            for (int i = 0; i < PEPeerSource.PS_SOURCES.length; ++i) {
                String p = PEPeerSource.PS_SOURCES[i];
                String config_name = "Peer Source Selection Default." + p;
                String msg_text = "ConfigView.section.connection.peersource." + p;
                BooleanParameter peer_source = new BooleanParameter((Composite)peer_sources_group, config_name, msg_text);
                gridData = new GridData();
                peer_source.setLayoutData(gridData);
            }
            if (userMode > 1) {
                Group networks_group = new Group(cSection, 0);
                Messages.setLanguageText(networks_group, "ConfigView.section.connection.group.networks");
                GridLayout networks_layout = new GridLayout();
                networks_group.setLayout(networks_layout);
                gridData = new GridData(768);
                Utils.setLayoutData((Control)networks_group, gridData);
                label = new Label(networks_group, 0);
                Messages.setLanguageText(label, "ConfigView.section.connection.group.networks.info");
                gridData = new GridData();
                Utils.setLayoutData((Control)label, gridData);
                for (int i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
                    String nn = AENetworkClassifier.AT_NETWORKS[i];
                    String config_name = "Network Selection Default." + nn;
                    String msg_text = "ConfigView.section.connection.networks." + nn;
                    BooleanParameter network = new BooleanParameter((Composite)networks_group, config_name, msg_text);
                    gridData = new GridData();
                    network.setLayoutData(gridData);
                }
                label = new Label(networks_group, 0);
                gridData = new GridData();
                Utils.setLayoutData((Control)label, gridData);
                BooleanParameter network_prompt = new BooleanParameter((Composite)networks_group, "Network Selection Prompt", "ConfigView.section.connection.networks.prompt");
                gridData = new GridData();
                network_prompt.setLayoutData(gridData);
            }
        }
        return cSection;
    }
}

