/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.backup.BackupManager;
import com.aelitis.azureus.core.backup.BackupManagerFactory;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.io.File;
import java.util.Date;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class ConfigSectionBackupRestore
implements UISWTConfigSection {
    @Override
    public String configSectionGetParentSection() {
        return "root";
    }

    @Override
    public String configSectionGetName() {
        return "backuprestore";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.releaseImage("openFolderButton");
    }

    @Override
    public int maxUserMode() {
        return 0;
    }

    @Override
    public Composite configSectionCreate(final Composite parent) {
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image imgOpenFolder = imageLoader.getImage("openFolderButton");
        Composite cBR = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cBR.setLayoutData(gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        cBR.setLayout(layout);
        Label info_label = new Label(cBR, 64);
        Messages.setLanguageText(info_label, "ConfigView.section.br.overview");
        gridData = Utils.getWrappableLabelGridData(1, 256);
        info_label.setLayoutData(gridData);
        Label linkLabel = new Label(cBR, 0);
        linkLabel.setText(MessageText.getString("ConfigView.label.please.visit.here"));
        linkLabel.setData("http://wiki.vuze.com/w/Backup_And_Restore");
        linkLabel.setCursor(linkLabel.getDisplay().getSystemCursor(21));
        linkLabel.setForeground(Colors.blue);
        gridData = Utils.getWrappableLabelGridData(1, 0);
        linkLabel.setLayoutData(gridData);
        linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }
        });
        ClipboardCopy.addCopyToClipMenu(linkLabel);
        final BackupManager backup_manager = BackupManagerFactory.getManager(AzureusCoreFactory.getSingleton());
        Group gBackup = new Group(cBR, 0);
        Messages.setLanguageText(gBackup, "br.backup");
        layout = new GridLayout(2, false);
        gBackup.setLayout(layout);
        gBackup.setLayoutData(new GridData(768));
        Label last_backup_label = new Label(gBackup, 0);
        Messages.setLanguageText(last_backup_label, "br.backup.last.time");
        final Label last_backup_time = new Label(gBackup, 0);
        Label last_backup_error_label = new Label(gBackup, 0);
        Messages.setLanguageText(last_backup_error_label, "br.backup.last.error");
        final Label last_backup_error = new Label(gBackup, 0);
        final Runnable stats_updater = new Runnable(){

            @Override
            public void run() {
                long backup_time = backup_manager.getLastBackupTime();
                last_backup_time.setText(backup_time == 0L ? "" : String.valueOf(new Date(backup_time)));
                last_backup_error.setText(backup_manager.getLastBackupError());
            }
        };
        stats_updater.run();
        Label backup_manual_label = new Label(gBackup, 0);
        Messages.setLanguageText(backup_manual_label, "br.backup.manual.info");
        Button backup_button = new Button(gBackup, 8);
        Messages.setLanguageText(backup_button, "br.backup");
        backup_button.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                String def_dir = COConfigurationManager.getStringParameter("br.backup.folder.default");
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                if (def_dir != null) {
                    dialog.setFilterPath(def_dir);
                }
                dialog.setMessage(MessageText.getString("br.backup.folder.info"));
                dialog.setText(MessageText.getString("br.backup.folder.title"));
                String path = dialog.open();
                if (path != null) {
                    COConfigurationManager.setParameter("br.backup.folder.default", path);
                    ConfigSectionBackupRestore.this.runBackup(backup_manager, path, stats_updater);
                }
            }
        });
        BooleanParameter auto_backup_enable = new BooleanParameter((Composite)gBackup, "br.backup.auto.enable", "br.backup.auto.enable");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        auto_backup_enable.setLayoutData(gridData);
        Composite gDefaultDir = new Composite(gBackup, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 2;
        gDefaultDir.setLayout(layout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gDefaultDir.setLayoutData(gridData);
        Label lblDefaultDir = new Label(gDefaultDir, 0);
        Messages.setLanguageText(lblDefaultDir, "ConfigView.section.file.defaultdir.ask");
        lblDefaultDir.setLayoutData(new GridData());
        gridData = new GridData(768);
        final StringParameter pathParameter = new StringParameter(gDefaultDir, "br.backup.auto.dir", "");
        pathParameter.setLayoutData(gridData);
        if (pathParameter.getValue().length() == 0) {
            String def_dir = COConfigurationManager.getStringParameter("br.backup.folder.default");
            pathParameter.setValue(def_dir);
        }
        Button browse = new Button(gDefaultDir, 8);
        browse.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(browse.getBackground());
        browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        browse.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                dialog.setFilterPath(pathParameter.getValue());
                dialog.setMessage(MessageText.getString("br.backup.auto.dir.select"));
                dialog.setText(MessageText.getString("ConfigView.section.file.defaultdir.ask"));
                String path = dialog.open();
                if (path != null) {
                    pathParameter.setValue(path);
                    COConfigurationManager.setParameter("br.backup.folder.default", path);
                }
            }
        });
        Label lbl_backup_days = new Label(gDefaultDir, 0);
        Messages.setLanguageText(lbl_backup_days, "br.backup.auto.everydays");
        IntParameter backup_everydays = new IntParameter(gDefaultDir, "br.backup.auto.everydays", 1, Integer.MAX_VALUE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        backup_everydays.setLayoutData(gridData);
        Label lbl_backup_retain = new Label(gDefaultDir, 0);
        Messages.setLanguageText(lbl_backup_retain, "br.backup.auto.retain");
        IntParameter backup_retain = new IntParameter(gDefaultDir, "br.backup.auto.retain", 1, Integer.MAX_VALUE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        backup_retain.setLayoutData(gridData);
        BooleanParameter chkNotify = new BooleanParameter(gDefaultDir, "br.backup.notify", "br.backup.notify");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        chkNotify.setLayoutData(gridData);
        Label backup_auto_label = new Label(gDefaultDir, 0);
        Messages.setLanguageText(backup_auto_label, "br.backup.auto.now");
        Button backup_auto_button = new Button(gDefaultDir, 8);
        Messages.setLanguageText(backup_auto_button, "br.test");
        backup_auto_button.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                ConfigSectionBackupRestore.this.runBackup(backup_manager, null, stats_updater);
            }
        });
        auto_backup_enable.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(gDefaultDir));
        Group gRestore = new Group(cBR, 0);
        Messages.setLanguageText(gRestore, "br.restore");
        layout = new GridLayout(2, false);
        gRestore.setLayout(layout);
        gRestore.setLayoutData(new GridData(768));
        Label restore_label = new Label(gRestore, 0);
        Messages.setLanguageText(restore_label, "br.restore.info");
        Button restore_button = new Button(gRestore, 8);
        Messages.setLanguageText(restore_button, "br.restore");
        restore_button.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                String def_dir = COConfigurationManager.getStringParameter("br.backup.folder.default");
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                if (def_dir != null) {
                    dialog.setFilterPath(def_dir);
                }
                dialog.setMessage(MessageText.getString("br.restore.folder.info"));
                dialog.setText(MessageText.getString("br.restore.folder.title"));
                final String path = dialog.open();
                if (path != null) {
                    MessageBoxShell mb = new MessageBoxShell(296, MessageText.getString("br.restore.warning.title"), MessageText.getString("br.restore.warning.info"));
                    mb.setDefaultButtonUsingStyle(256);
                    mb.setParent(parent.getShell());
                    mb.open(new UserPrompterResultListener(){

                        @Override
                        public void prompterClosed(int returnVal) {
                            if (returnVal != 32) {
                                return;
                            }
                            final TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("br.backup.progress"), null, "", true, true);
                            viewer.setEditable(false);
                            viewer.setOKEnabled(false);
                            backup_manager.restore(new File(path), new BackupManager.BackupListener(){

                                @Override
                                public boolean reportProgress(String str) {
                                    return this.append(str, false);
                                }

                                @Override
                                public void reportComplete() {
                                    this.append("Restore Complete!", true);
                                    Utils.execSWTThread(new AERunnable(){

                                        @Override
                                        public void runSupport() {
                                            MessageBoxShell mb = new MessageBoxShell(34, MessageText.getString("ConfigView.section.security.restart.title"), MessageText.getString("ConfigView.section.security.restart.msg"));
                                            mb.setParent(parent.getShell());
                                            mb.open(new UserPrompterResultListener(){

                                                @Override
                                                public void prompterClosed(int returnVal) {
                                                    UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                                                    if (uiFunctions != null) {
                                                        uiFunctions.dispose(true, false);
                                                    }
                                                }
                                            });
                                        }
                                    });
                                }

                                @Override
                                public void reportError(Throwable error) {
                                    this.append("Restore Failed: " + Debug.getNestedExceptionMessage(error), true);
                                }

                                private boolean append(final String str, final boolean complete) {
                                    if (viewer.isDisposed()) {
                                        return false;
                                    }
                                    Utils.execSWTThread(new AERunnable(){

                                        @Override
                                        public void runSupport() {
                                            if (str.endsWith("...")) {
                                                viewer.append(str);
                                            } else {
                                                viewer.append(str + "\r\n");
                                            }
                                            if (complete) {
                                                viewer.setOKEnabled(true);
                                            }
                                        }
                                    });
                                    return true;
                                }
                            });
                            viewer.goModal();
                        }
                    });
                }
            }
        });
        return cBR;
    }

    private void runBackup(BackupManager backup_manager, String path, final Runnable stats_updater) {
        final TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("br.backup.progress"), null, "", true, true);
        viewer.setEditable(false);
        viewer.setOKEnabled(false);
        BackupManager.BackupListener listener = new BackupManager.BackupListener(){

            @Override
            public boolean reportProgress(String str) {
                return this.append(str, false);
            }

            @Override
            public void reportComplete() {
                this.append("Backup Complete!", true);
            }

            @Override
            public void reportError(Throwable error) {
                this.append("Backup Failed: " + Debug.getNestedExceptionMessage(error), true);
            }

            private boolean append(final String str, final boolean complete) {
                if (viewer.isDisposed()) {
                    return false;
                }
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (str.endsWith("...")) {
                            viewer.append(str);
                        } else {
                            viewer.append(str + "\r\n");
                        }
                        if (complete) {
                            viewer.setOKEnabled(true);
                            stats_updater.run();
                        }
                    }
                });
                return true;
            }
        };
        if (path == null) {
            backup_manager.runAutoBackup(listener);
        } else {
            backup_manager.backup(new File(path), listener);
        }
        viewer.goModal();
    }
}

