/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.clientstats;

import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.views.clientstats.ClientStatsDataSource;

public class ColumnCS_ReceivedPer
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "received.per";

    public ColumnCS_ReceivedPer(TableColumn column) {
        column.initialize(2, -2, 80);
        column.addListeners(this);
        column.setType(3);
    }

    @Override
    public void refresh(TableCell cell) {
        ClientStatsDataSource ds = (ClientStatsDataSource)cell.getDataSource();
        if (ds == null || ds.count == 0) {
            return;
        }
        long val = ds.bytesReceived / (long)ds.count;
        if (cell.setSortValue(val) || !cell.isValid()) {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(val));
        }
    }
}

