/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.clientstats;

import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.views.clientstats.ClientStatsDataSource;

public class ColumnCS_Pct
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "percent";

    public ColumnCS_Pct(TableColumn column) {
        column.initialize(2, -2, 50);
        column.addListeners(this);
        column.setType(3);
        column.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        ClientStatsDataSource ds = (ClientStatsDataSource)cell.getDataSource();
        if (ds == null) {
            return;
        }
        float val = (float)ds.count * 1000.0f / (float)ds.overall.count;
        if (cell.setSortValue(val) || !cell.isValid()) {
            cell.setText(DisplayFormatters.formatPercentFromThousands((int)val));
        }
    }
}

