/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.clientstats;

import com.aelitis.azureus.util.MapUtils;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.views.clientstats.ClientStatsDataSource;

public class ColumnCS_Discarded
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "discarded";

    public ColumnCS_Discarded(TableColumn column) {
        column.initialize(2, -2, 80);
        column.addListeners(this);
        column.setType(3);
        String network = column.getUserDataString("network");
        if (network != null) {
            column.setVisible(false);
            column.setNameOverride(network + " " + MessageText.getString("ClientStats.column.discarded"));
        }
    }

    @Override
    public void refresh(TableCell cell) {
        String network;
        ClientStatsDataSource ds = (ClientStatsDataSource)cell.getDataSource();
        if (ds == null) {
            return;
        }
        long val = ds.bytesDiscarded;
        TableColumn column = cell.getTableColumn();
        if (column != null && (network = column.getUserDataString("network")) != null) {
            Map<String, Object> map = ds.perNetworkStats.get(network);
            val = map != null ? MapUtils.getMapLong(map, "bytesDiscarded", 0L) : 0L;
        }
        if (cell.setSortValue(val) || !cell.isValid()) {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(val));
        }
    }
}

