/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.clientstats;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.util.MapUtils;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.views.clientstats.ClientStatsDataSource;
import org.gudy.azureus2.ui.swt.views.clientstats.ClientStatsOverall;
import org.gudy.azureus2.ui.swt.views.clientstats.ColumnCS_Count;
import org.gudy.azureus2.ui.swt.views.clientstats.ColumnCS_Discarded;
import org.gudy.azureus2.ui.swt.views.clientstats.ColumnCS_Name;
import org.gudy.azureus2.ui.swt.views.clientstats.ColumnCS_Pct;
import org.gudy.azureus2.ui.swt.views.clientstats.ColumnCS_Received;
import org.gudy.azureus2.ui.swt.views.clientstats.ColumnCS_ReceivedPer;
import org.gudy.azureus2.ui.swt.views.clientstats.ColumnCS_Sent;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;

public class ClientStatsView
extends TableViewTab<ClientStatsDataSource>
implements TableLifeCycleListener,
GlobalManagerListener,
DownloadManagerPeerListener {
    private static final String CONFIG_FILE = "ClientStats.dat";
    private static final String CONFIG_FILE_ARCHIVE = "ClientStats_%1.dat";
    private static final int BLOOMFILTER_SIZE = 100000;
    private static final int BLOOMFILTER_PEERID_SIZE = 50000;
    private static final String TABLEID = "ClientStats";
    private AzureusCore core;
    private TableViewSWT<ClientStatsDataSource> tv;
    private boolean columnsAdded;
    private final Map<String, ClientStatsDataSource> mapData = new HashMap<String, ClientStatsDataSource>();
    private Composite parent;
    private BloomFilter bloomFilter;
    private BloomFilter bloomFilterPeerId;
    private ClientStatsOverall overall;
    private long startedListeningOn;
    private long totalTime;
    private long lastAdd;
    private GregorianCalendar calendar = new GregorianCalendar();
    private int lastAddMonth;
    private static boolean registered = false;

    public ClientStatsView() {
        super(TABLEID);
        this.initAndLoad();
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                ClientStatsView.this.initColumns(core);
                ClientStatsView.this.register(core);
            }
        });
    }

    @Override
    public Composite initComposite(Composite composite) {
        this.parent = new Composite(composite, 2048);
        this.parent.setLayout(new FormLayout());
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            Utils.setLayoutData((Control)this.parent, new GridData(4, 4, true, true));
        } else if (layout instanceof FormLayout) {
            Utils.setLayoutData((Control)this.parent, Utils.getFilledFormData());
        }
        return this.parent;
    }

    @Override
    public void tableViewTabInitComplete() {
        Composite cTV = (Composite)this.parent.getChildren()[0];
        Composite cBottom = new Composite(this.parent, 0);
        FormData fd = Utils.getFilledFormData();
        fd.bottom = new FormAttachment(cBottom);
        Utils.setLayoutData((Control)cTV, fd);
        fd = Utils.getFilledFormData();
        fd.top = null;
        Utils.setLayoutData((Control)cBottom, fd);
        cBottom.setLayout(new FormLayout());
        Button btnCopy = new Button(cBottom, 8);
        Utils.setLayoutData((Control)btnCopy, new FormData());
        btnCopy.setText("Copy");
        btnCopy.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                TableRowCore[] rows = ClientStatsView.this.tv.getRows();
                StringBuilder sb = new StringBuilder();
                sb.append(new SimpleDateFormat("MMM yyyy").format(new Date()));
                sb.append("\n");
                sb.append("Hits,Client,Bytes Sent,Bytes Received,Bad Bytes\n");
                for (TableRowCore row : rows) {
                    ClientStatsDataSource stat = (ClientStatsDataSource)row.getDataSource();
                    if (stat == null) continue;
                    sb.append(stat.count);
                    sb.append(",");
                    sb.append(stat.client.replaceAll(",", ""));
                    sb.append(",");
                    sb.append(stat.bytesSent);
                    sb.append(",");
                    sb.append(stat.bytesReceived);
                    sb.append(",");
                    sb.append(stat.bytesDiscarded);
                    sb.append("\n");
                }
                ClipboardCopy.copyToClipBoard(sb.toString());
            }
        });
        Button btnCopyShort = new Button(cBottom, 8);
        Utils.setLayoutData((Control)btnCopyShort, new FormData());
        btnCopyShort.setText("Copy > 1%");
        btnCopyShort.addListener(13, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(Event event2) {
                ClientStatsDataSource[] stats2;
                StringBuilder sb = new StringBuilder();
                sb.append(new SimpleDateFormat("MMM ''yy").format(new Date()));
                sb.append("] ");
                sb.append(((ClientStatsView)ClientStatsView.this).overall.count);
                sb.append(": ");
                Map map = ClientStatsView.this.mapData;
                synchronized (map) {
                    stats2 = ClientStatsView.this.mapData.values().toArray(new ClientStatsDataSource[0]);
                }
                Arrays.sort(stats2, new Comparator<ClientStatsDataSource>(){

                    @Override
                    public int compare(ClientStatsDataSource o1, ClientStatsDataSource o2) {
                        if (o1.count == o2.count) {
                            return 0;
                        }
                        return o1.count > o2.count ? -1 : 1;
                    }
                });
                boolean first = true;
                for (ClientStatsDataSource stat : stats2) {
                    int pct = (int)((long)(stat.count * 1000) / ((ClientStatsView)ClientStatsView.this).overall.count);
                    if (pct < 10) continue;
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(DisplayFormatters.formatPercentFromThousands(pct));
                    sb.append(" ");
                    sb.append(stat.client);
                }
                Arrays.sort(stats2, new Comparator<ClientStatsDataSource>(){

                    @Override
                    public int compare(ClientStatsDataSource o1, ClientStatsDataSource o2) {
                        float v1 = (float)o1.bytesReceived / (float)o1.count;
                        float v2 = (float)o2.bytesReceived / (float)o2.count;
                        if (v1 == v2) {
                            return 0;
                        }
                        return v1 > v2 ? -1 : 1;
                    }
                });
                int top = 5;
                first = true;
                sb.append("\nBest Seeders (");
                long total = 0L;
                for (ClientStatsDataSource stat : stats2) {
                    total += stat.bytesReceived;
                }
                sb.append(DisplayFormatters.formatByteCountToKiBEtc(total, false, true, 0));
                sb.append(" Downloaded): ");
                for (ClientStatsDataSource stat : stats2) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(DisplayFormatters.formatByteCountToKiBEtc(stat.bytesReceived / (long)stat.count, false, true, 0));
                    sb.append(" per ");
                    sb.append(stat.client);
                    sb.append("(x");
                    sb.append(stat.count);
                    sb.append(")");
                    if (--top <= 0) break;
                }
                Arrays.sort(stats2, new Comparator<ClientStatsDataSource>(){

                    @Override
                    public int compare(ClientStatsDataSource o1, ClientStatsDataSource o2) {
                        float v1 = (float)o1.bytesDiscarded / (float)o1.count;
                        float v2 = (float)o2.bytesDiscarded / (float)o2.count;
                        if (v1 == v2) {
                            return 0;
                        }
                        return v1 > v2 ? -1 : 1;
                    }
                });
                top = 5;
                first = true;
                sb.append("\nMost Discarded (");
                total = 0L;
                for (ClientStatsDataSource stat : stats2) {
                    total += stat.bytesDiscarded;
                }
                sb.append(DisplayFormatters.formatByteCountToKiBEtc(total, false, true, 0));
                sb.append(" Discarded): ");
                for (ClientStatsDataSource stat : stats2) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(DisplayFormatters.formatByteCountToKiBEtc(stat.bytesDiscarded / (long)stat.count, false, true, 0));
                    sb.append(" per ");
                    sb.append(stat.client);
                    sb.append("(x");
                    sb.append(stat.count);
                    sb.append(")");
                    if (--top <= 0) break;
                }
                Arrays.sort(stats2, new Comparator<ClientStatsDataSource>(){

                    @Override
                    public int compare(ClientStatsDataSource o1, ClientStatsDataSource o2) {
                        float v1 = (float)o1.bytesSent / (float)o1.count;
                        float v2 = (float)o2.bytesSent / (float)o2.count;
                        if (v1 == v2) {
                            return 0;
                        }
                        return v1 > v2 ? -1 : 1;
                    }
                });
                top = 5;
                first = true;
                sb.append("\nMost Fed (");
                total = 0L;
                for (ClientStatsDataSource stat : stats2) {
                    total += stat.bytesSent;
                }
                sb.append(DisplayFormatters.formatByteCountToKiBEtc(total, false, true, 0));
                sb.append(" Sent): ");
                for (ClientStatsDataSource stat : stats2) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(DisplayFormatters.formatByteCountToKiBEtc(stat.bytesSent / (long)stat.count, false, true, 0));
                    sb.append(" per ");
                    sb.append(stat.client);
                    sb.append("(x");
                    sb.append(stat.count);
                    sb.append(")");
                    if (--top <= 0) break;
                }
                ClipboardCopy.copyToClipBoard(sb.toString());
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(btnCopy, 5);
        Utils.setLayoutData((Control)btnCopyShort, fd);
    }

    @Override
    public TableViewSWT<ClientStatsDataSource> initYourTableView() {
        this.tv = TableViewFactory.createTableViewSWT(ClientStatsDataSource.class, TABLEID, this.getPropertiesPrefix(), new TableColumnCore[0], "count", 0x10010002);
        this.tv.addLifeCycleListener(this);
        return this.tv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(AzureusCore core) {
        Class<ClientStatsView> clazz = ClientStatsView.class;
        synchronized (ClientStatsView.class) {
            if (this.columnsAdded) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.columnsAdded = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            UIManager uiManager = PluginInitializer.getDefaultInterface().getUIManager();
            TableManager tableManager = uiManager.getTableManager();
            tableManager.registerColumn(ClientStatsDataSource.class, "name", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Name(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "count", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Count(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "discarded", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Discarded(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "received", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Received(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "received.per", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_ReceivedPer(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "sent", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Sent(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "percent", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Pct(column);
                }
            });
            for (final String network : AENetworkClassifier.AT_NETWORKS) {
                tableManager.registerColumn(ClientStatsDataSource.class, network + "." + "sent", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        column.setUserData("network", network);
                        new ColumnCS_Sent(column);
                    }
                });
                tableManager.registerColumn(ClientStatsDataSource.class, network + "." + "discarded", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        column.setUserData("network", network);
                        new ColumnCS_Discarded(column);
                    }
                });
                tableManager.registerColumn(ClientStatsDataSource.class, network + "." + "received", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        column.setUserData("network", network);
                        new ColumnCS_Received(column);
                    }
                });
                tableManager.registerColumn(ClientStatsDataSource.class, network + "." + "count", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        column.setUserData("network", network);
                        new ColumnCS_Count(column);
                    }
                });
            }
            TableColumnManager tcManager = TableColumnManager.getInstance();
            tcManager.setDefaultColumnNames(TABLEID, new String[]{"name", "percent", "count", "received", "sent", "discarded"});
            return;
        }
    }

    @Override
    public void tableViewDestroyed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAndLoad() {
        Map<String, ClientStatsDataSource> map = this.mapData;
        synchronized (map) {
            Map map2 = FileUtil.readResilientConfigFile(CONFIG_FILE);
            this.totalTime = MapUtils.getMapLong(map2, "time", 0L);
            this.lastAdd = MapUtils.getMapLong(map2, "lastadd", 0L);
            if (this.lastAdd != 0L) {
                this.calendar.setTimeInMillis(this.lastAdd);
                this.lastAddMonth = this.calendar.get(2);
                Map mapBloom = MapUtils.getMapMap(map2, "bloomfilter", null);
                if (mapBloom != null) {
                    this.bloomFilter = BloomFilterFactory.deserialiseFromMap(mapBloom);
                }
                if ((mapBloom = MapUtils.getMapMap(map2, "bloomfilterPeerId", null)) != null) {
                    this.bloomFilterPeerId = BloomFilterFactory.deserialiseFromMap(mapBloom);
                }
            }
            if (this.bloomFilter == null) {
                this.bloomFilter = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(100000), 2);
            }
            if (this.bloomFilterPeerId == null) {
                this.bloomFilterPeerId = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(50000), 2);
            }
            this.overall = new ClientStatsOverall();
            List listSavedData = MapUtils.getMapList(map2, "data", null);
            if (listSavedData != null) {
                for (Object val : listSavedData) {
                    try {
                        Map mapVal = (Map)val;
                        if (mapVal == null) continue;
                        ClientStatsDataSource ds = new ClientStatsDataSource(mapVal);
                        ds.overall = this.overall;
                        if (this.mapData.containsKey(ds.client)) continue;
                        this.mapData.put(ds.client, ds);
                        this.overall.count += (long)ds.count;
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String filename) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, ClientStatsDataSource> map2 = this.mapData;
        synchronized (map2) {
            map.put("data", new ArrayList<ClientStatsDataSource>(this.mapData.values()));
            map.put("bloomfilter", this.bloomFilter.serialiseToMap());
            map.put("bloomfilterPeerId", this.bloomFilterPeerId.serialiseToMap());
            map.put("lastadd", SystemTime.getCurrentTime());
            if (this.startedListeningOn > 0L) {
                map.put("time", this.totalTime + (SystemTime.getCurrentTime() - this.startedListeningOn));
            } else {
                map.put("time", this.totalTime);
            }
        }
        FileUtil.writeResilientConfigFile(filename, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableViewInitialized() {
        Map<String, ClientStatsDataSource> map = this.mapData;
        synchronized (map) {
            if (this.mapData.values().size() > 0) {
                this.tv.addDataSources((ClientStatsDataSource[])this.mapData.values().toArray(new ClientStatsDataSource[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(AzureusCore core) {
        this.core = core;
        core.getGlobalManager().addListener(this);
        Map<String, ClientStatsDataSource> map = this.mapData;
        synchronized (map) {
            this.startedListeningOn = SystemTime.getCurrentTime();
        }
        registered = true;
    }

    @Override
    public void destroyInitiated() {
        if (this.core == null) {
            return;
        }
        this.core.getGlobalManager().removeListener(this);
        List<DownloadManager> downloadManagers = this.core.getGlobalManager().getDownloadManagers();
        for (DownloadManager object : downloadManagers) {
            object.removePeerListener(this);
        }
        registered = false;
        this.save(CONFIG_FILE);
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void downloadManagerAdded(DownloadManager dm) {
        if (!dm.getDownloadState().getFlag(16L)) {
            dm.addPeerListener(this, true);
        }
    }

    @Override
    public void downloadManagerRemoved(DownloadManager dm) {
        dm.removePeerListener(this);
    }

    @Override
    public void seedingStatusChanged(boolean seedingOnlyMode, boolean potentiallySeedingOnlyMode) {
    }

    @Override
    public void peerAdded(PEPeer peer) {
        peer.addListener(new PEPeerListener(){

            @Override
            public void stateChanged(PEPeer peer, int newState) {
                if (newState == 30) {
                    ClientStatsView.this.addPeer(peer);
                } else if (newState == 40 || newState == 50) {
                    peer.removeListener(this);
                }
            }

            @Override
            public void sentBadChunk(PEPeer peer, int pieceNum, int totalBadChunks) {
            }

            @Override
            public void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
            }

            @Override
            public void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPeer(PEPeer peer) {
        byte[] bloomId;
        long now = SystemTime.getCurrentTime();
        byte[] address = null;
        byte[] peerId = peer.getId();
        InetAddress ip = peer.getAlternativeIPv6();
        if (ip == null) {
            try {
                ip = AddressUtils.getByName(peer.getIp());
                address = ip.getAddress();
            }
            catch (Throwable e) {
                String ipString = peer.getIp();
                if (ipString != null) {
                    address = ByteFormatter.intToByteArray(ipString.hashCode());
                }
            }
        } else {
            address = ip.getAddress();
        }
        if (address == null) {
            bloomId = peerId;
        } else {
            bloomId = new byte[8 + address.length];
            System.arraycopy(peerId, 0, bloomId, 0, 8);
            System.arraycopy(address, 0, bloomId, 8, address.length);
        }
        Map<String, ClientStatsDataSource> map = this.mapData;
        synchronized (map) {
            String network;
            PeerItem identity;
            boolean inBloomFilter;
            String id;
            ClientStatsDataSource stat;
            boolean needNew;
            this.calendar.setTimeInMillis(now);
            int thisMonth = this.calendar.get(2);
            if (thisMonth != this.lastAddMonth) {
                if (this.lastAddMonth == 0) {
                    this.lastAddMonth = thisMonth;
                } else {
                    String s = new SimpleDateFormat("yyyy-MM").format(new Date(this.lastAdd));
                    String filename = CONFIG_FILE_ARCHIVE.replace("%1", s);
                    this.save(filename);
                    this.lastAddMonth = thisMonth;
                    this.lastAdd = 0L;
                    this.bloomFilter = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(100000), 2);
                    this.bloomFilterPeerId = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(50000), 2);
                    this.overall = new ClientStatsOverall();
                    this.mapData.clear();
                    if (this.tv != null) {
                        this.tv.removeAllTableRows();
                    }
                    this.totalTime = 0L;
                    this.startedListeningOn = 0L;
                }
            }
            boolean bl = needNew = (stat = this.mapData.get(id = this.getID(peer))) == null;
            if (needNew) {
                stat = new ClientStatsDataSource();
                stat.overall = this.overall;
                stat.client = id;
                this.mapData.put(id, stat);
            }
            boolean bl2 = inBloomFilter = this.bloomFilter.contains(bloomId) || this.bloomFilterPeerId.contains(peerId);
            if (!inBloomFilter) {
                this.bloomFilter.add(bloomId);
                this.bloomFilterPeerId.add(peerId);
                this.lastAdd = now;
                ClientStatsOverall clientStatsOverall = this.overall;
                synchronized (clientStatsOverall) {
                    ++this.overall.count;
                }
                ++stat.count;
            }
            ++stat.current;
            long existingBytesReceived = peer.getStats().getTotalDataBytesReceived();
            long existingBytesSent = peer.getStats().getTotalDataBytesSent();
            long existingBytesDiscarded = peer.getStats().getTotalBytesDiscarded();
            if (existingBytesReceived > 0L) {
                stat.bytesReceived -= existingBytesReceived;
                if (stat.bytesReceived < 0L) {
                    stat.bytesReceived = 0L;
                }
            }
            if (existingBytesSent > 0L) {
                stat.bytesSent -= existingBytesSent;
                if (stat.bytesSent < 0L) {
                    stat.bytesSent = 0L;
                }
            }
            if (existingBytesDiscarded > 0L) {
                stat.bytesDiscarded -= existingBytesDiscarded;
                if (stat.bytesDiscarded < 0L) {
                    stat.bytesDiscarded = 0L;
                }
            }
            if (peer instanceof PEPeerTransport && (identity = ((PEPeerTransport)peer).getPeerItemIdentity()) != null && (network = identity.getNetwork()) != null) {
                Map<String, Object> map2 = stat.perNetworkStats.get(network);
                if (map2 == null) {
                    map2 = new HashMap<String, Object>();
                    stat.perNetworkStats.put(network, map2);
                }
                if (!inBloomFilter) {
                    long count = MapUtils.getMapLong(map2, "count", 0L);
                    map2.put("count", count + 1L);
                }
                if (existingBytesReceived > 0L) {
                    long bytesReceived = MapUtils.getMapLong(map2, "bytesReceived", 0L);
                    if ((bytesReceived -= existingBytesReceived) < 0L) {
                        bytesReceived = 0L;
                    }
                    map2.put("bytesReceived", bytesReceived);
                }
                if (existingBytesSent > 0L) {
                    long bytesSent = MapUtils.getMapLong(map2, "bytesSent", 0L);
                    if ((bytesSent -= existingBytesSent) < 0L) {
                        bytesSent = 0L;
                    }
                    map2.put("bytesSent", bytesSent);
                }
                if (existingBytesDiscarded > 0L) {
                    long bytesDiscarded = MapUtils.getMapLong(map2, "bytesDiscarded", 0L);
                    if ((bytesDiscarded -= existingBytesDiscarded) < 0L) {
                        bytesDiscarded = 0L;
                    }
                    map2.put("bytesDiscarded", bytesDiscarded);
                }
            }
            if (this.tv != null) {
                if (needNew) {
                    this.tv.addDataSource(stat);
                } else {
                    TableRowCore row = this.tv.getRow(stat);
                    if (row != null) {
                        row.invalidate();
                    }
                }
            }
        }
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager manager) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerRemoved(PEPeer peer) {
        Map<String, ClientStatsDataSource> map = this.mapData;
        synchronized (map) {
            ClientStatsDataSource stat = this.mapData.get(this.getID(peer));
            if (peer.getStats().getTotalDataBytesSent() > 0L && stat != null) {
                TableRowCore row;
                PeerItem identity;
                --stat.current;
                String network = null;
                if (peer instanceof PEPeerTransport && (identity = ((PEPeerTransport)peer).getPeerItemIdentity()) != null) {
                    network = identity.getNetwork();
                }
                stat.bytesReceived += peer.getStats().getTotalDataBytesReceived();
                stat.bytesSent += peer.getStats().getTotalDataBytesSent();
                stat.bytesDiscarded += peer.getStats().getTotalBytesDiscarded();
                if (network != null) {
                    Map<String, Object> map2 = stat.perNetworkStats.get(network);
                    if (map2 == null) {
                        map2 = new HashMap<String, Object>();
                        stat.perNetworkStats.put(network, map2);
                    }
                    long bytesReceived = MapUtils.getMapLong(map2, "bytesReceived", 0L);
                    map2.put("bytesReceived", bytesReceived + peer.getStats().getTotalDataBytesReceived());
                    long bytesSent = MapUtils.getMapLong(map2, "bytesSent", 0L);
                    map2.put("bytesSent", bytesSent + peer.getStats().getTotalDataBytesSent());
                    long bytesDiscarded = MapUtils.getMapLong(map2, "bytesDiscarded", 0L);
                    map2.put("bytesDiscarded", bytesDiscarded + peer.getStats().getTotalBytesDiscarded());
                }
                if (this.tv != null && (row = this.tv.getRow(stat)) != null) {
                    row.invalidate();
                }
            }
        }
    }

    private String getID(PEPeer peer) {
        String s = peer.getClientNameFromPeerID();
        if (s == null && (s = peer.getClient()).startsWith("HTTP Seed")) {
            return "HTTP Seed";
        }
        return s.replaceAll(" v?[0-9._]+", "");
    }
}

