/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeListener;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.ui.UIFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.views.utils.TagButtonsUI;
import org.gudy.azureus2.ui.swt.views.utils.TagUIUtils;

public class TaggingView
implements UISWTViewCoreEventListener,
TagTypeListener {
    public static final String MSGID_PREFIX = "TaggingView";
    private UISWTView swtView;
    private Composite cMainComposite;
    private ScrolledComposite sc;
    private List<Taggable> taggables;
    private Composite parent;
    private TagButtonsUI tagButtonsUI;

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.parent = (Composite)event2.getData();
                break;
            }
            case 6: {
                Messages.updateLanguageForControl(this.cMainComposite);
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                Object ds = event2.getData();
                this.dataSourceChanged(ds);
                break;
            }
            case 3: {
                this.initialize();
                if (this.taggables != null) break;
                this.dataSourceChanged(this.swtView.getDataSource());
                break;
            }
            case 4: {
                this.delete();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private void delete() {
        Utils.disposeComposite(this.sc);
        this.dataSourceChanged(null);
    }

    private void refresh() {
    }

    private void dataSourceChanged(Object ds) {
        boolean isNull;
        boolean wasNull;
        boolean bl = wasNull = this.taggables == null;
        if (ds instanceof Taggable) {
            this.taggables = new ArrayList<Taggable>();
            this.taggables.add((Taggable)ds);
        } else if (ds instanceof Taggable[]) {
            this.taggables = new ArrayList<Taggable>();
            this.taggables.addAll(Arrays.asList((Taggable[])ds));
        } else if (ds instanceof Object[]) {
            Object[] objects;
            this.taggables = new ArrayList<Taggable>();
            for (Object o : objects = (Object[])ds) {
                DownloadManager temp;
                if (o instanceof Taggable) {
                    Taggable taggable = (Taggable)o;
                    if (this.taggables.contains(taggable)) continue;
                    this.taggables.add(taggable);
                    continue;
                }
                if (!(o instanceof DiskManagerFileInfo) || (temp = ((DiskManagerFileInfo)o).getDownloadManager()) == null || this.taggables.contains(temp)) continue;
                this.taggables.add(temp);
            }
            if (this.taggables.size() == 0) {
                this.taggables = null;
            }
        } else {
            this.taggables = null;
        }
        boolean bl2 = isNull = this.taggables == null;
        if (isNull != wasNull) {
            TagManager tm = TagManagerFactory.getTagManager();
            TagType tagType = tm.getTagType(3);
            if (isNull) {
                tagType.removeTagTypeListener(this);
            } else {
                tagType.addTagTypeListener(this, false);
            }
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                TaggingView.this.swt_updateFields();
            }
        });
    }

    private void initialize() {
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            if (this.parent == null || this.parent.isDisposed()) {
                return;
            }
            this.sc = new ScrolledComposite(this.parent, 512);
            this.sc.setExpandHorizontal(true);
            this.sc.setExpandVertical(true);
            this.sc.getVerticalBar().setIncrement(16);
            Layout parentLayout = this.parent.getLayout();
            if (parentLayout instanceof GridLayout) {
                GridData gd = new GridData(4, 4, true, true);
                this.sc.setLayoutData(gd);
            } else if (parentLayout instanceof FormLayout) {
                this.sc.setLayoutData(Utils.getFilledFormData());
            }
            this.cMainComposite = new Composite(this.sc, 0);
            this.sc.setContent(this.cMainComposite);
        } else {
            Utils.disposeComposite(this.cMainComposite, false);
        }
        this.cMainComposite.setLayout(new GridLayout(1, false));
        TagManager tm = TagManagerFactory.getTagManager();
        int[] tagTypesWanted = new int[]{3};
        this.tagButtonsUI = new TagButtonsUI();
        ArrayList<Tag> listAllTags = new ArrayList<Tag>();
        for (int tagType : tagTypesWanted) {
            TagType tt = tm.getTagType(tagType);
            List<Tag> tags = tt.getTags();
            listAllTags.addAll(tags);
        }
        this.tagButtonsUI.buildTagGroup(listAllTags, this.cMainComposite, new TagButtonsUI.TagButtonTrigger(){

            @Override
            public void tagButtonTriggered(Tag tag, boolean doTag) {
                for (Taggable taggable : TaggingView.this.taggables) {
                    if (doTag) {
                        tag.addTaggable(taggable);
                    } else {
                        tag.removeTaggable(taggable);
                    }
                    TaggingView.this.swt_updateFields();
                }
            }
        });
        Button buttonAdd = new Button(this.cMainComposite, 8);
        buttonAdd.setLayoutData(new GridData(0x1000000, 4, false, false));
        Messages.setLanguageText(buttonAdd, "label.add.tag");
        buttonAdd.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TagUIUtils.createManualTag(new UIFunctions.TagReturner(){

                    @Override
                    public void returnedTags(Tag[] tags) {
                        if (TaggingView.this.taggables == null) {
                            return;
                        }
                        for (Tag tag : tags) {
                            for (Taggable taggable : TaggingView.this.taggables) {
                                tag.addTaggable(taggable);
                            }
                        }
                    }
                });
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.sc.addControlListener(new ControlAdapter(){

            @Override
            public void controlResized(ControlEvent e) {
                Rectangle r = TaggingView.this.sc.getClientArea();
                Point size = TaggingView.this.cMainComposite.computeSize(r.width, -1);
                TaggingView.this.sc.setMinSize(size);
            }
        });
        this.swt_updateFields();
        Rectangle r = this.sc.getClientArea();
        Point size = this.cMainComposite.computeSize(r.width, -1);
        this.sc.setMinSize(size);
    }

    private String getFullTitle() {
        return MessageText.getString("label.tags");
    }

    private void swt_updateFields() {
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            return;
        }
        if (this.tagButtonsUI.updateFields(this.taggables)) {
            this.parent.layout();
        }
    }

    @Override
    public void tagTypeChanged(TagType tag_type) {
    }

    @Override
    public void tagEventOccurred(TagTypeListener.TagEvent event2) {
        int type = event2.getEventType();
        Tag tag = event2.getTag();
        if (type == 0) {
            this.tagAdded(tag);
        } else if (type == 1) {
            this.tagChanged(tag);
        } else if (type == 2) {
            this.tagRemoved(tag);
        }
    }

    public void tagAdded(Tag tag) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                TaggingView.this.initialize();
            }
        });
    }

    public void tagChanged(Tag changedTag) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                TaggingView.this.swt_updateFields();
            }
        });
    }

    public void tagRemoved(Tag tag) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                TaggingView.this.initialize();
            }
        });
    }
}

