/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.proxy.AEProxySelector;
import com.aelitis.azureus.core.proxy.AEProxySelectorFactory;
import com.aelitis.azureus.plugins.I2PHelpers;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerController;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.views.ViewUtils;

public class PrivacyView
implements UISWTViewCoreEventListener,
DownloadManagerStateAttributeListener {
    public static final String MSGID_PREFIX = "PrivacyView";
    private UISWTView swtView;
    private Composite cMainComposite;
    private ScrolledComposite sc;
    private Composite parent;
    private static final int PL_PUBLIC = 0;
    private static final int PL_MIX = 1;
    private static final int PL_ANONYMOUS = 2;
    private static final int PL_INVALID = 3;
    private int privacy_level;
    private Scale privacy_scale;
    private boolean i2p_install_prompted;
    private Composite i2p_lookup_comp;
    private Button i2p_install_button;
    private Button i2p_lookup_button;
    private Label i2p_options_link;
    private BufferedLabel i2p_result_summary;
    private Text i2p_result_list;
    private Button[] network_buttons;
    private Button[] source_buttons;
    private Button ipfilter_enabled;
    private BufferedLabel peer_info;
    private BufferedLabel torrent_info;
    private BufferedLabel tracker_info;
    private BufferedLabel webseed_info;
    private BufferedLabel vpn_info;
    private BufferedLabel socks_state;
    private BufferedLabel socks_current;
    private BufferedLabel socks_fails;
    private Label socks_more;
    private DownloadManager current_dm;
    private Set<String> enabled_networks = new HashSet<String>();
    private Set<String> enabled_sources = new HashSet<String>();

    private String getFullTitle() {
        return MessageText.getString("label.privacy");
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.parent = (Composite)event2.getData();
                break;
            }
            case 6: {
                Messages.updateLanguageForControl(this.cMainComposite);
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                Object ds = event2.getData();
                this.dataSourceChanged(ds);
                break;
            }
            case 3: {
                this.initialize();
                if (this.current_dm != null) break;
                this.dataSourceChanged(this.swtView.getDataSource());
                break;
            }
            case 4: {
                this.delete();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private void delete() {
        Utils.disposeComposite(this.sc);
        this.dataSourceChanged(null);
    }

    private void refresh() {
        this.updatePeersEtc(this.current_dm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataSourceChanged(Object newDataSource) {
        PrivacyView privacyView = this;
        synchronized (privacyView) {
            DownloadManager new_dm = ViewUtils.getDownloadManagerFromDataSource(newDataSource);
            if (new_dm == this.current_dm) {
                return;
            }
            final DownloadManager f_old_dm = this.current_dm;
            final DownloadManager f_new_dm = this.current_dm = new_dm;
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    PrivacyView.this.swt_updateFields(f_old_dm, f_new_dm);
                }
            });
        }
    }

    private void initialize() {
        GridData gd;
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            if (this.parent == null || this.parent.isDisposed()) {
                return;
            }
            this.sc = new ScrolledComposite(this.parent, 512);
            this.sc.setExpandHorizontal(true);
            this.sc.setExpandVertical(true);
            this.sc.getVerticalBar().setIncrement(16);
            Layout parentLayout = this.parent.getLayout();
            if (parentLayout instanceof GridLayout) {
                gd = new GridData(4, 4, true, true);
                Utils.setLayoutData((Control)this.sc, gd);
            } else if (parentLayout instanceof FormLayout) {
                Utils.setLayoutData((Control)this.sc, Utils.getFilledFormData());
            }
            this.cMainComposite = new Composite(this.sc, 0);
            this.sc.setContent(this.cMainComposite);
        } else {
            Utils.disposeComposite(this.cMainComposite, false);
        }
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.cMainComposite.setLayout(layout);
        Composite overview_comp = new Composite(this.cMainComposite, 0);
        overview_comp.setLayout(new GridLayout(3, false));
        gd = new GridData(768);
        Utils.setLayoutData((Control)overview_comp, gd);
        Label label = new Label(overview_comp, 0);
        label.setText(MessageText.getString("privacy.view.intro"));
        LinkLabel link = new LinkLabel(overview_comp, "label.read.more", MessageText.getString("privacy.view.wiki.url"));
        Composite slider_comp = new Composite(this.cMainComposite, 0);
        layout = new GridLayout(3, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        slider_comp.setLayout(layout);
        gd = new GridData(768);
        Utils.setLayoutData((Control)slider_comp, gd);
        label = new Label(slider_comp, 0);
        label.setText(MessageText.getString("privacy.view.level") + ":");
        Composite slider2_comp = new Composite(slider_comp, 0);
        slider2_comp.setLayout(new GridLayout(6, true));
        gd = new GridData(768);
        Utils.setLayoutData((Control)slider2_comp, gd);
        label = new Label(slider2_comp, 0);
        label.setText(MessageText.getString("privacy.view.public.only"));
        label = new Label(slider2_comp, 0);
        label.setText(MessageText.getString("privacy.view.public.anon"));
        label.setAlignment(0x1000000);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        Utils.setLayoutData((Control)label, gd);
        label = new Label(slider2_comp, 0);
        label.setText(MessageText.getString("privacy.view.anon.only"));
        label.setAlignment(0x1000000);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        Utils.setLayoutData((Control)label, gd);
        label = new Label(slider2_comp, 0);
        label.setText(MessageText.getString("label.invalid"));
        gd = new GridData(768);
        gd.horizontalAlignment = 0x1000008;
        Utils.setLayoutData((Control)label, gd);
        this.privacy_scale = new Scale(slider2_comp, 256);
        gd = new GridData(768);
        gd.horizontalSpan = 6;
        Utils.setLayoutData((Control)this.privacy_scale, gd);
        this.privacy_scale.setMinimum(0);
        this.privacy_scale.setMaximum(30);
        final boolean[] slider_mouse_down = new boolean[]{false};
        this.privacy_scale.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                int pos = PrivacyView.this.privacy_scale.getSelection();
                int level = (pos + 5) / 10;
                if (level * 10 != pos) {
                    PrivacyView.this.privacy_scale.setSelection(level * 10);
                }
                PrivacyView.this.setPrivacyLevel(level);
                slider_mouse_down[0] = false;
            }

            @Override
            public void mouseDown(MouseEvent e) {
                slider_mouse_down[0] = true;
            }
        });
        this.privacy_scale.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                if (!slider_mouse_down[0]) {
                    int pos = PrivacyView.this.privacy_scale.getSelection();
                    int level = (pos + 5) / 10;
                    PrivacyView.this.setPrivacyLevel(level);
                }
            }
        });
        Composite network_comp = new Composite(slider_comp, 0);
        gd = new GridData();
        Utils.setLayoutData((Control)network_comp, gd);
        this.network_buttons = new Button[AENetworkClassifier.AT_NETWORKS.length];
        network_comp.setLayout(new GridLayout(1, false));
        label = new Label(network_comp, 0);
        label.setText(MessageText.getString("ConfigView.section.connection.group.networks") + ":");
        for (int i = 0; i < this.network_buttons.length; ++i) {
            final String nn = AENetworkClassifier.AT_NETWORKS[i];
            String msg_text = "ConfigView.section.connection.networks." + nn;
            Button button = new Button(network_comp, 32);
            Messages.setLanguageText(button, msg_text);
            this.network_buttons[i] = button;
            button.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    boolean selected = ((Button)e.widget).getSelection();
                    if (PrivacyView.this.current_dm != null) {
                        PrivacyView.this.current_dm.getDownloadState().setNetworkEnabled(nn, selected);
                    }
                }
            });
            GridData gridData = new GridData();
            Utils.setLayoutData((Control)button, gridData);
        }
        label = new Label(slider_comp, 0);
        final Composite tracker_webseed_comp = new Composite(slider_comp, 0);
        layout = new GridLayout(2, true);
        layout.marginRight = 1;
        layout.marginLeft = 1;
        layout.marginBottom = 1;
        layout.marginTop = 1;
        tracker_webseed_comp.setLayout(layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        Utils.setLayoutData((Control)tracker_webseed_comp, gd);
        tracker_webseed_comp.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                Rectangle client_area = tracker_webseed_comp.getClientArea();
                Rectangle rect = new Rectangle(0, 0, client_area.width - 1, client_area.height - 1);
                e.gc.setAlpha(50);
                e.gc.drawRectangle(rect);
            }
        });
        Composite tracker_comp = new Composite(tracker_webseed_comp, 0);
        gd = new GridData(768);
        Utils.setLayoutData((Control)tracker_comp, gd);
        tracker_comp.setLayout(new GridLayout(2, false));
        label = new Label(tracker_comp, 0);
        label.setText(MessageText.getString("label.trackers") + ":");
        this.tracker_info = new BufferedLabel(tracker_comp, 0x20000000);
        gd = new GridData(768);
        Utils.setLayoutData(this.tracker_info, gd);
        Composite webseed_comp = new Composite(tracker_webseed_comp, 0);
        gd = new GridData(768);
        Utils.setLayoutData((Control)webseed_comp, gd);
        webseed_comp.setLayout(new GridLayout(2, false));
        label = new Label(webseed_comp, 0);
        label.setText(MessageText.getString("label.webseeds") + ":");
        this.webseed_info = new BufferedLabel(webseed_comp, 0x20000000);
        gd = new GridData(768);
        Utils.setLayoutData(this.webseed_info, gd);
        Composite peer_comp = new Composite(tracker_webseed_comp, 0);
        gd = new GridData(768);
        Utils.setLayoutData((Control)peer_comp, gd);
        peer_comp.setLayout(new GridLayout(2, false));
        label = new Label(peer_comp, 0);
        label.setText(MessageText.getString("TableColumn.header.peers") + ":");
        this.peer_info = new BufferedLabel(peer_comp, 0x20000000);
        gd = new GridData(768);
        Utils.setLayoutData(this.peer_info, gd);
        Group i2p_group = new Group(this.cMainComposite, 0);
        i2p_group.setText("I2P");
        gd = new GridData(768);
        Utils.setLayoutData((Control)i2p_group, gd);
        i2p_group.setLayout(new GridLayout(4, false));
        label = new Label(i2p_group, 0);
        label.setText(MessageText.getString("privacy.view.lookup.info"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        Utils.setLayoutData((Control)label, gd);
        label = new Label(i2p_group, 0);
        label.setText(MessageText.getString("label.lookup.status") + ":");
        this.i2p_result_summary = new BufferedLabel(i2p_group, 0x20000000);
        gd = new GridData(768);
        Utils.setLayoutData(this.i2p_result_summary, gd);
        Composite i2p_button_comp = new Composite(i2p_group, 0);
        i2p_button_comp.setLayout(new GridLayout(2, false));
        gd = new GridData(1040);
        Utils.setLayoutData((Control)i2p_button_comp, gd);
        label = new Label(i2p_button_comp, 0);
        label.setText(MessageText.getString("GeneralView.section.availability"));
        this.i2p_install_button = new Button(i2p_button_comp, 8);
        this.i2p_install_button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event2) {
                boolean[] result = new boolean[]{false};
                I2PHelpers.installI2PHelper(null, result, new Runnable(){

                    @Override
                    public void run() {
                        Utils.execSWTThread(new Runnable(){

                            @Override
                            public void run() {
                                PrivacyView.this.updateI2PState();
                            }
                        });
                    }
                });
            }
        });
        this.i2p_lookup_comp = new Composite(i2p_group, 2048);
        gd = new GridData();
        gd.widthHint = 300;
        gd.heightHint = 150;
        Utils.setLayoutData((Control)this.i2p_lookup_comp, gd);
        this.i2p_lookup_comp.setBackground(Colors.white);
        this.i2p_result_list = new Text(i2p_group, 526920);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        Utils.setLayoutData((Control)this.i2p_result_list, gd);
        this.i2p_result_list.setEditable(false);
        label = new Label(i2p_button_comp, 0);
        label.setText(MessageText.getString("button.lookup.peers"));
        this.i2p_lookup_button = new Button(i2p_button_comp, 8);
        this.i2p_lookup_button.setText(MessageText.getString("button.search.dht"));
        this.i2p_lookup_button.addSelectionListener(new SelectionAdapter(){
            private int search_count;

            @Override
            public void widgetSelected(SelectionEvent event2) {
                Utils.disposeComposite(PrivacyView.this.i2p_lookup_comp, false);
                PrivacyView.this.i2p_result_summary.setText("");
                PrivacyView.this.i2p_result_list.setText("");
                PluginInterface i2p_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azneti2phelper", true);
                if (i2p_pi != null) {
                    IPCInterface ipc = i2p_pi.getIPC();
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("server_id", "Scraper");
                    options.put("server_id_transient", true);
                    options.put("ui_composite", PrivacyView.this.i2p_lookup_comp);
                    final byte[] hash = (byte[])PrivacyView.this.i2p_lookup_button.getData("hash");
                    ++this.search_count;
                    final int search_id = this.search_count;
                    IPCInterface callback = new IPCInterface(){

                        @Override
                        public Object invoke(String methodName, final Object[] params) throws IPCException {
                            if (search_id != search_count) {
                                return null;
                            }
                            if (methodName.equals("statusUpdate")) {
                                final int status = (Integer)params[0];
                                if (status != 9 && status != 4) {
                                    Utils.execSWTThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (PrivacyView.this.i2p_lookup_button.isDisposed() || hash != PrivacyView.this.i2p_lookup_button.getData("hash")) {
                                                return;
                                            }
                                            PrivacyView.this.i2p_lookup_button.setEnabled(true);
                                            if (PrivacyView.this.i2p_result_list.getText().length() == 0 && status != 8) {
                                                PrivacyView.this.i2p_result_summary.setText(MessageText.getString("label.no.peers.found"));
                                            }
                                        }
                                    });
                                }
                                if (params.length == 4) {
                                    Utils.execSWTThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (PrivacyView.this.i2p_result_summary.isDisposed() || hash != PrivacyView.this.i2p_lookup_button.getData("hash")) {
                                                return;
                                            }
                                            int seeds = (Integer)params[1];
                                            int leechers = (Integer)params[2];
                                            int peers = (Integer)params[3];
                                            PrivacyView.this.i2p_result_summary.setText(MessageText.getString("privacy.view.lookup.msg", new String[]{String.valueOf(seeds), String.valueOf(leechers), String.valueOf(peers)}));
                                        }
                                    });
                                }
                            } else if (methodName.equals("msgUpdate")) {
                                Utils.execSWTThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (PrivacyView.this.i2p_result_summary.isDisposed() || hash != PrivacyView.this.i2p_lookup_button.getData("hash")) {
                                            return;
                                        }
                                        String msg = (String)params[0];
                                        PrivacyView.this.i2p_result_summary.setText(msg);
                                    }
                                });
                            } else if (methodName.equals("peerFound")) {
                                Utils.execSWTThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (PrivacyView.this.i2p_result_list.isDisposed() || hash != PrivacyView.this.i2p_lookup_button.getData("hash")) {
                                            return;
                                        }
                                        String host = (String)params[0];
                                        int peer_type = (Integer)params[1];
                                        PrivacyView.this.i2p_result_list.append(host + "\r\n");
                                    }
                                });
                            }
                            return null;
                        }

                        @Override
                        public boolean canInvoke(String methodName, Object[] params) {
                            return true;
                        }
                    };
                    PrivacyView.this.i2p_lookup_button.setEnabled(false);
                    PrivacyView.this.i2p_result_summary.setText(MessageText.getString("label.searching"));
                    try {
                        ipc.invoke("lookupTorrent", new Object[]{"", hash, options, callback});
                    }
                    catch (Throwable e) {
                        PrivacyView.this.i2p_lookup_button.setEnabled(true);
                        e.printStackTrace();
                    }
                }
            }
        });
        Label i2p_options_info = new Label(i2p_button_comp, 64);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 150;
        Utils.setLayoutData((Control)i2p_options_info, gd);
        i2p_options_info.setText(MessageText.getString("privacy.view.check.bw.info"));
        if (!COConfigurationManager.getBooleanParameter("privacy.view.check.bw.clicked", false)) {
            FontData fontData = i2p_options_info.getFont().getFontData()[0];
            final Font bold_font = new Font((Device)i2p_options_info.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 1));
            i2p_options_info.setFont(bold_font);
            i2p_options_info.addDisposeListener(new DisposeListener(){

                @Override
                public void widgetDisposed(DisposeEvent e) {
                    bold_font.dispose();
                }
            });
        }
        this.i2p_options_link = new Label(i2p_button_comp, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        Utils.setLayoutData((Control)this.i2p_options_link, gd);
        this.i2p_options_link.setText(MessageText.getString("privacy.view.check.bw"));
        this.i2p_options_link.setCursor(this.i2p_options_link.getDisplay().getSystemCursor(21));
        this.i2p_options_link.setForeground(Colors.blue);
        this.i2p_options_link.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
                this.openOptions();
            }

            @Override
            public void mouseUp(MouseEvent arg0) {
                this.openOptions();
            }

            private void openOptions() {
                COConfigurationManager.setParameter("privacy.view.check.bw.clicked", true);
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.openView(4, "azi2phelper.name");
                }
            }
        });
        this.updateI2PState();
        Utils.makeButtonsEqualWidth(Arrays.asList(this.i2p_install_button, this.i2p_lookup_button));
        label = new Label(i2p_button_comp, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        Utils.setLayoutData((Control)label, gd);
        Group bottom_comp = new Group(this.cMainComposite, 0);
        gd = new GridData(768);
        Utils.setLayoutData((Control)bottom_comp, gd);
        bottom_comp.setLayout(new GridLayout(2, false));
        label = new Label(bottom_comp, 0);
        label.setText(MessageText.getString("authenticator.torrent") + ":");
        Composite torrent_comp = new Composite(bottom_comp, 0);
        gd = new GridData(768);
        Utils.setLayoutData((Control)torrent_comp, gd);
        torrent_comp.setLayout(this.removeMarginsAndSpacing(new GridLayout(2, false)));
        this.torrent_info = new BufferedLabel(torrent_comp, 0x20000000);
        gd = new GridData(768);
        Utils.setLayoutData(this.torrent_info, gd);
        label = new Label(bottom_comp, 0);
        label.setText(MessageText.getString("ConfigView.section.connection.group.peersources") + ":");
        Composite sources_comp = new Composite(bottom_comp, 0);
        gd = new GridData(768);
        Utils.setLayoutData((Control)sources_comp, gd);
        this.source_buttons = new Button[PEPeerSource.PS_SOURCES.length];
        sources_comp.setLayout(this.removeMargins(new GridLayout(this.source_buttons.length + 1, false)));
        for (int i = 0; i < this.source_buttons.length; ++i) {
            final String src = PEPeerSource.PS_SOURCES[i];
            String msg_text = "ConfigView.section.connection.peersource." + src;
            Button button = new Button(sources_comp, 32);
            Messages.setLanguageText(button, msg_text);
            this.source_buttons[i] = button;
            button.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    boolean selected = ((Button)e.widget).getSelection();
                    if (PrivacyView.this.current_dm != null) {
                        PrivacyView.this.current_dm.getDownloadState().setPeerSourceEnabled(src, selected);
                    }
                }
            });
            GridData gridData = new GridData();
            Utils.setLayoutData((Control)button, gridData);
        }
        label = new Label(bottom_comp, 0);
        label.setText(MessageText.getString("label.ip.filter") + ":");
        Composite ipfilter_comp = new Composite(bottom_comp, 0);
        gd = new GridData(768);
        Utils.setLayoutData((Control)ipfilter_comp, gd);
        ipfilter_comp.setLayout(this.removeMargins(new GridLayout(2, false)));
        this.ipfilter_enabled = new Button(ipfilter_comp, 32);
        this.ipfilter_enabled.setText(MessageText.getString("devices.contextmenu.od.enabled"));
        this.ipfilter_enabled.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PrivacyView.this.current_dm.getDownloadState().setFlag(256L, !PrivacyView.this.ipfilter_enabled.getSelection());
            }
        });
        gd = new GridData(768);
        Utils.setLayoutData((Control)this.ipfilter_enabled, gd);
        label = new Label(bottom_comp, 0);
        label.setText(MessageText.getString("label.vpn.status") + ":");
        Composite vpn_comp = new Composite(bottom_comp, 0);
        gd = new GridData(768);
        Utils.setLayoutData((Control)vpn_comp, gd);
        vpn_comp.setLayout(this.removeMargins(new GridLayout(2, false)));
        this.vpn_info = new BufferedLabel(vpn_comp, 0x20000000);
        gd = new GridData(768);
        Utils.setLayoutData(this.vpn_info, gd);
        label = new Label(bottom_comp, 0);
        label.setText(MessageText.getString("label.socks.status") + ":");
        Composite socks_comp = new Composite(bottom_comp, 0);
        gd = new GridData(768);
        Utils.setLayoutData((Control)socks_comp, gd);
        socks_comp.setLayout(this.removeMargins(new GridLayout(10, false)));
        label = new Label(socks_comp, 0);
        label.setText(MessageText.getString("label.proxy") + ":");
        this.socks_state = new BufferedLabel(socks_comp, 0x20000000);
        gd = new GridData();
        gd.widthHint = 120;
        Utils.setLayoutData(this.socks_state, gd);
        label = new Label(socks_comp, 0);
        label.setText(MessageText.getString("PeersView.state") + ":");
        this.socks_current = new BufferedLabel(socks_comp, 0x20000000);
        gd = new GridData();
        gd.widthHint = 120;
        Utils.setLayoutData(this.socks_current, gd);
        label = new Label(socks_comp, 0);
        label.setText(MessageText.getString("label.fails") + ":");
        this.socks_fails = new BufferedLabel(socks_comp, 0x20000000);
        gd = new GridData();
        gd.widthHint = 120;
        Utils.setLayoutData(this.socks_fails, gd);
        label = new Label(socks_comp, 0);
        gd = new GridData(768);
        gd.horizontalAlignment = 32;
        this.socks_more = new Label(socks_comp, 0);
        this.socks_more.setText(MessageText.getString("label.more") + "...");
        Utils.setLayoutData((Control)this.socks_more, gd);
        this.socks_more.setCursor(this.socks_more.getDisplay().getSystemCursor(21));
        this.socks_more.setForeground(Colors.blue);
        this.socks_more.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
                PrivacyView.this.showSOCKSInfo();
            }

            @Override
            public void mouseUp(MouseEvent arg0) {
                PrivacyView.this.showSOCKSInfo();
            }
        });
        this.sc.addControlListener(new ControlAdapter(){

            @Override
            public void controlResized(ControlEvent e) {
                Rectangle r = PrivacyView.this.sc.getClientArea();
                Point size = PrivacyView.this.cMainComposite.computeSize(r.width, -1);
                PrivacyView.this.sc.setMinSize(size);
            }
        });
        this.swt_updateFields(null, this.current_dm);
        this.updatePeersEtc(this.current_dm);
        this.updateVPNSocks();
        Rectangle r = this.sc.getClientArea();
        Point size = this.cMainComposite.computeSize(r.width, -1);
        this.sc.setMinSize(size);
        Utils.relayout(this.cMainComposite);
    }

    private void setPrivacyLevel(final int level) {
        if (level != this.privacy_level) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (level == PrivacyView.this.privacy_level) {
                        return;
                    }
                    PrivacyView.this.privacy_level = level;
                    DownloadManager dm = PrivacyView.this.current_dm;
                    if (dm == null) {
                        return;
                    }
                    DownloadManagerState state = dm.getDownloadState();
                    String[] new_nets = level == 0 ? new String[]{"Public"} : (level == 1 ? AENetworkClassifier.AT_NETWORKS : (level == 2 ? AENetworkClassifier.AT_NON_PUBLIC : new String[]{}));
                    state.setNetworks(new_nets);
                    if (level != 0 && !I2PHelpers.isI2PInstalled() && !PrivacyView.this.i2p_install_prompted) {
                        PrivacyView.this.i2p_install_prompted = true;
                        I2PHelpers.installI2PHelper(null, null, new Runnable(){

                            @Override
                            public void run() {
                                PrivacyView.this.updateI2PState();
                            }
                        });
                    }
                }
            });
        }
    }

    private void swt_updateFields(DownloadManager old_dm, DownloadManager new_dm) {
        DownloadManagerState state;
        TOTorrent torrent;
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            return;
        }
        byte[] hash = null;
        if (new_dm != null && (torrent = new_dm.getTorrent()) != null) {
            try {
                hash = torrent.getHash();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.i2p_lookup_button.setData("hash", hash);
        this.updateI2PState();
        Utils.disposeComposite(this.i2p_lookup_comp, false);
        this.i2p_result_summary.setText("");
        this.i2p_result_list.setText("");
        if (old_dm != null) {
            state = old_dm.getDownloadState();
            state.removeListener(this, "networks", 1);
            state.removeListener(this, "peersources", 1);
            state.removeListener(this, "flags", 1);
        }
        if (new_dm != null) {
            state = new_dm.getDownloadState();
            state.addListener(this, "networks", 1);
            state.addListener(this, "peersources", 1);
            state.addListener(this, "flags", 1);
            this.setupNetworksAndSources(new_dm);
            this.setupTorrentTracker(new_dm);
        } else {
            this.setupNetworksAndSources(null);
            this.setupTorrentTracker(null);
        }
    }

    private void setupNetworksAndSources(final DownloadManager dm) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                int i;
                PrivacyView.this.enabled_networks.clear();
                PrivacyView.this.enabled_sources.clear();
                if (PrivacyView.this.network_buttons == null || PrivacyView.this.network_buttons[0].isDisposed()) {
                    return;
                }
                DownloadManagerState state = null;
                String[] networks = null;
                String[] sources = null;
                if (dm != null) {
                    state = dm.getDownloadState();
                    networks = state.getNetworks();
                    sources = state.getPeerSources();
                }
                PrivacyView.this.privacy_scale.setEnabled(networks != null);
                if (networks != null) {
                    PrivacyView.this.enabled_networks.addAll(Arrays.asList(networks));
                    int pl = PrivacyView.this.enabled_networks.contains("Public") ? (PrivacyView.this.enabled_networks.size() == 1 ? 0 : 1) : (PrivacyView.this.enabled_networks.size() == 0 ? 3 : 2);
                    PrivacyView.this.privacy_level = pl;
                    PrivacyView.this.privacy_scale.setSelection(pl * 10);
                }
                for (i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
                    String net = AENetworkClassifier.AT_NETWORKS[i];
                    PrivacyView.this.network_buttons[i].setEnabled(networks != null);
                    PrivacyView.this.network_buttons[i].setSelection(PrivacyView.this.enabled_networks.contains(net));
                }
                if (sources != null) {
                    PrivacyView.this.enabled_sources.addAll(Arrays.asList(sources));
                }
                for (i = 0; i < PEPeerSource.PS_SOURCES.length; ++i) {
                    String source = PEPeerSource.PS_SOURCES[i];
                    PrivacyView.this.source_buttons[i].setEnabled(sources != null && state.isPeerSourcePermitted(source));
                    PrivacyView.this.source_buttons[i].setSelection(PrivacyView.this.enabled_sources.contains(source));
                }
                if (state != null) {
                    PrivacyView.this.ipfilter_enabled.setEnabled(true);
                    PrivacyView.this.ipfilter_enabled.setSelection(!state.getFlag(256L));
                } else {
                    PrivacyView.this.ipfilter_enabled.setEnabled(false);
                }
                PrivacyView.this.setupTorrentTracker(dm);
            }
        });
    }

    private void setupTorrentTracker(final DownloadManager dm) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                ExternalSeedReader[] seeds;
                TOTorrentAnnounceURLSet[] sets;
                TOTorrent torrent;
                if (PrivacyView.this.torrent_info == null || PrivacyView.this.torrent_info.isDisposed()) {
                    return;
                }
                TOTorrent tOTorrent = torrent = dm == null ? null : dm.getTorrent();
                if (torrent == null) {
                    PrivacyView.this.torrent_info.setText("");
                    PrivacyView.this.tracker_info.setText("");
                    PrivacyView.this.webseed_info.setText("");
                    return;
                }
                boolean private_torrent = torrent.getPrivate();
                PrivacyView.this.torrent_info.setText(MessageText.getString(private_torrent ? "label.private" : "subs.prop.is_public"));
                boolean decentralised = false;
                HashSet<String> tracker_nets = new HashSet<String>();
                URL announce_url = torrent.getAnnounceURL();
                if (announce_url != null) {
                    if (TorrentUtils.isDecentralised(announce_url)) {
                        decentralised = true;
                    } else {
                        String net = AENetworkClassifier.categoriseAddress(announce_url.getHost());
                        tracker_nets.add(net);
                    }
                }
                TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
                for (TOTorrentAnnounceURLSet set : sets = group.getAnnounceURLSets()) {
                    URL[] urls = set.getAnnounceURLs();
                    for (URL u : urls) {
                        if (TorrentUtils.isDecentralised(u)) {
                            decentralised = true;
                            continue;
                        }
                        String net = AENetworkClassifier.categoriseAddress(u.getHost());
                        tracker_nets.add(net);
                    }
                }
                boolean tracker_source_enabled = PrivacyView.this.enabled_sources.contains("Tracker");
                boolean dht_source_enabled = PrivacyView.this.enabled_sources.contains("DHT");
                String tracker_str = "";
                tracker_str = MessageText.getString("label.decentralised");
                String disabled_str = MessageText.getString("MyTorrentsView.menu.setSpeed.disabled");
                String net_string = "";
                if (dht_source_enabled && !private_torrent) {
                    for (String net : new String[]{"Public", "I2P"}) {
                        if (!PrivacyView.this.enabled_networks.contains(net)) continue;
                        net_string = net_string + (net_string.length() == 0 ? "" : ", ") + (String)net;
                    }
                }
                tracker_str = net_string.length() == 0 ? tracker_str + " (" + disabled_str + ")" : tracker_str + " [" + net_string + "]";
                for (String net : tracker_nets) {
                    if (!tracker_source_enabled || !PrivacyView.this.enabled_networks.contains(net)) {
                        net = net + " (" + disabled_str + ")";
                    }
                    tracker_str = tracker_str + (tracker_str.length() == 0 ? "" : ", ") + net;
                }
                PrivacyView.this.tracker_info.setText(tracker_str);
                HashSet<String> webseed_nets = new HashSet<String>();
                ExternalSeedPlugin esp = DownloadManagerController.getExternalSeedPlugin();
                if (esp != null && (seeds = esp.getManualWebSeeds(PluginCoreUtils.wrap(torrent))) != null) {
                    for (ExternalSeedReader seed : seeds) {
                        URL u = seed.getURL();
                        String net = AENetworkClassifier.categoriseAddress(u.getHost());
                        webseed_nets.add(net);
                    }
                }
                String webseeds_str = "";
                if (webseed_nets.isEmpty()) {
                    webseeds_str = MessageText.getString("PeersView.uniquepiece.none");
                } else {
                    for (String net : webseed_nets) {
                        if (!PrivacyView.this.enabled_networks.contains(net)) {
                            net = net + " (" + disabled_str + ")";
                        }
                        webseeds_str = webseeds_str + (webseeds_str.length() == 0 ? "" : ", ") + net;
                    }
                }
                PrivacyView.this.webseed_info.setText(webseeds_str);
            }
        });
    }

    private void updatePeersEtc(final DownloadManager dm) {
        final PEPeerManager pm = dm != null ? dm.getPeerManager() : null;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (PrivacyView.this.peer_info == null || PrivacyView.this.peer_info.isDisposed()) {
                    return;
                }
                if (pm == null) {
                    PrivacyView.this.peer_info.setText(dm == null ? "" : MessageText.getString("privacy.view.dl.not.running"));
                } else {
                    AEProxySelector proxy_selector = AEProxySelectorFactory.getSelector();
                    Proxy proxy = proxy_selector.getActiveProxy();
                    boolean socks_bad_incoming = false;
                    List<PEPeer> peers = pm.getPeers();
                    String[] all_nets = AENetworkClassifier.AT_NETWORKS;
                    int[] counts = new int[all_nets.length];
                    int incoming = 0;
                    int outgoing = 0;
                    int outgoing_connected = 0;
                    for (PEPeer peer : peers) {
                        boolean is_incoming;
                        String net = PeerUtils.getNetwork(peer);
                        for (int i = 0; i < all_nets.length; ++i) {
                            if (all_nets[i] != net) continue;
                            int n = i;
                            counts[n] = counts[n] + 1;
                            break;
                        }
                        if (is_incoming = peer.isIncoming()) {
                            ++incoming;
                        } else {
                            ++outgoing;
                            if (peer.getPeerState() == 30) {
                                ++outgoing_connected;
                            }
                        }
                        if (proxy == null || !is_incoming || peer.isLANLocal()) continue;
                        try {
                            if (InetAddress.getByAddress(HostNameToIPResolver.hostAddressToBytes(peer.getIp())).isLoopbackAddress()) {
                                continue;
                            }
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        socks_bad_incoming = true;
                        break;
                    }
                    String str = "";
                    for (int i = 0; i < all_nets.length; ++i) {
                        int num = counts[i];
                        if (num <= 0) continue;
                        str = str + (str.length() == 0 ? "" : ", ") + all_nets[i] + "=" + num;
                    }
                    str = str.length() == 0 ? MessageText.getString("privacy.view.no.peers") : str + ", " + MessageText.getString("label.incoming") + "=" + incoming + ", " + MessageText.getString("label.outgoing") + "=" + outgoing_connected + "/" + outgoing;
                    if (socks_bad_incoming) {
                        str = str + " (" + MessageText.getString("privacy.view.non.local.peer") + ")";
                    }
                    PrivacyView.this.peer_info.setText(str);
                }
                PrivacyView.this.updateVPNSocks();
            }
        });
    }

    private void updateVPNSocks() {
        AEProxySelector proxy_selector = AEProxySelectorFactory.getSelector();
        Proxy proxy = proxy_selector.getActiveProxy();
        this.socks_more.setEnabled(proxy != null);
        if (Constants.isOSX) {
            this.socks_more.setForeground(proxy == null ? Colors.light_grey : Colors.blue);
        }
        this.socks_state.setText(proxy == null ? MessageText.getString("label.inactive") : ((InetSocketAddress)proxy.address()).getHostName());
        if (proxy == null) {
            this.socks_current.setText("");
            this.socks_fails.setText("");
        } else {
            long last_con = proxy_selector.getLastConnectionTime();
            long last_fail = proxy_selector.getLastFailTime();
            int total_cons = proxy_selector.getConnectionCount();
            int total_fails = proxy_selector.getFailCount();
            long now = SystemTime.getMonotonousTime();
            long con_ago = now - last_con;
            long fail_ago = now - last_fail;
            String state_str = last_fail < 0L ? "PeerManager.status.ok" : (fail_ago > 60000L ? (con_ago < fail_ago ? "PeerManager.status.ok" : "SpeedView.stats.unknown") : "ManagerItem.error");
            this.socks_current.setText(MessageText.getString(state_str) + ", con=" + total_cons);
            long fail_ago_secs = fail_ago / 1000L;
            if (fail_ago_secs == 0L) {
                fail_ago_secs = 1L;
            }
            this.socks_fails.setText(last_fail < 0L ? "" : DisplayFormatters.formatETA(fail_ago_secs, false) + " " + MessageText.getString("label.ago") + ", tot=" + total_fails);
        }
        this.vpn_info.setText(NetworkAdmin.getSingleton().getBindStatus());
    }

    private void updateI2PState() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                boolean i2p_installed = I2PHelpers.isI2PInstalled();
                PrivacyView.this.i2p_install_button.setText(MessageText.getString(i2p_installed ? "devices.installed" : "privacy.view.install.i2p"));
                PrivacyView.this.i2p_install_button.setEnabled(!i2p_installed);
                PrivacyView.this.i2p_lookup_button.setEnabled(i2p_installed && PrivacyView.this.i2p_lookup_button.getData("hash") != null);
                PrivacyView.this.i2p_options_link.setEnabled(i2p_installed);
            }
        });
    }

    @Override
    public void attributeEventOccurred(DownloadManager download, String attribute, int event_type) {
        this.setupNetworksAndSources(download);
    }

    private void showSOCKSInfo() {
        AEProxySelector proxy_selector = AEProxySelectorFactory.getSelector();
        String info = proxy_selector.getInfo();
        TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("proxy.info.title"), null, info, false);
    }

    private GridLayout removeMarginsAndSpacing(GridLayout layout) {
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    private GridLayout removeMargins(GridLayout layout) {
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }
}

