/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPieceListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.Legend;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListenerEx;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventImpl;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.piece.MyPieceDistributionView;
import org.gudy.azureus2.ui.swt.views.piece.PieceInfoView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_TabsCommon;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.AvailabilityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.BlockCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.BlocksItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.CompletedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.PieceNumberItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.PriorityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.RequestedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.ReservedByItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.SpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.TypeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.WritersItem;

public class PiecesView
extends TableViewTab<PEPiece>
implements DownloadManagerPeerListener,
DownloadManagerPieceListener,
TableDataSourceChangedListener,
TableLifeCycleListener,
TableViewSWTMenuFillListener,
UISWTViewCoreEventListenerEx {
    private static boolean registeredCoreSubViews = false;
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new PieceNumberItem(), new SizeItem(), new BlockCountItem(), new BlocksItem(), new CompletedItem(), new AvailabilityItem(), new TypeItem(), new ReservedByItem(), new WritersItem(), new PriorityItem(), new SpeedItem(), new RequestedItem()};
    public static final String MSGID_PREFIX = "PiecesView";
    private DownloadManager manager;
    private boolean enable_tabs = true;
    private TableViewSWT<PEPiece> tv;
    private Composite legendComposite;
    private boolean comp_focused;
    private Object focus_pending_ds;

    public PiecesView() {
        super(MSGID_PREFIX);
    }

    @Override
    public boolean isCloneable() {
        return true;
    }

    @Override
    public UISWTViewCoreEventListener getClone() {
        return new PiecesView();
    }

    @Override
    public TableViewSWT<PEPiece> initYourTableView() {
        UISWTInstance pluginUI;
        this.tv = TableViewFactory.createTableViewSWT(PEPiece.class, "Pieces", this.getPropertiesPrefix(), basicItems, basicItems[0].getName(), 0x10010004);
        this.tv.setEnableTabViews(this.enable_tabs, true, null);
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null && (pluginUI = uiFunctions.getUISWTInstance()) != null && !registeredCoreSubViews) {
            pluginUI.addView("Pieces", "PieceInfoView", PieceInfoView.class, this.manager);
            pluginUI.addView("Pieces", "MyPieceDistributionView", MyPieceDistributionView.class, this.manager);
            registeredCoreSubViews = true;
        }
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.addMenuFillListener(this);
        this.tv.addLifeCycleListener(this);
        return this.tv;
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        final List<Object> selected = this.tv.getSelectedDataSources();
        if (selected.size() == 0) {
            return;
        }
        if (this.manager == null) {
            return;
        }
        PEPeerManager pm = this.manager.getPeerManager();
        if (pm == null) {
            return;
        }
        final PiecePicker picker = pm.getPiecePicker();
        boolean has_undone = false;
        boolean has_unforced = false;
        for (Object obj : selected) {
            PEPiece piece = (PEPiece)obj;
            if (piece.getDMPiece().isDone()) continue;
            has_undone = true;
            if (!picker.isForcePiece(piece.getPieceNumber())) continue;
            has_unforced = true;
        }
        final MenuItem force_piece = new MenuItem(menu, 32);
        Messages.setLanguageText(force_piece, "label.force.piece");
        force_piece.setEnabled(has_undone);
        if (has_undone) {
            force_piece.setSelection(has_unforced);
            force_piece.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    boolean forced = force_piece.getSelection();
                    for (Object obj : selected) {
                        PEPiece piece = (PEPiece)obj;
                        if (piece.getDMPiece().isDone()) continue;
                        picker.setForcePiece(piece.getPieceNumber(), forced);
                    }
                }
            });
        }
        MenuItem cancel_reqs_piece = new MenuItem(menu, 8);
        Messages.setLanguageText(cancel_reqs_piece, "label.rerequest.blocks");
        cancel_reqs_piece.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                for (Object obj : selected) {
                    PEPiece piece = (PEPiece)obj;
                    for (int i = 0; i < piece.getNbBlocks(); ++i) {
                        if (!piece.isRequested(i)) continue;
                        piece.clearRequested(i);
                    }
                }
            }
        });
        MenuItem reset_piece = new MenuItem(menu, 8);
        Messages.setLanguageText(reset_piece, "label.reset.piece");
        reset_piece.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                for (Object obj : selected) {
                    PEPiece piece = (PEPiece)obj;
                    piece.reset();
                }
            }
        });
        new MenuItem(menu, 2);
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
    }

    private void setFocused(boolean foc) {
        if (foc) {
            this.comp_focused = true;
            this.dataSourceChanged(this.focus_pending_ds);
        } else {
            this.focus_pending_ds = this.manager;
            this.dataSourceChanged(null);
            this.comp_focused = false;
        }
    }

    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        if (!this.comp_focused) {
            this.focus_pending_ds = newDataSource;
            return;
        }
        DownloadManager newManager = ViewUtils.getDownloadManagerFromDataSource(newDataSource);
        if (newManager == this.manager) {
            this.tv.setEnabled(this.manager != null);
            return;
        }
        if (this.manager != null) {
            this.manager.removePeerListener(this);
            this.manager.removePieceListener(this);
        }
        this.manager = newManager;
        if (this.tv.isDisposed()) {
            return;
        }
        this.tv.removeAllTableRows();
        this.tv.setEnabled(this.manager != null);
        if (this.manager != null) {
            this.manager.addPeerListener(this, false);
            this.manager.addPieceListener(this, false);
            this.addExistingDatasources();
        }
    }

    @Override
    public void tableViewInitialized() {
        if (this.legendComposite != null && this.tv != null) {
            Composite composite = this.tv.getTableComposite();
            this.legendComposite = Legend.createLegendComposite(composite, BlocksItem.colors, new String[]{"PiecesView.legend.requested", "PiecesView.legend.written", "PiecesView.legend.downloaded", "PiecesView.legend.incache"});
        }
        if (this.manager != null) {
            this.manager.removePeerListener(this);
            this.manager.removePieceListener(this);
            this.manager.addPeerListener(this, false);
            this.manager.addPieceListener(this, false);
            this.addExistingDatasources();
        }
    }

    @Override
    public void tableViewDestroyed() {
        if (this.legendComposite != null && this.legendComposite.isDisposed()) {
            this.legendComposite.dispose();
        }
        if (this.manager != null) {
            this.manager.removePeerListener(this);
            this.manager.removePieceListener(this);
        }
    }

    @Override
    public void pieceAdded(PEPiece created) {
        this.tv.addDataSource(created);
    }

    @Override
    public void pieceRemoved(PEPiece removed) {
        this.tv.removeDataSource(removed);
    }

    @Override
    public void peerAdded(PEPeer peer) {
    }

    @Override
    public void peerRemoved(PEPeer peer) {
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
        this.tv.removeAllTableRows();
    }

    private void addExistingDatasources() {
        TableViewSWT_TabsCommon tabs;
        if (this.manager == null || this.tv.isDisposed()) {
            return;
        }
        PEPiece[] dataSources = this.manager.getCurrentPieces();
        if (dataSources != null && dataSources.length >= 0) {
            this.tv.addDataSources((PEPiece[])dataSources);
            this.tv.processDataSourceQueue();
        }
        if ((tabs = this.tv.getTabsCommon()) != null) {
            tabs.triggerTabViewsDataSourceChanged(this.tv);
        }
    }

    public DownloadManager getManager() {
        return this.manager;
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                if (!(event2 instanceof UISWTViewEventImpl)) break;
                String parent = ((UISWTViewEventImpl)event2).getParentID();
                this.enable_tabs = parent != null && parent.equals("TorrentDetailsView");
                break;
            }
            case 3: {
                String id = "DMDetails_Pieces";
                this.setFocused(true);
                if (this.manager != null) {
                    id = this.manager.getTorrent() != null ? id + "." + this.manager.getInternalName() : id + ":" + this.manager.getSize();
                    SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(this.manager)});
                    break;
                }
                SelectedContentManager.changeCurrentlySelectedContent(id, null);
                break;
            }
            case 4: {
                this.setFocused(false);
                SelectedContentManager.clearCurrentlySelectedContent();
            }
        }
        return super.eventOccurred(event2);
    }

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames("Pieces", basicItems);
    }
}

