/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.views.utils.CoordinateTransform;

public abstract class PieceDistributionView
implements UISWTViewCoreEventListener {
    private Composite comp;
    private Canvas pieceDistCanvas;
    protected PEPeerManager pem;
    protected boolean[] hasPieces;
    protected boolean isMe = false;
    private boolean initialized = false;
    private Image imgToPaint = null;
    private UISWTView swtView;

    public abstract void dataSourceChanged(Object var1);

    private String getFullTitle() {
        return MessageText.getString("PiecesView.DistributionView.title");
    }

    private void initialize(Composite parent) {
        this.comp = new Composite(parent, 0);
        this.createPieceDistPanel();
        this.initialized = true;
        this.refresh();
    }

    private void createPieceDistPanel() {
        this.comp.setLayout(new FillLayout());
        this.pieceDistCanvas = new Canvas(this.comp, 262144);
        this.pieceDistCanvas.addListener(9, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                if (PieceDistributionView.this.pem == null || PieceDistributionView.this.pem.isDestroyed()) {
                    event2.gc.fillRectangle(event2.x, event2.y, event2.width, event2.height);
                } else if (PieceDistributionView.this.imgToPaint != null && !PieceDistributionView.this.imgToPaint.isDisposed()) {
                    event2.gc.drawImage(PieceDistributionView.this.imgToPaint, 0, 0);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateDistribution() {
        if (!this.initialized || this.pem == null || this.comp == null || this.pem.getPiecePicker() == null || this.pem.getDiskManager() == null || !this.comp.isVisible()) {
            return;
        }
        Rectangle rect = this.pieceDistCanvas.getBounds();
        if (rect.height <= 0 || rect.width <= 0) {
            return;
        }
        PiecePicker picker = this.pem.getPiecePicker();
        int seeds = this.pem.getNbSeeds() + (this.pem.isSeeding() ? 1 : 0);
        int connected = this.pem.getNbPeers() + seeds + (this.pem.isSeeding() ? 0 : 1);
        int upperBound = 1 + (1 << (int)Math.ceil(Math.log((double)connected + 0.0) / Math.log(2.0)));
        int minAvail = (int)picker.getMinAvailability();
        int nbPieces = picker.getNumberOfPieces();
        int[] availabilties = picker.getAvailability();
        DiskManagerPiece[] dmPieces = this.pem.getDiskManager().getPieces();
        PEPiece[] pePieces = this.pem.getPieces();
        int[] globalPiecesPerAvailability = new int[upperBound];
        int[] datasourcePiecesPerAvailability = new int[upperBound];
        boolean[] downloading = new boolean[upperBound];
        int avlPeak = 0;
        for (int i = 0; i < nbPieces; ++i) {
            if (availabilties[i] >= upperBound) {
                return;
            }
            int n = availabilties[i];
            int n2 = globalPiecesPerAvailability[n] + 1;
            globalPiecesPerAvailability[n] = n2;
            int newPeak = n2;
            if (avlPeak < n2) {
                avlPeak = newPeak;
            }
            if (this.isMe && dmPieces[i].isDone() || !this.isMe && this.hasPieces != null && this.hasPieces[i]) {
                int n3 = availabilties[i];
                datasourcePiecesPerAvailability[n3] = datasourcePiecesPerAvailability[n3] + 1;
            }
            if (!this.isMe || pePieces[i] == null) continue;
            downloading[availabilties[i]] = true;
        }
        Image img = new Image((Device)this.comp.getDisplay(), this.pieceDistCanvas.getBounds());
        GC gc = new GC(img);
        try {
            int stepWidthX = rect.width / upperBound;
            int barGap = 1;
            int barWidth = stepWidthX - barGap - 1;
            int barFillingWidth = barWidth - 1;
            double stepWidthY = 1.0 * (double)(rect.height - 1) / (double)avlPeak;
            int offsetY = rect.height;
            gc.setForeground(Colors.green);
            for (int i = 0; i <= connected; ++i) {
                Color curColor = i == 0 ? Colors.colorError : (i <= seeds ? Colors.green : Colors.blues[9]);
                gc.setBackground(curColor);
                gc.setForeground(curColor);
                if (globalPiecesPerAvailability[i] == 0) {
                    gc.setLineWidth(2);
                    gc.drawLine(stepWidthX * i, offsetY - 1, stepWidthX * (i + 1) - barGap, offsetY - 1);
                } else {
                    gc.setLineWidth(1);
                    if (downloading[i]) {
                        gc.setLineStyle(2);
                    }
                    gc.fillRectangle(stepWidthX * i + 1, offsetY - 1, barFillingWidth, (int)(Math.ceil(stepWidthY * (double)datasourcePiecesPerAvailability[i] - 1.0) * -1.0));
                    gc.drawRectangle(stepWidthX * i, offsetY, barWidth, (int)(Math.ceil(stepWidthY * (double)globalPiecesPerAvailability[i]) + 1.0) * -1);
                }
                if (i == minAvail) {
                    gc.setForeground(Colors.blue);
                    gc.drawRectangle(stepWidthX * i + 1, offsetY - 1, barWidth - 2, (int)Math.ceil(stepWidthY * (double)globalPiecesPerAvailability[i] - 1.0) * -1);
                }
                gc.setLineStyle(1);
            }
            gc.setLineWidth(1);
            CoordinateTransform t = new CoordinateTransform(rect);
            t.shiftExternal(rect.width, 0);
            t.scale(-1.0, 1.0);
            String[] boxContent = new String[]{MessageText.getString("PiecesView.DistributionView.NoAvl"), MessageText.getString("PiecesView.DistributionView.SeedAvl"), MessageText.getString("PiecesView.DistributionView.PeerAvl"), MessageText.getString("PiecesView.DistributionView.RarestAvl", new String[]{globalPiecesPerAvailability[minAvail] + "", minAvail + ""}), MessageText.getString("PiecesView.DistributionView." + (this.isMe ? "weHave" : "theyHave")), MessageText.getString("PiecesView.DistributionView.weDownload")};
            int charWidth = gc.getFontMetrics().getAverageCharWidth();
            int charHeight = gc.getFontMetrics().getHeight();
            int maxBoxOffsetY = charHeight + 2;
            int maxBoxWidth = 0;
            int maxBoxOffsetX = 0;
            for (int i = 0; i < boxContent.length; ++i) {
                maxBoxWidth = Math.max(maxBoxWidth, boxContent[i].length());
            }
            maxBoxOffsetX = (maxBoxWidth + 5) * charWidth;
            ++maxBoxWidth;
            int boxNum = 1;
            gc.setForeground(Colors.colorError);
            gc.setBackground(Colors.background);
            gc.drawRectangle(t.x(maxBoxOffsetX), t.y(maxBoxOffsetY * boxNum), maxBoxWidth *= charWidth, charHeight);
            gc.drawString(boxContent[boxNum - 1], t.x(maxBoxOffsetX - 5), t.y(maxBoxOffsetY * boxNum), true);
            gc.setForeground(Colors.green);
            gc.setBackground(Colors.background);
            gc.drawRectangle(t.x(maxBoxOffsetX), t.y(maxBoxOffsetY * ++boxNum), maxBoxWidth, charHeight);
            gc.drawString(boxContent[boxNum - 1], t.x(maxBoxOffsetX - 5), t.y(maxBoxOffsetY * boxNum), true);
            gc.setForeground(Colors.blues[9]);
            gc.drawRectangle(t.x(maxBoxOffsetX), t.y(maxBoxOffsetY * ++boxNum), maxBoxWidth, charHeight);
            gc.drawString(boxContent[boxNum - 1], t.x(maxBoxOffsetX - 5), t.y(maxBoxOffsetY * boxNum), true);
            gc.setForeground(Colors.blue);
            gc.drawRectangle(t.x(maxBoxOffsetX), t.y(maxBoxOffsetY * ++boxNum), maxBoxWidth, charHeight);
            gc.drawString(boxContent[boxNum - 1], t.x(maxBoxOffsetX - 5), t.y(maxBoxOffsetY * boxNum), true);
            gc.setForeground(Colors.black);
            gc.setBackground(Colors.black);
            gc.drawRectangle(t.x(maxBoxOffsetX), t.y(maxBoxOffsetY * ++boxNum), maxBoxWidth, charHeight);
            gc.fillRectangle(t.x(maxBoxOffsetX), t.y(maxBoxOffsetY * boxNum), maxBoxWidth / 2, charHeight);
            gc.setForeground(Colors.grey);
            gc.setBackground(Colors.background);
            gc.drawString(boxContent[boxNum - 1], t.x(maxBoxOffsetX - 5), t.y(maxBoxOffsetY * boxNum), true);
            if (this.isMe) {
                gc.setForeground(Colors.black);
                gc.setLineStyle(2);
                gc.drawRectangle(t.x(maxBoxOffsetX), t.y(maxBoxOffsetY * ++boxNum), maxBoxWidth, charHeight);
                gc.drawString(boxContent[boxNum - 1], t.x(maxBoxOffsetX - 5), t.y(maxBoxOffsetY * boxNum), true);
            }
            gc.setLineStyle(1);
        }
        finally {
            gc.dispose();
        }
        if (this.imgToPaint != null) {
            this.imgToPaint.dispose();
        }
        this.imgToPaint = img;
        this.pieceDistCanvas.redraw();
    }

    public void refresh() {
        if (!this.initialized || this.pem == null) {
            return;
        }
        this.updateDistribution();
    }

    private Composite getComposite() {
        return this.comp;
    }

    private void delete() {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        Utils.disposeSWTObjects(new Object[]{this.pieceDistCanvas, this.comp, this.imgToPaint});
    }

    private void viewActivated() {
        this.updateDistribution();
    }

    private void viewDeactivated() {
        Utils.disposeSWTObjects(new Object[]{this.imgToPaint});
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl(this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                this.viewActivated();
                break;
            }
            case 4: {
                this.viewDeactivated();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

